/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.expression.Expression;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;

public abstract class VariExpression<T>
implements Expression<T> {
    protected Expression<?>[] operands;

    protected VariExpression() {
    }

    protected VariExpression(Expression<?> ... operands) {
        this.operands = operands;
    }

    @Nonnull
    public Expression<?>[] operands() {
        return this.operands;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.operands.length);
        for (Expression<?> operand : this.operands) {
            out.writeObject(operand);
        }
    }

    public void readData(ObjectDataInput in) throws IOException {
        int length = in.readInt();
        this.operands = new Expression[length];
        for (int i = 0; i < length; ++i) {
            this.operands[i] = (Expression)in.readObject();
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.operands);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariExpression that = (VariExpression)o;
        return Arrays.equals(this.operands, that.operands);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{operands=" + Arrays.toString(this.operands) + '}';
    }

    @Override
    public boolean isCooperative() {
        for (Expression<?> operand : this.operands) {
            if (operand.isCooperative()) continue;
            return false;
        }
        return true;
    }
}

