/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.jet.sql.impl.CalciteConfiguration;
import com.hazelcast.jet.sql.impl.HazelcastRexBuilder;
import com.hazelcast.jet.sql.impl.QueryPlanner;
import com.hazelcast.jet.sql.impl.opt.cost.CostFactory;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMdBoundedness;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMdRowCount;
import com.hazelcast.jet.sql.impl.opt.metadata.HazelcastRelMdWatermarkedFields;
import com.hazelcast.jet.sql.impl.parse.QueryConvertResult;
import com.hazelcast.jet.sql.impl.parse.QueryConverter;
import com.hazelcast.jet.sql.impl.parse.QueryParseResult;
import com.hazelcast.jet.sql.impl.parse.QueryParser;
import com.hazelcast.jet.sql.impl.schema.HazelcastCalciteCatalogReader;
import com.hazelcast.jet.sql.impl.schema.HazelcastSchema;
import com.hazelcast.jet.sql.impl.schema.HazelcastSchemaUtils;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlValidator;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.logging.ILogger;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.config.CalciteConnectionConfig;
import com.hazelcast.shaded.org.apache.calcite.jdbc.CalciteSchema;
import com.hazelcast.shaded.org.apache.calcite.jdbc.HazelcastRootCalciteSchema;
import com.hazelcast.shaded.org.apache.calcite.plan.Contexts;
import com.hazelcast.shaded.org.apache.calcite.plan.ConventionTraitDef;
import com.hazelcast.shaded.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.plan.volcano.VolcanoPlanner;
import com.hazelcast.shaded.org.apache.calcite.prepare.Prepare;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.DefaultRelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataProvider;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.tools.RuleSet;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.schema.IMapResolver;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public final class OptimizerContext {
    private static final ThreadLocal<OptimizerContext> THREAD_CONTEXT = new ThreadLocal();
    private static final RelMetadataProvider METADATA_PROVIDER = ChainedRelMetadataProvider.of(ImmutableList.of(HazelcastRelMdRowCount.SOURCE, HazelcastRelMdBoundedness.SOURCE, HazelcastRelMdWatermarkedFields.SOURCE, DefaultRelMetadataProvider.INSTANCE));
    private static final CalciteConnectionConfig CONNECTION_CONFIG = CalciteConfiguration.DEFAULT.toConnectionConfig();
    private final HazelcastRelOptCluster cluster;
    private final QueryParser parser;
    private final QueryConverter converter;
    private final QueryPlanner planner;
    private final Set<PlanObjectKey> usedViews = new HashSet<PlanObjectKey>();
    private final Deque<String> viewExpansionStack = new ArrayDeque<String>();
    private final SqlSecurityContext sqlSecurityContext;

    private OptimizerContext(HazelcastRelOptCluster cluster, QueryParser parser, QueryConverter converter, QueryPlanner planner, SqlSecurityContext sqlSecurityContext) {
        this.cluster = cluster;
        this.parser = parser;
        this.converter = converter;
        this.planner = planner;
        this.sqlSecurityContext = sqlSecurityContext;
    }

    public static OptimizerContext create(SqlCatalog schema, List<List<String>> searchPaths, List<Object> arguments, int memberCount, IMapResolver iMapResolver, SqlSecurityContext ssc) {
        HazelcastSchema rootSchema = HazelcastSchemaUtils.createRootSchema(schema);
        return OptimizerContext.create(rootSchema, searchPaths, arguments, memberCount, iMapResolver, ssc);
    }

    public static OptimizerContext create(HazelcastSchema rootSchema, List<List<String>> schemaPaths, List<Object> arguments, int memberCount, IMapResolver iMapResolver, @Nonnull SqlSecurityContext ssc) {
        Prepare.CatalogReader catalogReader = OptimizerContext.createCatalogReader(rootSchema, schemaPaths);
        HazelcastSqlValidator validator = new HazelcastSqlValidator(catalogReader, arguments, iMapResolver, ssc);
        VolcanoPlanner volcanoPlanner = OptimizerContext.createPlanner();
        HazelcastRelOptCluster cluster = OptimizerContext.createCluster(volcanoPlanner, ssc);
        QueryParser parser = new QueryParser(validator);
        QueryConverter converter = new QueryConverter(validator, catalogReader, cluster);
        QueryPlanner planner = new QueryPlanner(volcanoPlanner);
        return new OptimizerContext(cluster, parser, converter, planner, ssc);
    }

    public static void setThreadContext(OptimizerContext context) {
        THREAD_CONTEXT.set(context);
    }

    public static OptimizerContext getThreadContext() {
        return THREAD_CONTEXT.get();
    }

    public QueryParseResult parse(String sql) {
        return this.parser.parse(sql, this.sqlSecurityContext);
    }

    public QueryConvertResult convert(SqlNode node) {
        return this.converter.convert(node);
    }

    public RelNode convertView(SqlNode node) {
        return this.converter.convertView(node);
    }

    public RelNode optimize(RelNode node, RuleSet rules, RelTraitSet traitSet) {
        return this.planner.optimize(node, rules, traitSet);
    }

    public void setParameterMetadata(QueryParameterMetadata parameterMetadata) {
        this.cluster.setParameterMetadata(parameterMetadata);
    }

    public void setRequiresJob(boolean requiresJob) {
        this.cluster.setRequiresJob(requiresJob);
    }

    private static Prepare.CatalogReader createCatalogReader(HazelcastSchema rootSchema, List<List<String>> searchPaths) {
        assert (searchPaths != null);
        return new HazelcastCalciteCatalogReader((CalciteSchema)new HazelcastRootCalciteSchema(rootSchema), searchPaths, (RelDataTypeFactory)HazelcastTypeFactory.INSTANCE, CONNECTION_CONFIG);
    }

    private static VolcanoPlanner createPlanner() {
        VolcanoPlanner planner = new VolcanoPlanner(CostFactory.INSTANCE, Contexts.of((Object)CONNECTION_CONFIG));
        planner.clearRelTraitDefs();
        planner.addRelTraitDef(ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef(RelCollationTraitDef.INSTANCE);
        return planner;
    }

    private static HazelcastRelOptCluster createCluster(VolcanoPlanner planner, SqlSecurityContext ssc) {
        HazelcastRelOptCluster cluster = HazelcastRelOptCluster.create(planner, HazelcastRexBuilder.INSTANCE, ssc);
        cluster.setMetadataProvider(JaninoRelMetadataProvider.of(METADATA_PROVIDER));
        return cluster;
    }

    public Deque<String> getViewExpansionStack() {
        return this.viewExpansionStack;
    }

    public Set<PlanObjectKey> getUsedViews() {
        return this.usedViews;
    }

    public void dump(ILogger logger) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.planner.dump(pw);
        pw.flush();
        logger.info(sw.toString());
    }
}

