/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.BitmapIndexOptions;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.DataConnection;
import com.hazelcast.dataconnection.impl.DataConnectionServiceImpl;
import com.hazelcast.dataconnection.impl.InternalDataConnectionService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.JobStateSnapshot;
import com.hazelcast.jet.RestartableException;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.AbstractJetInstance;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.util.ExceptionUtil;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.OptimizerContext;
import com.hazelcast.jet.sql.impl.QueryResultProducerImpl;
import com.hazelcast.jet.sql.impl.SqlPlanImpl;
import com.hazelcast.jet.sql.impl.SqlResultImpl;
import com.hazelcast.jet.sql.impl.StaticQueryResultProducerImpl;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.DataConnectionResolver;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.jet.sql.impl.schema.TypeDefinitionColumn;
import com.hazelcast.jet.sql.impl.schema.TypesUtils;
import com.hazelcast.jet.sql.impl.validate.UpdateDataConnectionOperation;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.EntryRemovingProcessor;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.proxy.MapProxyImpl;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.QueryResultProducer;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.UpdateSqlResultImpl;
import com.hazelcast.sql.impl.expression.ExpressionEvalContextImpl;
import com.hazelcast.sql.impl.row.EmptyRow;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import com.hazelcast.sql.impl.schema.type.Type;
import com.hazelcast.sql.impl.schema.type.TypeKind;
import com.hazelcast.sql.impl.schema.view.View;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.sql.impl.state.QueryResultRegistry;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PlanExecutor {
    private static final String LE = System.lineSeparator();
    private static final String DEFAULT_UNIQUE_KEY = "__key";
    private static final String DEFAULT_UNIQUE_KEY_TRANSFORMATION = "OBJECT";
    private final TableResolverImpl catalog;
    private final DataConnectionResolver dataConnectionCatalog;
    private final HazelcastInstance hazelcastInstance;
    private final NodeEngine nodeEngine;
    private final QueryResultRegistry resultRegistry;
    private final ILogger logger;
    private final AtomicLong directIMapQueriesExecuted = new AtomicLong();

    public PlanExecutor(NodeEngine nodeEngine, TableResolverImpl catalog, DataConnectionResolver dataConnectionResolver, QueryResultRegistry resultRegistry) {
        this.nodeEngine = nodeEngine;
        this.hazelcastInstance = nodeEngine.getHazelcastInstance();
        this.catalog = catalog;
        this.dataConnectionCatalog = dataConnectionResolver;
        this.resultRegistry = resultRegistry;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    SqlResult execute(SqlPlanImpl.CreateMappingPlan plan, SqlSecurityContext ssc) {
        this.catalog.createMapping(plan.mapping(), plan.replace(), plan.ifNotExists(), ssc);
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.DropMappingPlan plan) {
        this.catalog.removeMapping(plan.name(), plan.ifExists());
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.CreateDataConnectionPlan plan) {
        InternalDataConnectionService dlService = this.nodeEngine.getDataConnectionService();
        assert (!plan.ifNotExists() || !plan.isReplace());
        if (dlService.existsConfigDataConnection(plan.name())) {
            throw new HazelcastException("Cannot replace a data connection created from configuration");
        }
        dlService.classForDataConnectionType(plan.type());
        boolean added = this.dataConnectionCatalog.createDataConnection(new DataConnectionCatalogEntry(plan.name(), plan.type().toLowerCase(Locale.ROOT), plan.shared(), plan.options()), plan.isReplace(), plan.ifNotExists());
        if (added) {
            this.broadcastUpdateDataConnectionOperations(plan.name());
            this.dataConnectionCatalog.invokeChangeListeners();
        }
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.DropDataConnectionPlan plan) {
        InternalDataConnectionService dlService = this.nodeEngine.getDataConnectionService();
        if (dlService.existsConfigDataConnection(plan.name())) {
            throw new HazelcastException("Data connection '" + plan.name() + "' is configured via Config and can't be removed");
        }
        this.dataConnectionCatalog.removeDataConnection(plan.name(), plan.ifExists());
        this.broadcastUpdateDataConnectionOperations(plan.name());
        this.dataConnectionCatalog.invokeChangeListeners();
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.CreateIndexPlan plan) {
        MapContainer mapContainer;
        if (!plan.ifNotExists() && (mapContainer = PlanExecutor.getMapContainer(this.hazelcastInstance.getMap(plan.mapName()))).getIndexes().getIndex(plan.indexName()) != null) {
            throw QueryException.error((String)("Can't create index: index '" + plan.indexName() + "' already exists"));
        }
        IndexConfig indexConfig = new IndexConfig(plan.indexType(), plan.attributes()).setName(plan.indexName());
        if (plan.indexType().equals((Object)IndexType.BITMAP)) {
            String uniqueKeyTransform;
            Map<String, String> options = plan.options();
            String uniqueKey = options.get("unique_key");
            if (uniqueKey == null) {
                uniqueKey = DEFAULT_UNIQUE_KEY;
            }
            if ((uniqueKeyTransform = options.get("unique_key_transformation")) == null) {
                uniqueKeyTransform = DEFAULT_UNIQUE_KEY_TRANSFORMATION;
            }
            BitmapIndexOptions bitmapIndexOptions = new BitmapIndexOptions();
            bitmapIndexOptions.setUniqueKey(uniqueKey);
            bitmapIndexOptions.setUniqueKeyTransformation(BitmapIndexOptions.UniqueKeyTransformation.fromName((String)uniqueKeyTransform));
            indexConfig.setBitmapIndexOptions(bitmapIndexOptions);
        }
        this.hazelcastInstance.getMap(plan.mapName()).addIndex(indexConfig);
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.CreateJobPlan plan, List<Object> arguments) {
        List<Object> args = this.prepareArguments(plan.getParameterMetadata(), arguments);
        boolean isStreamingJob = plan.isInfiniteRows();
        JobConfig jobConfig = plan.getJobConfig().setArgument("__sql.arguments", args).setArgument("__sql.queryText", (Object)plan.getQuery()).setArgument("__sql.queryUnbounded", (Object)isStreamingJob);
        if (!jobConfig.isSuspendOnFailure()) {
            jobConfig.setSuspendOnFailure(isStreamingJob);
        }
        if (plan.isIfNotExists()) {
            this.hazelcastInstance.getJet().newJobIfAbsent(plan.getExecutionPlan().getDag(), jobConfig);
        } else {
            this.hazelcastInstance.getJet().newJob(plan.getExecutionPlan().getDag(), jobConfig);
        }
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.AlterJobPlan plan) {
        Job job = this.hazelcastInstance.getJet().getJob(plan.getJobName());
        if (job == null) {
            throw QueryException.error((String)("The job '" + plan.getJobName() + "' doesn't exist"));
        }
        assert (plan.getDeltaConfig() != null || plan.getOperation() != null);
        if (plan.getDeltaConfig() != null) {
            try {
                job.updateConfig(plan.getDeltaConfig());
            }
            catch (IllegalStateException e) {
                throw QueryException.error((String)e.getMessage(), (Throwable)e);
            }
        }
        if (plan.getOperation() != null) {
            switch (plan.getOperation()) {
                case SUSPEND: {
                    job.suspend();
                    break;
                }
                case RESUME: {
                    job.resume();
                    break;
                }
                case RESTART: {
                    job.restart();
                    break;
                }
            }
        }
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.DropJobPlan plan) {
        boolean jobTerminated;
        Job job = this.hazelcastInstance.getJet().getJob(plan.getJobName());
        boolean bl = jobTerminated = job != null && job.getStatus().isTerminal();
        if (job == null || jobTerminated) {
            if (plan.isIfExists()) {
                return UpdateSqlResultImpl.createUpdateCountResult(0L);
            }
            if (jobTerminated) {
                throw QueryException.error((String)("Job already terminated: " + plan.getJobName()));
            }
            throw QueryException.error((String)("Job doesn't exist: " + plan.getJobName()));
        }
        if (plan.getWithSnapshotName() != null) {
            job.cancelAndExportSnapshot(plan.getWithSnapshotName());
        } else {
            job.cancel();
        }
        try {
            job.join();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.CreateSnapshotPlan plan) {
        Job job = this.hazelcastInstance.getJet().getJob(plan.getJobName());
        if (job == null) {
            throw QueryException.error((String)("The job '" + plan.getJobName() + "' doesn't exist"));
        }
        job.exportSnapshot(plan.getSnapshotName());
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.DropSnapshotPlan plan) {
        JobStateSnapshot snapshot = this.hazelcastInstance.getJet().getJobStateSnapshot(plan.getSnapshotName());
        if (snapshot == null) {
            if (plan.isIfExists()) {
                return UpdateSqlResultImpl.createUpdateCountResult(0L);
            }
            throw QueryException.error((String)("The snapshot doesn't exist: " + plan.getSnapshotName()));
        }
        snapshot.destroy();
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.CreateViewPlan plan) {
        OptimizerContext context = plan.context();
        SqlNode sqlNode = context.parse(plan.viewQuery()).getNode();
        RelNode relNode = context.convert(sqlNode).getRel();
        List<RelDataTypeField> fieldList = relNode.getRowType().getFieldList();
        ArrayList<String> fieldNames = new ArrayList<String>();
        ArrayList<QueryDataType> fieldTypes = new ArrayList<QueryDataType>();
        for (RelDataTypeField field : fieldList) {
            fieldNames.add(field.getName());
            fieldTypes.add(HazelcastTypeUtils.toHazelcastType(field.getType()));
        }
        View view = new View(plan.viewName(), plan.viewQuery(), fieldNames, fieldTypes);
        this.catalog.createView(view, plan.isReplace(), plan.ifNotExists());
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.DropViewPlan plan) {
        this.catalog.removeView(plan.viewName(), plan.isIfExists());
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.DropTypePlan plan) {
        this.catalog.removeType(plan.typeName(), plan.isIfExists());
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.ShowStatementPlan plan) {
        Stream rows;
        switch (plan.getShowTarget()) {
            case MAPPINGS: {
                rows = this.catalog.getMappingNames().stream().map(Collections::singletonList);
                break;
            }
            case VIEWS: {
                rows = this.catalog.getViewNames().stream().map(Collections::singletonList);
                break;
            }
            case JOBS: {
                JetServiceBackend jetServiceBackend = (JetServiceBackend)this.nodeEngine.getService("hz:impl:jetService");
                rows = jetServiceBackend.getJobRepository().getActiveJobNames().stream().map(Collections::singletonList);
                break;
            }
            case TYPES: {
                rows = this.catalog.getTypeNames().stream().map(Collections::singletonList);
                break;
            }
            case DATACONNECTIONS: {
                InternalDataConnectionService service = this.nodeEngine.getDataConnectionService();
                DataConnectionServiceImpl dataConnectionService = (DataConnectionServiceImpl)service;
                rows = DataConnectionResolver.getAllDataConnectionNameWithTypes(dataConnectionService).stream();
                break;
            }
            case RESOURCES: {
                return this.executeShowResources(plan.getDataConnectionName());
            }
            default: {
                throw new AssertionError((Object)"Unsupported SHOW statement target");
            }
        }
        SqlRowMetadata metadata = plan.getShowTarget() == SqlShowStatement.ShowStatementTarget.DATACONNECTIONS ? new SqlRowMetadata(Arrays.asList(new SqlColumnMetadata("name", SqlColumnType.VARCHAR, false), new SqlColumnMetadata("connection_type", SqlColumnType.VARCHAR, false), new SqlColumnMetadata("resource_types", SqlColumnType.JSON, false))) : new SqlRowMetadata(Collections.singletonList(new SqlColumnMetadata("name", SqlColumnType.VARCHAR, false)));
        InternalSerializationService serializationService = Util.getSerializationService((HazelcastInstance)this.hazelcastInstance);
        return new SqlResultImpl(QueryId.create((UUID)this.hazelcastInstance.getLocalEndpoint().getUuid()), new StaticQueryResultProducerImpl(rows.sorted(Comparator.comparing(r -> (Comparable)r.get(0))).map(row -> new JetSqlRow((SerializationService)serializationService, ((List)row).toArray(new Object[0]))).iterator()), metadata, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SqlResult executeShowResources(@Nullable String dataConnectionName) {
        List rows;
        if (dataConnectionName == null) {
            throw QueryException.error((String)"Data connections exist only in the 'public' schema");
        }
        SqlRowMetadata metadata = new SqlRowMetadata(Arrays.asList(new SqlColumnMetadata("name", SqlColumnType.VARCHAR, false), new SqlColumnMetadata("type", SqlColumnType.VARCHAR, false)));
        InternalSerializationService serializationService = Util.getSerializationService((HazelcastInstance)this.hazelcastInstance);
        InternalDataConnectionService dataConnectionService = Util.getNodeEngine((HazelcastInstance)this.hazelcastInstance).getDataConnectionService();
        DataConnection dataConnection = dataConnectionService.getAndRetainDataConnection(dataConnectionName, DataConnection.class);
        try {
            rows = dataConnection.listResources().stream().map(resource -> new JetSqlRow((SerializationService)serializationService, new Object[]{QueryUtils.quoteCompoundIdentifier(resource.name()), resource.type()})).collect(Collectors.toList());
        }
        finally {
            dataConnection.release();
        }
        return new SqlResultImpl(QueryId.create((UUID)this.hazelcastInstance.getLocalEndpoint().getUuid()), new StaticQueryResultProducerImpl(rows.iterator()), metadata, false);
    }

    SqlResult execute(SqlPlanImpl.ExplainStatementPlan plan) {
        SqlRowMetadata metadata = new SqlRowMetadata(Collections.singletonList(new SqlColumnMetadata("rel", SqlColumnType.VARCHAR, false)));
        InternalSerializationService serializationService = Util.getSerializationService((HazelcastInstance)this.hazelcastInstance);
        Stream<String> planRows = Arrays.stream(plan.getRel().explain().split(LE));
        return new SqlResultImpl(QueryId.create((UUID)this.hazelcastInstance.getLocalEndpoint().getUuid()), new StaticQueryResultProducerImpl(planRows.map(rel -> new JetSqlRow((SerializationService)serializationService, new Object[]{rel})).iterator()), metadata, false);
    }

    SqlResult execute(SqlPlanImpl.SelectPlan plan, QueryId queryId, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.getParameterMetadata(), arguments);
        JobConfig jobConfig = new JobConfig().setArgument("__sql.arguments", args).setArgument("__sql.queryText", (Object)plan.getQuery()).setArgument("__sql.queryUnbounded", (Object)plan.isStreaming()).setTimeoutMillis(timeout);
        QueryResultProducerImpl queryResultProducer = new QueryResultProducerImpl(!plan.isStreaming());
        AbstractJetInstance jet = (AbstractJetInstance)this.hazelcastInstance.getJet();
        long jobId = jet.newJobId();
        QueryResultProducer oldValue = this.resultRegistry.store(jobId, queryResultProducer);
        assert (oldValue == null) : oldValue;
        try {
            Job job = jet.newLightJob(jobId, plan.getDag(), jobConfig);
            job.getFuture().whenComplete((r, t2) -> {
                this.resultRegistry.remove(jobId);
                if (t2 != null) {
                    int errorCode = PlanExecutor.findQueryExceptionCode(t2);
                    String errorMessage = PlanExecutor.findQueryExceptionMessage(t2);
                    queryResultProducer.onError(QueryException.error((int)errorCode, (String)("The Jet SQL job failed: " + errorMessage), (Throwable)t2));
                }
            });
        }
        catch (Throwable e) {
            this.resultRegistry.remove(jobId);
            throw e;
        }
        return new SqlResultImpl(queryId, queryResultProducer, plan.getRowMetadata(), plan.isStreaming());
    }

    SqlResult execute(SqlPlanImpl.DmlPlan plan, QueryId queryId, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.getParameterMetadata(), arguments);
        JobConfig jobConfig = new JobConfig().setArgument("__sql.arguments", args).setArgument("__sql.queryText", (Object)plan.getQuery()).setArgument("__sql.queryUnbounded", (Object)plan.isInfiniteRows()).setTimeoutMillis(timeout);
        Job job = this.hazelcastInstance.getJet().newLightJob(plan.getDag(), jobConfig);
        job.join();
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.IMapSelectPlan plan, QueryId queryId, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.parameterMetadata(), arguments);
        InternalSerializationService serializationService = Util.getSerializationService((HazelcastInstance)this.hazelcastInstance);
        ExpressionEvalContextImpl evalContext = new ExpressionEvalContextImpl(args, serializationService, (NodeEngine)Util.getNodeEngine((HazelcastInstance)this.hazelcastInstance));
        Object key = plan.keyCondition().eval(EmptyRow.INSTANCE, evalContext);
        CompletionStage future = this.hazelcastInstance.getMap(plan.mapName()).getAsync(key).toCompletableFuture().thenApply(value -> value == null ? null : plan.rowProjectorSupplier().get(evalContext, Extractors.newBuilder((InternalSerializationService)serializationService).build()).project(key, value));
        JetSqlRow row = (JetSqlRow)this.await((CompletableFuture)future, timeout);
        StaticQueryResultProducerImpl resultProducer = row != null ? new StaticQueryResultProducerImpl(row) : new StaticQueryResultProducerImpl(Collections.emptyIterator());
        this.directIMapQueriesExecuted.getAndIncrement();
        return new SqlResultImpl(queryId, resultProducer, plan.rowMetadata(), false, plan.keyConditionParamIndex());
    }

    SqlResult execute(SqlPlanImpl.IMapInsertPlan plan, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.parameterMetadata(), arguments);
        ExpressionEvalContextImpl evalContext = new ExpressionEvalContextImpl(args, Util.getSerializationService((HazelcastInstance)this.hazelcastInstance), (NodeEngine)Util.getNodeEngine((HazelcastInstance)this.hazelcastInstance));
        List<Map.Entry<Object, Object>> entries = plan.entriesFn().apply(evalContext);
        if (!entries.isEmpty()) {
            assert (entries.size() == 1);
            Map.Entry<Object, Object> entry = entries.get(0);
            CompletableFuture future = ((MapProxyImpl)this.hazelcastInstance.getMap(plan.mapName())).putIfAbsentAsync(entry.getKey(), entry.getValue()).toCompletableFuture();
            Object previous = this.await(future, timeout);
            if (previous != null) {
                throw QueryException.error((String)"Duplicate key");
            }
        }
        this.directIMapQueriesExecuted.getAndIncrement();
        return UpdateSqlResultImpl.createUpdateCountResult(0L, plan.keyParamIndex());
    }

    SqlResult execute(SqlPlanImpl.IMapSinkPlan plan, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.parameterMetadata(), arguments);
        ExpressionEvalContextImpl evalContext = new ExpressionEvalContextImpl(args, Util.getSerializationService((HazelcastInstance)this.hazelcastInstance), (NodeEngine)Util.getNodeEngine((HazelcastInstance)this.hazelcastInstance));
        Map<Object, Object> entries = plan.entriesFn().apply(evalContext);
        CompletableFuture future = this.hazelcastInstance.getMap(plan.mapName()).putAllAsync(entries).toCompletableFuture();
        this.await(future, timeout);
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    SqlResult execute(SqlPlanImpl.IMapUpdatePlan plan, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.parameterMetadata(), arguments);
        ExpressionEvalContextImpl evalContext = new ExpressionEvalContextImpl(args, Util.getSerializationService((HazelcastInstance)this.hazelcastInstance), (NodeEngine)Util.getNodeEngine((HazelcastInstance)this.hazelcastInstance));
        Object key = plan.keyCondition().eval(EmptyRow.INSTANCE, evalContext);
        CompletableFuture future = this.hazelcastInstance.getMap(plan.mapName()).submitToKey(key, plan.updaterSupplier().get(arguments)).toCompletableFuture();
        this.await(future, timeout);
        this.directIMapQueriesExecuted.getAndIncrement();
        return UpdateSqlResultImpl.createUpdateCountResult(0L, plan.keyConditionParamIndex());
    }

    SqlResult execute(SqlPlanImpl.IMapDeletePlan plan, List<Object> arguments, long timeout) {
        List<Object> args = this.prepareArguments(plan.parameterMetadata(), arguments);
        ExpressionEvalContextImpl evalContext = new ExpressionEvalContextImpl(args, Util.getSerializationService((HazelcastInstance)this.hazelcastInstance), (NodeEngine)Util.getNodeEngine((HazelcastInstance)this.hazelcastInstance));
        Object key = plan.keyCondition().eval(EmptyRow.INSTANCE, evalContext);
        CompletableFuture future = this.hazelcastInstance.getMap(plan.mapName()).submitToKey(key, (EntryProcessor)EntryRemovingProcessor.ENTRY_REMOVING_PROCESSOR).toCompletableFuture();
        this.await(future, timeout);
        this.directIMapQueriesExecuted.getAndIncrement();
        return UpdateSqlResultImpl.createUpdateCountResult(0L, plan.keyConditionParamIndex());
    }

    SqlResult execute(SqlPlanImpl.CreateTypePlan plan) {
        Type type;
        if (!this.nodeEngine.getProperties().getBoolean(ClusterProperty.SQL_CUSTOM_TYPES_ENABLED)) {
            throw QueryException.error((String)("Experimental feature of creating custom types isn't enabled. To enable, set " + ClusterProperty.SQL_CUSTOM_TYPES_ENABLED + " to true"));
        }
        String format = plan.options().get("format");
        if ("portable".equals(format)) {
            Integer factoryId = Optional.ofNullable(plan.option("portableFactoryId")).map(Integer::parseInt).orElse(null);
            Integer classId = Optional.ofNullable(plan.option("portableClassId")).map(Integer::parseInt).orElse(null);
            Integer version = Optional.ofNullable(plan.option("portableClassVersion")).map(Integer::parseInt).orElse(0);
            if (factoryId == null || classId == null) {
                throw QueryException.error((String)"FactoryID and ClassID are required for Portable Types");
            }
            ClassDefinition existingClassDef = Util.getSerializationService((HazelcastInstance)this.hazelcastInstance).getPortableContext().lookupClassDefinition(factoryId.intValue(), classId.intValue(), version.intValue());
            if (existingClassDef != null) {
                type = TypesUtils.convertPortableClassToType(plan.name(), existingClassDef, this.catalog);
            } else {
                if (plan.columns().isEmpty()) {
                    throw QueryException.error((String)"The given FactoryID/ClassID/Version combination not known to the member. You need to provide column list for this type");
                }
                type = new Type();
                type.setName(plan.name());
                type.setKind(TypeKind.PORTABLE);
                type.setPortableFactoryId(factoryId);
                type.setPortableClassId(classId);
                type.setPortableVersion(version);
                type.setFields(new ArrayList<Type.TypeField>());
                for (int i = 0; i < plan.columns().size(); ++i) {
                    TypeDefinitionColumn planColumn = plan.columns().get(i);
                    type.getFields().add(new Type.TypeField(planColumn.name(), planColumn.dataType()));
                }
            }
        } else if ("compact".equals(format)) {
            if (plan.columns().isEmpty()) {
                throw QueryException.error((String)"Column list is required to create Compact-based Types");
            }
            type = new Type();
            type.setKind(TypeKind.COMPACT);
            type.setName(plan.name());
            List<Type.TypeField> typeFields = plan.columns().stream().map(typeColumn -> new Type.TypeField(typeColumn.name(), typeColumn.dataType())).collect(Collectors.toList());
            type.setFields(typeFields);
            String compactTypeName = plan.option("compactTypeName");
            if (compactTypeName == null || compactTypeName.isEmpty()) {
                throw QueryException.error((String)"Compact Type Name must not be empty for Compact-based Types.");
            }
            type.setCompactTypeName(compactTypeName);
        } else if ("java".equals(format)) {
            Class typeClass;
            try {
                typeClass = ReflectionUtils.loadClass((String)plan.options().get("javaClass"));
            }
            catch (Exception e) {
                throw QueryException.error((String)("Unable to load class: '" + plan.options().get("javaClass") + "'"), (Throwable)e);
            }
            type = TypesUtils.convertJavaClassToType(plan.name(), plan.columns(), typeClass);
        } else {
            throw QueryException.error((String)("Unsupported type format: " + format));
        }
        this.catalog.createType(type, plan.replace(), plan.ifNotExists());
        return UpdateSqlResultImpl.createUpdateCountResult(0L);
    }

    private List<Object> prepareArguments(QueryParameterMetadata parameterMetadata, List<Object> arguments) {
        assert (arguments != null);
        int parameterCount = parameterMetadata.getParameterCount();
        if (parameterCount != arguments.size()) {
            throw QueryException.error((int)2000, (String)("Unexpected parameter count: expected " + parameterCount + ", got " + arguments.size()));
        }
        for (int i = 0; i < arguments.size(); ++i) {
            Object value = arguments.get(i);
            ParameterConverter parameterConverter = parameterMetadata.getParameterConverter(i);
            Object newValue = parameterConverter.convert(value);
            if (newValue == value) continue;
            arguments.set(i, newValue);
        }
        return arguments;
    }

    private static int findQueryExceptionCode(Throwable t2) {
        while (t2 != null) {
            if (t2 instanceof QueryException) {
                return ((QueryException)t2).getCode();
            }
            if (ExceptionUtil.isTopologyException((Throwable)t2)) {
                return 1011;
            }
            if (t2 instanceof RestartableException) {
                return 1012;
            }
            t2 = t2.getCause();
        }
        return -1;
    }

    private static String findQueryExceptionMessage(Throwable t2) {
        while (t2 != null) {
            if (t2.getMessage() != null) {
                return t2.getMessage();
            }
            t2 = t2.getCause();
        }
        return "";
    }

    private <T> T await(CompletableFuture<T> future, long timeout) {
        try {
            return timeout > 0L ? future.get(timeout, TimeUnit.MILLISECONDS) : future.get();
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw QueryException.error((String)"Timeout occurred while executing statement");
        }
        catch (InterruptedException | ExecutionException e) {
            throw QueryException.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private static <K, V> MapContainer getMapContainer(IMap<K, V> map) {
        MapProxyImpl mapProxy = (MapProxyImpl)map;
        MapService mapService = (MapService)mapProxy.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        return mapServiceContext.getMapContainer(map.getName());
    }

    private void broadcastUpdateDataConnectionOperations(@Nonnull String dataConnectionName) {
        ArrayList<Tuple2> futures = new ArrayList<Tuple2>();
        for (Member m4 : this.nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR)) {
            UpdateDataConnectionOperation op = new UpdateDataConnectionOperation(dataConnectionName);
            Address target = m4.getAddress();
            InvocationFuture future = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:jetService", (Operation)op, target).invoke();
            futures.add(Tuple2.tuple2((Object)target, (Object)future));
        }
        for (Tuple2 tuple : futures) {
            try {
                assert (tuple.f1() != null);
                ((CompletableFuture)tuple.f1()).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (ExecutionException e) {
                this.logger.warning("Failed to update data connection '" + dataConnectionName + "' on member '" + tuple.f0() + "'. Background process should resolve this");
            }
        }
    }

    public long getDirectIMapQueriesExecuted() {
        return this.directIMapQueriesExecuted.get();
    }
}

