/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.pipeline.file.FileFormat;
import com.hazelcast.jet.sql.impl.connector.file.AvroResolver;
import com.hazelcast.jet.sql.impl.connector.file.Metadata;
import com.hazelcast.jet.sql.impl.connector.file.MetadataResolver;
import com.hazelcast.jet.sql.impl.connector.file.ProcessorMetaSupplierProvider;
import com.hazelcast.jet.sql.impl.extract.AvroQueryTarget;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.schema.MappingField;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;

final class AvroMetadataResolver
extends MetadataResolver<GenericRecord> {
    static final AvroMetadataResolver INSTANCE = new AvroMetadataResolver();
    private static final FileFormat<Map<String, String>> FORMAT = FileFormat.avro();

    AvroMetadataResolver() {
    }

    @Override
    protected String supportedFormat() {
        return this.sampleFormat().format();
    }

    @Override
    protected FileFormat<?> sampleFormat() {
        return FORMAT;
    }

    @Override
    protected List<MappingField> resolveFieldsFromSample(GenericRecord record) {
        return AvroResolver.resolveFields(record.getSchema());
    }

    @Override
    protected Metadata resolveMetadata(List<MappingField> resolvedFields, Map<String, ?> options) {
        return new Metadata(this.toFields(resolvedFields), new ProcessorMetaSupplierProvider(options, FORMAT), (SupplierEx<QueryTarget>)((SupplierEx & Serializable)AvroQueryTarget::new));
    }
}

