/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlProcessors;
import com.hazelcast.jet.sql.impl.connector.file.AvroMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.file.CsvMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.file.FileTable;
import com.hazelcast.jet.sql.impl.connector.file.JsonMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.file.Metadata;
import com.hazelcast.jet.sql.impl.connector.file.MetadataResolvers;
import com.hazelcast.jet.sql.impl.connector.file.ParquetMetadataResolver;
import com.hazelcast.security.permission.ConnectorPermission;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import java.security.Permission;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileSqlConnector
implements SqlConnector {
    public static final String TYPE_NAME = "File";
    public static final String OPTION_PATH = "path";
    public static final String OPTION_GLOB = "glob";
    public static final String OPTION_SHARED_FILE_SYSTEM = "sharedFileSystem";
    public static final String OPTION_IGNORE_FILE_NOT_FOUND = "ignoreFileNotFound";
    public static final String OPTION_OPTIONS = "options";
    static final FileSqlConnector INSTANCE = new FileSqlConnector();
    private static final MetadataResolvers METADATA_RESOLVERS = new MetadataResolvers(CsvMetadataResolver.INSTANCE, JsonMetadataResolver.INSTANCE, AvroMetadataResolver.INSTANCE, ParquetMetadataResolver.INSTANCE);

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    @Nonnull
    public String defaultObjectType() {
        return TYPE_NAME;
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> userFields) {
        return FileSqlConnector.resolveAndValidateFields(externalResource.options(), userFields);
    }

    @Nonnull
    static List<MappingField> resolveAndValidateFields(@Nonnull Map<String, ?> options, @Nonnull List<MappingField> userFields) {
        return METADATA_RESOLVERS.resolveAndValidateFields(userFields, options);
    }

    @Override
    @Nonnull
    public List<Permission> permissionsForResolve(SqlConnector.SqlExternalResource resource, NodeEngine nodeEngine) {
        return Collections.singletonList(ConnectorPermission.file((String)resource.options().get(OPTION_PATH), (String)"read"));
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> resolvedFields) {
        Metadata metadata = METADATA_RESOLVERS.resolveMetadata(resolvedFields, externalResource.options());
        return new FileTable.SpecificFileTable((SqlConnector)INSTANCE, schemaName, mappingName, metadata.fields(), metadata.processorMetaSupplier(), metadata.queryTargetSupplier(), externalResource.objectType());
    }

    @Nonnull
    static Table createTable(@Nonnull String schemaName, @Nonnull String name, @Nonnull Map<String, ?> options, @Nonnull List<MappingField> resolvedFields) {
        Metadata metadata = METADATA_RESOLVERS.resolveMetadata(resolvedFields, options);
        return new FileTable.DynamicFileTable(INSTANCE, schemaName, name, metadata.fields(), metadata.processorMetaSupplier(), metadata.queryTargetSupplier());
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        if (eventTimePolicyProvider != null) {
            throw QueryException.error((String)"Ordering functions are not supported on top of File mappings");
        }
        FileTable table = (FileTable)context.getTable();
        Vertex vStart = context.getDag().newUniqueVertex(table.toString(), table.processorMetaSupplier());
        Vertex vEnd = context.getDag().newUniqueVertex("Project(" + table + ")", SqlProcessors.rowProjector(table.paths(), table.types(), table.queryTargetSupplier(), context.convertFilter(predicate), context.convertProjection(projection)));
        context.getDag().edge(Edge.between((Vertex)vStart, (Vertex)vEnd).isolated());
        return vEnd;
    }

    @Override
    public boolean supportsExpression(@Nonnull HazelcastRexNode expression) {
        return true;
    }
}

