/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.dataconnection.DataConnectionService;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.DeleteQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.DmlProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.InsertProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.InsertQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTableField;
import com.hazelcast.jet.sql.impl.connector.jdbc.SelectProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.SelectQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.SingleItemSourceP;
import com.hazelcast.jet.sql.impl.connector.jdbc.SupportedDatabases;
import com.hazelcast.jet.sql.impl.connector.jdbc.SupportsRexVisitor;
import com.hazelcast.jet.sql.impl.connector.jdbc.UpdateQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.UpsertBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.UpsertProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.mysql.HazelcastMySqlDialect;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialectFactoryImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialects;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JdbcSqlConnector
implements SqlConnector {
    public static final String TYPE_NAME = "JDBC";
    private static final JetSqlRow DUMMY_INPUT_ROW = new JetSqlRow(null, new Object[0]);

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    @Nonnull
    public String defaultObjectType() {
        return "Table";
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> userFields) {
        if (externalResource.dataConnection() == null) {
            throw QueryException.error((String)"You must provide data connection when using the Jdbc connector");
        }
        ExternalJdbcTableName.validateExternalName(externalResource.externalName());
        Map<String, DbField> dbFields = this.readDbFields((DataConnectionService)nodeEngine.getDataConnectionService(), externalResource.dataConnection(), externalResource.externalName());
        ArrayList<MappingField> resolvedFields = new ArrayList<MappingField>();
        if (userFields.isEmpty()) {
            for (DbField dbField : dbFields.values()) {
                MappingField mappingField = new MappingField(dbField.columnName, JdbcSqlConnector.resolveType(dbField.columnTypeName));
                mappingField.setPrimaryKey(dbField.primaryKey);
                resolvedFields.add(mappingField);
            }
        } else {
            for (MappingField f : userFields) {
                MappingField mappingField;
                DbField dbField;
                if (f.externalName() != null) {
                    dbField = dbFields.get(f.externalName());
                    if (dbField == null) {
                        throw QueryException.error((String)("Could not resolve field with external name " + f.externalName()));
                    }
                    this.validateType(f, dbField);
                    mappingField = new MappingField(f.name(), f.type(), f.externalName(), dbField.columnTypeName);
                    mappingField.setPrimaryKey(dbField.primaryKey);
                    resolvedFields.add(mappingField);
                    continue;
                }
                dbField = dbFields.get(f.name());
                if (dbField == null) {
                    throw QueryException.error((String)("Could not resolve field with name " + f.name()));
                }
                this.validateType(f, dbField);
                mappingField = new MappingField(f.name(), f.type());
                mappingField.setPrimaryKey(dbField.primaryKey);
                resolvedFields.add(mappingField);
            }
        }
        return resolvedFields;
    }

    /*
     * Exception decompiling
     */
    private Map<String, DbField> readDbFields(DataConnectionService dataConnectionService, String dataConnectionName, String[] externalName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void checkTableExists(ExternalJdbcTableName externalTableName, DatabaseMetaData databaseMetaData) throws SQLException {
        String table = externalTableName.table;
        if (JdbcSqlConnector.isMySQL(databaseMetaData)) {
            SqlDialect dialect = JdbcSqlConnector.resolveDialect(databaseMetaData);
            table = dialect.quoteIdentifier(table);
        }
        Connection connection = databaseMetaData.getConnection();
        String catalog = externalTableName.catalog != null ? externalTableName.catalog : connection.getCatalog();
        String schema = externalTableName.schema != null ? externalTableName.schema : connection.getSchema();
        try (ResultSet tables = databaseMetaData.getTables(catalog, schema, table, new String[]{"TABLE", "VIEW"});){
            if (!tables.next()) {
                String fullTableName = QueryUtils.quoteCompoundIdentifier(externalTableName.catalog, externalTableName.schema, externalTableName.table);
                throw new HazelcastException("Could not find table " + fullTableName);
            }
        }
    }

    private static Set<String> readPrimaryKeyColumns(ExternalJdbcTableName externalTableName, DatabaseMetaData databaseMetaData) {
        HashSet<String> pkColumns = new HashSet<String>();
        try (ResultSet resultSet = databaseMetaData.getPrimaryKeys(externalTableName.catalog, externalTableName.schema, externalTableName.table);){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                pkColumns.add(columnName);
            }
        }
        catch (SQLException e) {
            throw new HazelcastException("Could not read primary key columns for table " + externalTableName, (Throwable)e);
        }
        return pkColumns;
    }

    private static Map<String, DbField> readColumns(ExternalJdbcTableName externalTableName, DatabaseMetaData databaseMetaData, Set<String> pkColumns) {
        LinkedHashMap<String, DbField> fields = new LinkedHashMap<String, DbField>();
        try (ResultSet resultSet = databaseMetaData.getColumns(externalTableName.catalog, externalTableName.schema, externalTableName.table, null);){
            while (resultSet.next()) {
                String columnTypeName = resultSet.getString("TYPE_NAME");
                String columnName = resultSet.getString("COLUMN_NAME");
                fields.put(columnName, new DbField(columnTypeName, columnName, pkColumns.contains(columnName)));
            }
        }
        catch (SQLException e) {
            throw new HazelcastException("Could not read columns for table " + externalTableName, (Throwable)e);
        }
        return fields;
    }

    private void validateType(MappingField field, DbField dbField) {
        QueryDataType type = JdbcSqlConnector.resolveType(dbField.columnTypeName);
        if (!field.type().equals(type) && !type.getConverter().canConvertTo(field.type().getTypeFamily())) {
            throw new IllegalStateException("Type " + (Object)((Object)field.type().getTypeFamily()) + " of field " + field.name() + " does not match db type " + (Object)((Object)type.getTypeFamily()));
        }
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> resolvedFields) {
        String dataConnectionName = externalResource.dataConnection();
        assert (dataConnectionName != null);
        ArrayList<TableField> fields = new ArrayList<TableField>(resolvedFields.size());
        for (MappingField resolvedField : resolvedFields) {
            String fieldExternalName = resolvedField.externalName() != null ? resolvedField.externalName() : resolvedField.name();
            fields.add(new JdbcTableField(resolvedField.name(), resolvedField.type(), fieldExternalName, resolvedField.isPrimaryKey()));
        }
        return new JdbcTable(this, fields, schemaName, mappingName, externalResource, new ConstantTableStatistics(0L));
    }

    /*
     * Exception decompiling
     */
    private static SqlDialect resolveDialect(JdbcTable table, SqlConnector.DagBuildContext context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static SqlDialect resolveDialect(DatabaseMetaData databaseMetaData) throws SQLException {
        switch (databaseMetaData.getDatabaseProductName().toUpperCase(Locale.ROOT).trim()) {
            case "MYSQL": {
                return new HazelcastMySqlDialect(SqlDialects.createContext(databaseMetaData));
            }
        }
        return SqlDialectFactoryImpl.INSTANCE.create(databaseMetaData);
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        if (eventTimePolicyProvider != null) {
            throw QueryException.error((String)"Ordering functions are not supported on top of JDBC mappings");
        }
        JdbcTable table = (JdbcTable)context.getTable();
        SqlDialect dialect = JdbcSqlConnector.resolveDialect(table, context);
        RexNode rexPredicate = predicate == null ? null : predicate.unwrap(RexNode.class);
        List rexProjection = Util.toList(projection, n -> n.unwrap(RexNode.class));
        SelectQueryBuilder builder = new SelectQueryBuilder((JdbcTable)context.getTable(), dialect, rexPredicate, rexProjection);
        return context.getDag().newUniqueVertex("Select(" + table.getExternalNameList() + ")", ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)new SelectProcessorSupplier(table.getDataConnectionName(), builder.query(), builder.parameterPositions())));
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig insertProcessor(@Nonnull SqlConnector.DagBuildContext context) {
        JdbcTable table = (JdbcTable)context.getTable();
        InsertQueryBuilder builder = new InsertQueryBuilder(table, JdbcSqlConnector.resolveDialect(table, context));
        return new SqlConnector.VertexWithInputConfig(context.getDag().newUniqueVertex("Insert(" + table.getExternalNameList() + ")", (ProcessorSupplier)new InsertProcessorSupplier(table.getDataConnectionName(), builder.query(), table.getBatchLimit())).localParallelism(1));
    }

    @Override
    @Nonnull
    public List<String> getPrimaryKey(Table table0) {
        JdbcTable table = (JdbcTable)table0;
        return table.getPrimaryKeyList();
    }

    @Override
    public boolean supportsExpression(@Nonnull HazelcastRexNode expression) {
        SupportsRexVisitor visitor;
        RexNode rexExpression = expression.unwrap(RexNode.class);
        Boolean supports = rexExpression.accept(visitor = new SupportsRexVisitor());
        return supports != null && supports != false;
    }

    @Override
    @Nonnull
    public Vertex updateProcessor(@Nonnull SqlConnector.DagBuildContext context, @Nonnull List<String> fieldNames, @Nonnull List<HazelcastRexNode> expressions, @Nullable HazelcastRexNode predicate, boolean hasInput) {
        assert (predicate == null || !hasInput);
        JdbcTable table = (JdbcTable)context.getTable();
        List rexExpressions = Util.toList(expressions, n -> n.unwrap(RexNode.class));
        RexNode rexPredicate = predicate == null ? null : predicate.unwrap(RexNode.class);
        UpdateQueryBuilder builder = new UpdateQueryBuilder(table, JdbcSqlConnector.resolveDialect(table, context), fieldNames, rexExpressions, rexPredicate, hasInput);
        DmlProcessorSupplier updatePS = new DmlProcessorSupplier(table.getDataConnectionName(), builder.query(), builder.dynamicParams(), builder.inputRefs(), table.getBatchLimit());
        return JdbcSqlConnector.dmlVertex(context, hasInput, table, updatePS, "Update");
    }

    @Override
    @Nonnull
    public Vertex deleteProcessor(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, boolean hasInput) {
        assert (predicate == null || !hasInput);
        JdbcTable table = (JdbcTable)context.getTable();
        RexNode rexPredicate = predicate == null ? null : predicate.unwrap(RexNode.class);
        DeleteQueryBuilder builder = new DeleteQueryBuilder(table, JdbcSqlConnector.resolveDialect(table, context), rexPredicate, hasInput);
        DmlProcessorSupplier deletePS = new DmlProcessorSupplier(table.getDataConnectionName(), builder.query(), builder.dynamicParams(), builder.inputRefs(), table.getBatchLimit());
        return JdbcSqlConnector.dmlVertex(context, hasInput, table, deletePS, "Delete");
    }

    private static Vertex dmlVertex(SqlConnector.DagBuildContext context, boolean hasInput, JdbcTable table, DmlProcessorSupplier processorSupplier, String statement) {
        if (!hasInput) {
            Address localAddress = context.getNodeEngine().getThisAddress();
            Vertex v = JdbcSqlConnector.dummySourceVertex(context, "DummySourceFor" + statement, localAddress);
            Vertex dmlVertex = context.getDag().newUniqueVertex(statement + "(" + table.getExternalNameList() + ")", ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)processorSupplier, (Address)localAddress));
            context.getDag().edge(Edge.between((Vertex)v, (Vertex)dmlVertex));
            return dmlVertex;
        }
        Vertex dmlVertex = context.getDag().newUniqueVertex(statement + "(" + table.getExternalNameList() + ")", (ProcessorSupplier)processorSupplier).localParallelism(1);
        return dmlVertex;
    }

    private static Vertex dummySourceVertex(SqlConnector.DagBuildContext context, String name, Address localAddress) {
        Vertex v = context.getDag().newUniqueVertex(name, ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)ProcessorSupplier.of((SupplierEx & Serializable)() -> new SingleItemSourceP<JetSqlRow>(DUMMY_INPUT_ROW)), (Address)localAddress));
        return v;
    }

    @Override
    @Nonnull
    public Vertex sinkProcessor(@Nonnull SqlConnector.DagBuildContext context) {
        JdbcTable jdbcTable = (JdbcTable)context.getTable();
        SqlDialect dialect = JdbcSqlConnector.resolveDialect(jdbcTable, context);
        if (SupportedDatabases.isDialectSupported(dialect)) {
            String upsertStatement = UpsertBuilder.getUpsertStatement(jdbcTable, dialect);
            return context.getDag().newUniqueVertex("sinkProcessor(" + jdbcTable.getExternalNameList() + ")", (ProcessorSupplier)new UpsertProcessorSupplier(jdbcTable.getDataConnectionName(), upsertStatement, jdbcTable.getBatchLimit())).localParallelism(1);
        }
        SqlConnector.VertexWithInputConfig vertexWithInputConfig = this.insertProcessor(context);
        return vertexWithInputConfig.vertex();
    }

    private static QueryDataType resolveType(String columnTypeName) {
        switch (columnTypeName.toUpperCase()) {
            case "BOOLEAN": 
            case "BOOL": 
            case "BIT": {
                return QueryDataType.BOOLEAN;
            }
            case "VARCHAR": 
            case "CHARACTER VARYING": 
            case "TEXT": {
                return QueryDataType.VARCHAR;
            }
            case "TINYINT": {
                return QueryDataType.TINYINT;
            }
            case "SMALLINT": 
            case "INT2": {
                return QueryDataType.SMALLINT;
            }
            case "INT": 
            case "INT4": 
            case "INTEGER": {
                return QueryDataType.INT;
            }
            case "INT8": 
            case "BIGINT": {
                return QueryDataType.BIGINT;
            }
            case "DECIMAL": 
            case "NUMERIC": {
                return QueryDataType.DECIMAL;
            }
            case "REAL": 
            case "FLOAT": 
            case "FLOAT4": {
                return QueryDataType.REAL;
            }
            case "DOUBLE": 
            case "DOUBLE PRECISION": 
            case "FLOAT8": {
                return QueryDataType.DOUBLE;
            }
            case "DATE": {
                return QueryDataType.DATE;
            }
            case "TIME": {
                return QueryDataType.TIME;
            }
            case "TIMESTAMP": {
                return QueryDataType.TIMESTAMP;
            }
            case "TIMESTAMP WITH TIME ZONE": {
                return QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME;
            }
        }
        throw new IllegalArgumentException("Unsupported column type: " + columnTypeName);
    }

    private static boolean isMySQL(DatabaseMetaData databaseMetaData) throws SQLException {
        return JdbcSqlConnector.getProductName(databaseMetaData).equals("MYSQL");
    }

    private static String getProductName(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getDatabaseProductName().toUpperCase(Locale.ROOT).trim();
    }

    private static class ExternalJdbcTableName {
        final String catalog;
        final String schema;
        final String table;

        ExternalJdbcTableName(String[] externalName, DatabaseMetaData databaseMetaData) throws SQLException {
            if (externalName.length == 1) {
                this.catalog = null;
                this.schema = null;
                this.table = externalName[0];
            } else if (externalName.length == 2) {
                if (JdbcSqlConnector.isMySQL(databaseMetaData)) {
                    this.catalog = externalName[0];
                    this.schema = null;
                } else {
                    this.catalog = null;
                    this.schema = externalName[0];
                }
                this.table = externalName[1];
            } else if (externalName.length == 3) {
                if (JdbcSqlConnector.isMySQL(databaseMetaData)) {
                    throw QueryException.error((String)("Invalid external name " + QueryUtils.quoteCompoundIdentifier(externalName) + ", external name for MySQL must have either 1 or 2 components (catalog and relation)"));
                }
                this.catalog = externalName[0];
                this.schema = externalName[1];
                this.table = externalName[2];
            } else {
                throw QueryException.error((String)"Invalid external name length");
            }
        }

        static void validateExternalName(String[] externalName) {
            if (externalName.length == 0 || externalName.length > 3) {
                throw QueryException.error((String)("Invalid external name " + QueryUtils.quoteCompoundIdentifier(externalName) + ", external name for Jdbc must have either 1, 2 or 3 components (catalog, schema and relation)"));
            }
        }
    }

    private static class DbField {
        final String columnTypeName;
        final String columnName;
        final boolean primaryKey;

        DbField(String columnTypeName, String columnName, boolean primaryKey) {
            this.columnTypeName = Objects.requireNonNull(columnTypeName);
            this.columnName = Objects.requireNonNull(columnName);
            this.primaryKey = primaryKey;
        }

        public String toString() {
            return "DbField{name='" + this.columnName + '\'' + ", typeName='" + this.columnTypeName + '\'' + ", primaryKey=" + this.primaryKey + '}';
        }
    }
}

