/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.internal.iteration.IndexIterationPointer;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.SerializationServiceAware;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.PredicateBuilder;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.scan.index.IndexCompositeFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexEqualsFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexRangeFilter;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.ExpressionEvalContextImpl;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class QueryUtil {
    private QueryUtil() {
    }

    static Predicate<Object, Object> toPredicate(JetSqlRow left, int[] leftEquiJoinIndices, int[] rightEquiJoinIndices, QueryPath[] rightPaths) {
        PredicateBuilder builder = Predicates.newPredicateBuilder();
        PredicateBuilder.EntryObject entryObject = builder.getEntryObject();
        for (int i = 0; i < leftEquiJoinIndices.length; ++i) {
            PredicateBuilder.EntryObject object;
            Comparable<?> leftValue = QueryUtil.asComparable(left.get(leftEquiJoinIndices[i]));
            if (leftValue == null) {
                return null;
            }
            QueryPath rightPath = rightPaths[rightEquiJoinIndices[i]];
            if (rightPath.isKey()) {
                object = rightPath.isTop() ? entryObject.key() : entryObject.key().get(rightPath.getPath());
            } else {
                PredicateBuilder.EntryObject entryObject2 = object = rightPath.isTop() ? entryObject.get(rightPath.toString()) : entryObject.get(QueryPath.VALUE).get(rightPath.getPath());
            }
            if (i == 0) {
                object.equal(leftValue);
                continue;
            }
            builder.and((Predicate)object.equal(leftValue));
        }
        return builder;
    }

    private static Comparable<?> asComparable(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        throw QueryException.error((String)("JOIN not supported for " + value.getClass() + ": not comparable"));
    }

    static Projection<Map.Entry<Object, Object>, JetSqlRow> toProjection(KvRowProjector.Supplier rightRowProjectorSupplier, ExpressionEvalContext evalContext) {
        return new JoinProjection(rightRowProjectorSupplier, evalContext);
    }

    static IndexIterationPointer[] indexFilterToPointers(IndexFilter indexFilter, boolean descending, ExpressionEvalContext evalContext) {
        ArrayList<IndexIterationPointer> result = new ArrayList<IndexIterationPointer>();
        QueryUtil.createFromIndexFilterInt(indexFilter, descending, evalContext, result);
        return result.toArray(new IndexIterationPointer[0]);
    }

    private static void createFromIndexFilterInt(IndexFilter indexFilter, boolean descending, ExpressionEvalContext evalContext, List<IndexIterationPointer> result) {
        if (indexFilter == null) {
            result.add(IndexIterationPointer.create(null, (boolean)true, null, (boolean)true, (boolean)descending, null));
        }
        if (indexFilter instanceof IndexRangeFilter) {
            IndexRangeFilter rangeFilter = (IndexRangeFilter)indexFilter;
            Comparable from = null;
            if (rangeFilter.getFrom() != null) {
                Comparable fromValue = rangeFilter.getFrom().getValue(evalContext);
                if (fromValue == null) {
                    return;
                }
                from = fromValue;
            }
            Comparable to = null;
            if (rangeFilter.getTo() != null) {
                Comparable toValue = rangeFilter.getTo().getValue(evalContext);
                if (toValue == null) {
                    return;
                }
                to = toValue;
            }
            result.add(IndexIterationPointer.create((Comparable)from, (boolean)rangeFilter.isFromInclusive(), (Comparable)to, (boolean)rangeFilter.isToInclusive(), (boolean)descending, null));
        } else if (indexFilter instanceof IndexEqualsFilter) {
            IndexEqualsFilter equalsFilter = (IndexEqualsFilter)indexFilter;
            Comparable value = equalsFilter.getComparable(evalContext);
            result.add(IndexIterationPointer.create((Comparable)value, (boolean)true, (Comparable)value, (boolean)true, (boolean)descending, null));
        } else if (indexFilter instanceof IndexCompositeFilter) {
            IndexCompositeFilter inFilter = (IndexCompositeFilter)indexFilter;
            for (IndexFilter filter : inFilter.getFilters()) {
                QueryUtil.createFromIndexFilterInt(filter, descending, evalContext, result);
            }
        }
    }

    @SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
    private static final class JoinProjection
    implements Projection<Map.Entry<Object, Object>, JetSqlRow>,
    DataSerializable,
    HazelcastInstanceAware,
    SerializationServiceAware {
        private KvRowProjector.Supplier rightRowProjectorSupplier;
        private List<Object> arguments;
        private transient HazelcastInstance hzInstance;
        private transient ExpressionEvalContext evalContext;
        private transient Extractors extractors;

        private JoinProjection() {
        }

        private JoinProjection(KvRowProjector.Supplier rightRowProjectorSupplier, ExpressionEvalContext evalContext) {
            this.rightRowProjectorSupplier = rightRowProjectorSupplier;
            this.evalContext = evalContext;
            this.arguments = evalContext.getArguments();
        }

        public JetSqlRow transform(Map.Entry<Object, Object> entry) {
            return this.rightRowProjectorSupplier.get(this.evalContext, this.extractors).project(entry.getKey(), entry.getValue());
        }

        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            this.hzInstance = hazelcastInstance;
        }

        public void setSerializationService(SerializationService serializationService) {
            this.evalContext = new ExpressionEvalContextImpl(this.arguments, (InternalSerializationService)serializationService, (NodeEngine)Util.getNodeEngine((HazelcastInstance)this.hzInstance));
            this.extractors = Extractors.newBuilder((InternalSerializationService)this.evalContext.getSerializationService()).build();
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.rightRowProjectorSupplier);
            out.writeObject(this.arguments);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.rightRowProjectorSupplier = (KvRowProjector.Supplier)in.readObject();
            this.arguments = (List)in.readObject();
        }
    }
}

