/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.mongodb.MongoSinkBuilder;
import com.hazelcast.jet.mongodb.WriteMode;
import com.hazelcast.jet.mongodb.impl.WriteMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoParams;
import com.hazelcast.jet.sql.impl.connector.mongodb.ConversionsToBson;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTable;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bson.BsonType;
import org.bson.Document;

public class InsertProcessorSupplier
implements ProcessorSupplier {
    private final String connectionString;
    private final String databaseName;
    private final String collectionName;
    private final String[] paths;
    private final WriteMode writeMode;
    private final QueryDataType[] types;
    private final BsonType[] externalTypes;
    private transient SupplierEx<MongoClient> clientSupplier;
    private final String dataConnectionName;
    private final String idField;

    InsertProcessorSupplier(MongoTable table, WriteMode writeMode) {
        this.connectionString = table.connectionString;
        this.databaseName = table.databaseName;
        this.dataConnectionName = table.dataConnectionName;
        this.collectionName = table.collectionName;
        this.paths = table.externalNames();
        this.types = table.fieldTypes();
        this.externalTypes = table.externalTypes();
        this.writeMode = writeMode;
        this.idField = table.primaryKeyExternalName();
    }

    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        if (this.connectionString != null) {
            this.clientSupplier = (SupplierEx & Serializable)() -> MongoClients.create((String)this.connectionString);
        }
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        Processor[] processors = new Processor[count];
        String idFieldName = this.idField;
        for (int i = 0; i < count; ++i) {
            WriteMongoP processor = new WriteMongoP(new WriteMongoParams().setClientSupplier(this.clientSupplier).setDataConnectionRef(this.dataConnectionName).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setDocumentType(Document.class).setDocumentIdentityFn((FunctionEx & Serializable)doc -> doc.get((Object)idFieldName)).setDocumentIdentityFieldName(idFieldName).setCommitRetryStrategy(MongoSinkBuilder.DEFAULT_COMMIT_RETRY_STRATEGY).setTransactionOptionsSup((SupplierEx & Serializable)() -> MongoSinkBuilder.DEFAULT_TRANSACTION_OPTION).setIntermediateMappingFn(this::rowToDoc).setWriteMode(this.writeMode));
            processors[i] = processor;
        }
        return Arrays.asList(processors);
    }

    private Document rowToDoc(JetSqlRow row) {
        Object[] values = row.getValues();
        Document doc = new Document();
        for (int i = 0; i < row.getFieldCount(); ++i) {
            String fieldName = this.paths[i];
            Object value = values[i];
            if (fieldName.equals("_id") && value == null) continue;
            value = ConversionsToBson.convertToBson(value, this.types[i], this.externalTypes[i]);
            doc = doc.append(fieldName, value);
        }
        return doc;
    }
}

