/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.mongodb.impl.Mappers;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.mongodb.FieldResolver;
import com.hazelcast.jet.sql.impl.connector.mongodb.InputRef;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTable;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTableField;
import com.hazelcast.jet.sql.impl.connector.mongodb.Options;
import com.hazelcast.jet.sql.impl.connector.mongodb.ProjectionData;
import com.hazelcast.jet.sql.impl.connector.mongodb.RexToMongoVisitor;
import com.hazelcast.jet.sql.impl.connector.mongodb.SelectProcessorSupplier;
import com.hazelcast.shaded.com.google.common.base.MoreObjects;
import com.hazelcast.shaded.com.google.common.collect.ImmutableSet;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class MongoSqlConnectorBase
implements SqlConnector {
    protected static final Set<String> ALLOWED_OBJECT_TYPES = ImmutableSet.of("Collection", "ChangeStream");

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> userFields) {
        if (externalResource.externalName().length > 2) {
            throw QueryException.error((String)("Invalid external name " + QueryUtils.quoteCompoundIdentifier(externalResource.externalName()) + ", external name for Mongo is allowed to have only one component (collection) or two components (database and collection)"));
        }
        if (!ALLOWED_OBJECT_TYPES.contains(externalResource.objectType())) {
            throw QueryException.error((String)("Mongo connector allows only object types: " + ALLOWED_OBJECT_TYPES));
        }
        FieldResolver fieldResolver = new FieldResolver(nodeEngine);
        return fieldResolver.resolveFields(externalResource.externalName(), externalResource.dataConnection(), externalResource.options(), userFields, MongoSqlConnectorBase.isStream(externalResource.objectType()));
    }

    private static boolean isStream(String objectType) {
        return "ChangeStream".equalsIgnoreCase(objectType);
    }

    @Override
    @Nonnull
    public List<String> getPrimaryKey(Table table) {
        MongoTable mongoTable = (MongoTable)table;
        return Collections.singletonList(mongoTable.primaryKeyName());
    }

    @Override
    @Nonnull
    public String defaultObjectType() {
        return "Collection";
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> resolvedFields) {
        if (!ALLOWED_OBJECT_TYPES.contains(externalResource.objectType())) {
            throw QueryException.error((String)("Mongo connector allows only object types: " + ALLOWED_OBJECT_TYPES));
        }
        String collectionName = externalResource.externalName().length == 2 ? externalResource.externalName()[1] : externalResource.externalName()[0];
        FieldResolver fieldResolver = new FieldResolver(nodeEngine);
        String databaseName = Options.getDatabaseName(nodeEngine, externalResource.externalName(), externalResource.dataConnection());
        ConstantTableStatistics stats = new ConstantTableStatistics(0L);
        ArrayList<TableField> fields = new ArrayList<TableField>(resolvedFields.size());
        boolean containsId = false;
        boolean isStreaming = MongoSqlConnectorBase.isStream(externalResource.objectType());
        boolean hasPK = false;
        for (MappingField resolvedField : resolvedFields) {
            String externalNameFromName = (isStreaming ? "fullDocument." : "") + resolvedField.name();
            String fieldExternalName = MoreObjects.firstNonNull(resolvedField.externalName(), externalNameFromName);
            if (fieldResolver.isId(fieldExternalName, isStreaming)) {
                containsId = true;
            }
            fields.add(new MongoTableField(resolvedField.name(), resolvedField.type(), fieldExternalName, false, resolvedField.externalType(), resolvedField.isPrimaryKey()));
            hasPK |= resolvedField.isPrimaryKey();
        }
        if (!containsId) {
            if (isStreaming) {
                fields.add(0, new MongoTableField("fullDocument._id", QueryDataType.OBJECT, "fullDocument._id", true, "DOCUMENT", !hasPK));
            } else {
                fields.add(0, new MongoTableField("_id", QueryDataType.OBJECT, "_id", true, "DOCUMENT", !hasPK));
            }
        }
        return new MongoTable(schemaName, mappingName, databaseName, collectionName, externalResource.dataConnection(), externalResource.options(), this, fields, stats, externalResource.objectType());
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        ProcessorMetaSupplier supplier;
        MongoTable table = (MongoTable)context.getTable();
        RexToMongoVisitor visitor = new RexToMongoVisitor();
        Document filter = MongoSqlConnectorBase.translateFilter(predicate, visitor);
        List<ProjectionData> projections = MongoSqlConnectorBase.translateProjections(projection, context, visitor);
        if (table.isStreaming()) {
            BsonTimestamp startAt = Options.startAt(table.getOptions());
            supplier = MongoSqlConnectorBase.wrap(context, new SelectProcessorSupplier(table, filter, projections, startAt, eventTimePolicyProvider));
        } else {
            supplier = MongoSqlConnectorBase.wrap(context, new SelectProcessorSupplier(table, filter, projections));
        }
        DAG dag = context.getDag();
        Vertex sourceVertex = dag.newUniqueVertex("Select (" + table.getSqlName() + ")", supplier);
        return sourceVertex;
    }

    protected static ProcessorMetaSupplier wrap(SqlConnector.DagBuildContext ctx, ProcessorSupplier supplier) {
        MongoTable table = (MongoTable)ctx.getTable();
        return table.isForceMongoParallelismOne() ? ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)supplier) : ProcessorMetaSupplier.of((ProcessorSupplier)supplier);
    }

    private static Document translateFilter(HazelcastRexNode filterNode, RexToMongoVisitor visitor) {
        if (filterNode == null) {
            return null;
        }
        Object result = filterNode.unwrap(RexNode.class).accept(visitor);
        boolean isBson = result instanceof Bson;
        assert (isBson || result instanceof InputRef);
        if (isBson) {
            return Mappers.bsonToDocument((Bson)((Bson)result));
        }
        InputRef placeholder = (InputRef)result;
        return Mappers.bsonToDocument((Bson)Filters.eq((String)placeholder.asString(), (Object)true));
    }

    private static List<ProjectionData> translateProjections(List<HazelcastRexNode> projectionNodes, SqlConnector.DagBuildContext context, RexToMongoVisitor visitor) {
        ArrayList<ProjectionData> projection = new ArrayList<ProjectionData>();
        MongoTable table = (MongoTable)context.getTable();
        String[] externalNames = table.externalNames();
        for (int i = 0; i < projectionNodes.size(); ++i) {
            Object translated = projectionNodes.get(i).unwrap(RexNode.class).accept(visitor);
            InputRef ref = InputRef.match(translated);
            if (ref != null) {
                String externalName = externalNames[ref.getInputIndex()];
                Document projectionExpr = Mappers.bsonToDocument((Bson)Projections.include((String[])externalNames));
                projection.add(new ProjectionData(externalName, projectionExpr, i, table.fieldType(externalName)));
                continue;
            }
            Document projectionExpr = new Document("projected_value_" + i, (Object)new Document("$literal", translated));
            projection.add(new ProjectionData("projected_value_" + i, projectionExpr, i, null));
        }
        if (projection.isEmpty()) {
            throw new IllegalArgumentException("Projection list cannot be empty");
        }
        return projection;
    }

    @Override
    public boolean supportsExpression(@Nonnull HazelcastRexNode expression) {
        RexToMongoVisitor visitor = new RexToMongoVisitor();
        RexNode rexNode = expression.unwrap(RexNode.class);
        try {
            rexNode.accept(visitor);
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Override
    public boolean dmlSupportsPredicates() {
        return true;
    }
}

