/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.jet.sql.impl.aggregate.WindowUtils;
import com.hazelcast.jet.sql.impl.opt.physical.visitor.RexToExpressionVisitor;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.shaded.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.TableFunctionScan;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelColumnMapping;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexCall;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;

public abstract class SlidingWindow
extends TableFunctionScan {
    protected SlidingWindow(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, RexNode rexCall, Type elementType, RelDataType rowType, Set<RelColumnMapping> columnMappings) {
        super(cluster, traitSet, inputs, rexCall, elementType, rowType, columnMappings);
        SqlOperator operator = this.operator();
        Preconditions.checkTrue((operator == HazelcastSqlOperatorTable.TUMBLE || operator == HazelcastSqlOperatorTable.HOP ? 1 : 0) != 0, (String)("Unsupported operator: " + operator));
    }

    public final int orderingFieldIndex() {
        return ((RexInputRef)((RexCall)this.operand(1)).getOperands().get(0)).getIndex();
    }

    public final FunctionEx<ExpressionEvalContext, SlidingWindowPolicy> windowPolicyProvider() {
        QueryParameterMetadata parameterMetadata = ((HazelcastRelOptCluster)this.getCluster()).getParameterMetadata();
        RexToExpressionVisitor visitor = new RexToExpressionVisitor(PlanNodeFieldTypeProvider.FAILING_FIELD_TYPE_PROVIDER, parameterMetadata);
        if (this.operator() == HazelcastSqlOperatorTable.TUMBLE) {
            Expression windowSizeExpression = (Expression)this.operand(2).accept(visitor);
            return (FunctionEx & Serializable)context -> SlidingWindowPolicy.tumblingWinPolicy((long)WindowUtils.extractMillis(windowSizeExpression, context));
        }
        if (this.operator() == HazelcastSqlOperatorTable.HOP) {
            Expression windowSizeExpression = (Expression)this.operand(2).accept(visitor);
            Expression slideSizeExpression = (Expression)this.operand(3).accept(visitor);
            return (FunctionEx & Serializable)context -> SlidingWindowPolicy.slidingWinPolicy((long)WindowUtils.extractMillis(windowSizeExpression, context), (long)WindowUtils.extractMillis(slideSizeExpression, context));
        }
        throw new IllegalArgumentException();
    }

    public int windowStartIndex() {
        return this.getRowType().getFieldCount() - 2;
    }

    public int windowEndIndex() {
        return this.getRowType().getFieldCount() - 1;
    }

    private SqlOperator operator() {
        return ((RexCall)this.getCall()).getOperator();
    }

    private RexNode operand(int index) {
        return ((RexCall)this.getCall()).getOperands().get(index);
    }

    public RelNode getInput() {
        return SlidingWindow.sole(this.getInputs());
    }
}

