/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.logical.SortLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.ImmutableSortPhysicalRule;
import com.hazelcast.jet.sql.impl.opt.physical.LimitPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.SortPhysicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelCollationTraitDef;
import com.hazelcast.shaded.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import java.util.ArrayList;
import java.util.List;
import org.immutables.value.Value;

@Value.Enclosing
final class SortPhysicalRule
extends RelRule<RelRule.Config> {
    static final SortPhysicalRule INSTANCE = new SortPhysicalRule(Config.DEFAULT);

    private SortPhysicalRule(Config config) {
        super(config);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        SortLogicalRel logicalSort = (SortLogicalRel)call.rel(0);
        List<RelNode> transforms = SortPhysicalRule.toTransforms(logicalSort);
        for (RelNode transform : transforms) {
            call.transformTo(transform);
        }
    }

    private static List<RelNode> toTransforms(SortLogicalRel sort) {
        ArrayList sortTransforms = new ArrayList(1);
        ArrayList<RelNode> nonSortTransforms = new ArrayList<RelNode>(1);
        for (RelNode physicalInput : OptUtils.extractPhysicalRelsFromSubset(sort.getInput())) {
            boolean requiresSort = SortPhysicalRule.requiresSort(sort.getCollation(), physicalInput.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE));
            RelNode input = physicalInput;
            if (requiresSort) {
                input = SortPhysicalRule.createSort(sort, input);
            }
            if (sort.offset != null || sort.fetch != null) {
                input = SortPhysicalRule.createLimit(sort, input);
            }
            (requiresSort ? sortTransforms : nonSortTransforms).add(input);
        }
        return !nonSortTransforms.isEmpty() ? nonSortTransforms : sortTransforms;
    }

    private static boolean requiresSort(RelCollation sortCollation, RelCollation inputCollation) {
        if (sortCollation.getFieldCollations().isEmpty()) {
            return false;
        }
        List<RelFieldCollation> sortFields = sortCollation.getFieldCollations();
        List<RelFieldCollation> inputFields = inputCollation.getFieldCollations();
        if (sortFields.size() <= inputFields.size()) {
            for (int i = 0; i < sortFields.size(); ++i) {
                RelFieldCollation inputField;
                RelFieldCollation sortField = sortFields.get(i);
                if (sortField.equals(inputField = inputFields.get(i))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static SortPhysicalRel createSort(SortLogicalRel logicalSort, RelNode physicalInput) {
        RelTraitSet traitSet = OptUtils.traitPlus(physicalInput.getTraitSet(), logicalSort.getCollation());
        return new SortPhysicalRel(logicalSort.getCluster(), traitSet, physicalInput, logicalSort.getCollation(), logicalSort.getRowType());
    }

    private static LimitPhysicalRel createLimit(SortLogicalRel logicalSort, RelNode physicalInput) {
        return new LimitPhysicalRel(logicalSort.offset, logicalSort.fetch, logicalSort.getCluster(), physicalInput.getTraitSet(), physicalInput);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableSortPhysicalRule.Config.builder().description(SortPhysicalRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(SortLogicalRel.class).anyInputs()).build();

        @Override
        default public RelOptRule toRule() {
            return new SortPhysicalRule(this);
        }
    }
}

