/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.json;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastJsonType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.QueryException;

public class HazelcastJsonArrayFunction
extends HazelcastFunction {
    public static final HazelcastJsonArrayFunction INSTANCE = new HazelcastJsonArrayFunction();

    protected HazelcastJsonArrayFunction() {
        super("JSON_ARRAY", SqlKind.OTHER_FUNCTION, opBinding -> HazelcastJsonType.create(false), new ReplaceUnknownOperandTypeInference(SqlTypeName.ANY), SqlFunctionCategory.SYSTEM);
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        return TypedOperandChecker.SYMBOL.check(callBinding, throwOnFailure, 0);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.from(1);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        if (call.operandCount() == 1) {
            writer.endFunCall(frame);
            return;
        }
        for (int i = 1; i < call.operandCount(); ++i) {
            writer.sep(",");
            ((SqlNode)call.operand(i)).unparse(writer, leftPrec, rightPrec);
        }
        SqlJsonConstructorNullClause nullClause = (SqlJsonConstructorNullClause)((Object)((SqlLiteral)call.operand(0)).getValue());
        switch (nullClause) {
            case ABSENT_ON_NULL: {
                writer.keyword("ABSENT ON NULL");
                break;
            }
            case NULL_ON_NULL: {
                writer.keyword("NULL ON NULL");
                break;
            }
            default: {
                throw QueryException.error((String)("Unknown SqlJsonConstructorNullClause constant: " + (Object)((Object)nullClause)));
            }
        }
        writer.endFunCall(frame);
    }
}

