/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.special;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastSpecialOperator;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.ReplaceUnknownOperandTypeInference;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import java.util.List;

public class HazelcastMapValueConstructor
extends HazelcastSpecialOperator {
    public HazelcastMapValueConstructor() {
        super("MAP", SqlKind.MAP_VALUE_CONSTRUCTOR, 200, false, HazelcastMapValueConstructor::inferReturnType0, new ReplaceUnknownOperandTypeInference(SqlTypeName.ANY));
    }

    private static RelDataType inferReturnType0(SqlOperatorBinding binding) {
        Pair<RelDataType, RelDataType> entryType = HazelcastMapValueConstructor.findEntryType(binding.getTypeFactory(), binding.collectOperandTypes());
        return SqlTypeUtil.createMapType(binding.getTypeFactory(), (RelDataType)entryType.left, (RelDataType)entryType.right, false);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.any();
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        boolean result = HazelcastMapValueConstructor.checkOperandTypes(callBinding);
        List<RelDataType> argTypes = SqlTypeUtil.deriveAndCollectTypes(callBinding.getValidator(), callBinding.getScope(), callBinding.operands());
        if (argTypes.size() == 0) {
            throw callBinding.newValidationError(Static.RESOURCE.mapRequiresTwoOrMoreArgs());
        }
        if (argTypes.size() % 2 > 0) {
            throw callBinding.newValidationError(Static.RESOURCE.mapRequiresEvenArgCount());
        }
        Pair<RelDataType, RelDataType> entryType = HazelcastMapValueConstructor.findEntryType(callBinding.getTypeFactory(), argTypes);
        if (entryType.left == null || entryType.right == null) {
            if (throwOnFailure) {
                throw callBinding.newValidationError(Static.RESOURCE.needSameTypeParameter());
            }
            return false;
        }
        return result;
    }

    private static boolean checkOperandTypes(HazelcastCallBinding callBinding) {
        boolean result = true;
        for (int i = 0; i < callBinding.getOperandCount(); ++i) {
            result &= TypedOperandChecker.VARCHAR.check(callBinding, false, i);
        }
        return result;
    }

    private static Pair<RelDataType, RelDataType> findEntryType(RelDataTypeFactory typeFactory, List<RelDataType> argTypes) {
        return Pair.of(typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 0)), typeFactory.leastRestrictive(Util.quotientList(argTypes, 2, 1)));
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.keyword(this.getName());
        SqlWriter.Frame frame = writer.startList("[", "]");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, leftPrec, rightPrec);
        }
        writer.endList(frame);
    }
}

