/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.types;

import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.List;

public class HazelcastObjectType
extends RelDataTypeImpl {
    private final boolean nullable;
    private final String name;

    public HazelcastObjectType(String name, List<Field> fields) {
        super(fields);
        this.name = name;
        this.digest = "HZ_OBJECT(" + name + ")";
        this.nullable = true;
    }

    public HazelcastObjectType(String name, List<Field> fields, boolean nullable) {
        super(fields);
        this.name = name;
        this.digest = "HZ_OBJECT(" + name + ")";
        this.nullable = nullable;
    }

    public String getTypeName() {
        return this.name;
    }

    @Override
    protected void generateTypeString(StringBuilder sb, boolean withDetail) {
        sb.append("HZ_OBJECT(").append(this.name).append(")");
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return SqlTypeName.OTHER;
    }

    @Override
    public @Nullable RelDataTypeField getField(String fieldName, boolean caseSensitive, boolean elideRecord) {
        assert (this.fieldList != null);
        RelDataTypeFieldImpl fieldType = null;
        for (RelDataTypeField field : this.fieldList) {
            if (!fieldName.equals(field.getName())) continue;
            fieldType = new RelDataTypeFieldImpl(fieldName, field.getIndex(), field.getType());
            break;
        }
        return fieldType;
    }

    @Override
    protected void computeDigest() {
        super.computeDigest();
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    public static class Field
    extends RelDataTypeFieldImpl {
        public Field(String name, int index, RelDataType type) {
            super(name, index, type);
        }
    }
}

