/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.plan.hep;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepInstruction;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepMatchOrder;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepProgramBuilder;
import com.hazelcast.shaded.org.apache.calcite.plan.hep.HepState;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public class HepProgram
extends HepInstruction {
    public static final int MATCH_UNTIL_FIXPOINT = Integer.MAX_VALUE;
    final ImmutableList<HepInstruction> instructions;

    HepProgram(List<HepInstruction> instructions) {
        this.instructions = ImmutableList.copyOf(instructions);
    }

    public static HepProgramBuilder builder() {
        return new HepProgramBuilder();
    }

    @Override
    State prepare(HepInstruction.PrepareContext px) {
        return new State(px, this.instructions);
    }

    class State
    extends HepState {
        final ImmutableList<HepState> instructionStates;
        int matchLimit;
        HepMatchOrder matchOrder;
        @Nullable HepInstruction.EndGroup.State group;

        State(HepInstruction.PrepareContext px, List<HepInstruction> instructions) {
            super(px);
            this.matchLimit = Integer.MAX_VALUE;
            this.matchOrder = HepMatchOrder.DEPTH_FIRST;
            HepInstruction.PrepareContext px2 = px.withProgramState(Nullness.castToInitialized(this));
            ArrayList<HepState> states = new ArrayList<HepState>();
            HashMap<HepInstruction.EndGroup, Consumer<HepState>> actions = new HashMap<HepInstruction.EndGroup, Consumer<HepState>>();
            for (HepInstruction instruction : instructions) {
                HepState state;
                if (instruction instanceof HepInstruction.BeginGroup) {
                    int i = states.size();
                    actions.put(((HepInstruction.BeginGroup)instruction).endGroup, state2 -> states.set(i, instruction.prepare(px2.withEndGroupState((HepInstruction.EndGroup.State)state2))));
                    state = Nullness.castNonNull(null);
                } else {
                    state = instruction.prepare(px2);
                    if (actions.containsKey(instruction)) {
                        ((Consumer)actions.get(instruction)).accept(state);
                    }
                }
                states.add(state);
            }
            this.instructionStates = ImmutableList.copyOf(states);
        }

        @Override
        void init() {
            this.matchLimit = Integer.MAX_VALUE;
            this.matchOrder = HepMatchOrder.DEPTH_FIRST;
            this.group = null;
        }

        @Override
        void execute() {
            this.planner.executeProgram(HepProgram.this, this);
        }

        boolean skippingGroup() {
            if (this.group != null) {
                return !this.group.collecting;
            }
            return false;
        }
    }
}

