/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.rel.rules;

import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.plan.Contexts;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Filter;
import com.hazelcast.shaded.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.ImmutableFilterAggregateTransposeRule;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.shaded.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import java.util.ArrayList;
import java.util.List;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterAggregateTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected FilterAggregateTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public FilterAggregateTransposeRule(Class<? extends Filter> filterClass, RelBuilderFactory relBuilderFactory, Class<? extends Aggregate> aggregateClass) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withOperandFor(filterClass, aggregateClass));
    }

    @Deprecated
    protected FilterAggregateTransposeRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).withOperandSupplier(b -> b.exactly(operand)).as(Config.class));
    }

    @Deprecated
    public FilterAggregateTransposeRule(Class<? extends Filter> filterClass, RelFactories.FilterFactory filterFactory, Class<? extends Aggregate> aggregateClass) {
        this(filterClass, RelBuilder.proto(Contexts.of((Object)filterFactory)), aggregateClass);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        Aggregate aggRel = (Aggregate)call.rel(1);
        List<RexNode> conditions = RelOptUtil.conjunctions(filterRel.getCondition());
        RexBuilder rexBuilder = filterRel.getCluster().getRexBuilder();
        List<RelDataTypeField> origFields = aggRel.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        int j = 0;
        for (int i : aggRel.getGroupSet()) {
            adjustments[j] = i - j;
            ++j;
        }
        ArrayList<RexNode> pushedConditions = new ArrayList<RexNode>();
        ArrayList<RexNode> remainingConditions = new ArrayList<RexNode>();
        for (RexNode condition : conditions) {
            ImmutableBitSet rCols = RelOptUtil.InputFinder.bits(condition);
            if (FilterAggregateTransposeRule.canPush(aggRel, rCols)) {
                pushedConditions.add(condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, aggRel.getInput(0).getRowType().getFieldList(), adjustments)));
                continue;
            }
            remainingConditions.add(condition);
        }
        RelBuilder builder = call.builder();
        RelNode rel = builder.push(aggRel.getInput()).filter(pushedConditions).build();
        if (rel == aggRel.getInput(0)) {
            return;
        }
        rel = aggRel.copy(aggRel.getTraitSet(), ImmutableList.of(rel));
        rel = builder.push(rel).filter(remainingConditions).build();
        call.transformTo(rel);
    }

    private static boolean canPush(Aggregate aggregate, ImmutableBitSet rCols) {
        ImmutableBitSet groupKeys = ImmutableBitSet.range(0, aggregate.getGroupSet().cardinality());
        if (!groupKeys.contains(rCols)) {
            return false;
        }
        if (aggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            for (ImmutableBitSet groupingSet : aggregate.getGroupSets()) {
                if (groupingSet.contains(rCols)) continue;
                return false;
            }
        }
        return true;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterAggregateTransposeRule.Config.of().withOperandFor(Filter.class, Aggregate.class);

        @Override
        default public FilterAggregateTransposeRule toRule() {
            return new FilterAggregateTransposeRule(this);
        }

        default public Config withOperandFor(Class<? extends Filter> filterClass, Class<? extends Aggregate> aggregateClass) {
            return this.withOperandSupplier(b0 -> b0.operand(filterClass).oneInput(b1 -> b1.operand(aggregateClass).anyInputs())).as(Config.class);
        }

        default public Config withOperandFor(Class<? extends Filter> filterClass, Class<? extends Aggregate> aggregateClass, Class<? extends RelNode> relClass) {
            return this.withOperandSupplier(b0 -> b0.operand(filterClass).oneInput(b1 -> b1.operand(aggregateClass).oneInput(b2 -> b2.operand(relClass).anyInputs()))).as(Config.class);
        }
    }
}

