/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.InteriorPointArea;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.InteriorPointLine;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.InteriorPointPoint;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryCollection;
import com.hazelcast.shaded.org.locationtech.jts.geom.GeometryFilter;

public class InteriorPoint {
    public static Coordinate getInteriorPoint(Geometry geom) {
        if (geom.isEmpty()) {
            return null;
        }
        Coordinate interiorPt = null;
        int dim = InteriorPoint.effectiveDimension(geom);
        if (dim < 0) {
            return null;
        }
        interiorPt = dim == 0 ? InteriorPointPoint.getInteriorPoint(geom) : (dim == 1 ? InteriorPointLine.getInteriorPoint(geom) : InteriorPointArea.getInteriorPoint(geom));
        return interiorPt;
    }

    private static int effectiveDimension(Geometry geom) {
        EffectiveDimensionFilter dimFilter = new EffectiveDimensionFilter();
        geom.apply(dimFilter);
        return dimFilter.getDimension();
    }

    private static class EffectiveDimensionFilter
    implements GeometryFilter {
        private int dim = -1;

        private EffectiveDimensionFilter() {
        }

        public int getDimension() {
            return this.dim;
        }

        @Override
        public void filter(Geometry elem) {
            int elemDim;
            if (elem instanceof GeometryCollection) {
                return;
            }
            if (!elem.isEmpty() && (elemDim = elem.getDimension()) > this.dim) {
                this.dim = elemDim;
            }
        }
    }
}

