/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.operation.overlayng;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.io.OrdinateFormat;
import com.hazelcast.shaded.org.locationtech.jts.operation.overlayng.Edge;

class EdgeKey
implements Comparable<EdgeKey> {
    private double p0x;
    private double p0y;
    private double p1x;
    private double p1y;

    public static EdgeKey create(Edge edge) {
        return new EdgeKey(edge);
    }

    EdgeKey(Edge edge) {
        this.initPoints(edge);
    }

    private void initPoints(Edge edge) {
        boolean direction = edge.direction();
        if (direction) {
            this.init(edge.getCoordinate(0), edge.getCoordinate(1));
        } else {
            int len = edge.size();
            this.init(edge.getCoordinate(len - 1), edge.getCoordinate(len - 2));
        }
    }

    private void init(Coordinate p0, Coordinate p1) {
        this.p0x = p0.getX();
        this.p0y = p0.getY();
        this.p1x = p1.getX();
        this.p1y = p1.getY();
    }

    @Override
    public int compareTo(EdgeKey ek) {
        if (this.p0x < ek.p0x) {
            return -1;
        }
        if (this.p0x > ek.p0x) {
            return 1;
        }
        if (this.p0y < ek.p0y) {
            return -1;
        }
        if (this.p0y > ek.p0y) {
            return 1;
        }
        if (this.p1x < ek.p1x) {
            return -1;
        }
        if (this.p1x > ek.p1x) {
            return 1;
        }
        if (this.p1y < ek.p1y) {
            return -1;
        }
        if (this.p1y > ek.p1y) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (!(o instanceof EdgeKey)) {
            return false;
        }
        EdgeKey ek = (EdgeKey)o;
        return this.p0x == ek.p0x && this.p0y == ek.p0y && this.p1x == ek.p1x && this.p1y == ek.p1y;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + EdgeKey.hashCode(this.p0x);
        result = 37 * result + EdgeKey.hashCode(this.p0y);
        result = 37 * result + EdgeKey.hashCode(this.p1x);
        result = 37 * result + EdgeKey.hashCode(this.p1y);
        return result;
    }

    public static int hashCode(double x) {
        long f = Double.doubleToLongBits(x);
        return (int)(f ^ f >>> 32);
    }

    public String toString() {
        return "EdgeKey(" + this.format(this.p0x, this.p0y) + ", " + this.format(this.p1x, this.p1y) + ")";
    }

    private String format(double x, double y) {
        return OrdinateFormat.DEFAULT.format(x) + " " + OrdinateFormat.DEFAULT.format(y);
    }
}

