/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.impl.getters.EvictableGetterCache;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.query.impl.getters.GetterCache;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;

public class FieldAccessExpression<T>
implements Expression<T> {
    private static final int MAX_CLASS_COUNT = 10;
    private static final int MAX_GETTER_PER_CLASS_COUNT = 1;
    private final AtomicReference<GetterCache> getterCache = new AtomicReference();
    private QueryDataType type;
    private String name;
    private Expression<?> ref;

    public FieldAccessExpression() {
    }

    private FieldAccessExpression(QueryDataType type, String name, Expression<?> ref) {
        this.type = type;
        this.name = name;
        this.ref = ref;
    }

    public static FieldAccessExpression<?> create(QueryDataType type, String name, Expression<?> ref) {
        return new FieldAccessExpression(type, name, ref);
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context) {
        return this.eval(row, context, false);
    }

    @Override
    public T eval(Row row, ExpressionEvalContext context, boolean useLazyDeserialization) {
        Object res = this.ref.eval(row, context, true);
        if (res == null) {
            return null;
        }
        if (this.isPrimitive(res.getClass())) {
            throw QueryException.error((String)"Field Access expression can not be applied to primitive types");
        }
        if (this.getterCache.get() == null) {
            this.getterCache.compareAndSet(null, (GetterCache)new EvictableGetterCache(10, 1, 0.2f, false));
        }
        GetterCache cache = this.getterCache.get();
        assert (cache != null) : "GetterCache should never be null";
        Extractors extractors = Extractors.newBuilder((InternalSerializationService)context.getSerializationService()).setGetterCacheSupplier(() -> cache).build();
        try {
            return (T)this.type.convert(extractors.extract(res, this.name, (Object)useLazyDeserialization));
        }
        catch (Exception e) {
            throw QueryException.error((String)"Failed to extract field");
        }
    }

    private boolean isPrimitive(Class<?> clazz) {
        return clazz.getPackage().getName().startsWith("java.");
    }

    public int getClassId() {
        return 77;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.type);
        out.writeString(this.name);
        out.writeObject(this.ref);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.type = (QueryDataType)in.readObject();
        this.name = in.readString();
        this.ref = (Expression)in.readObject();
    }

    @Override
    public QueryDataType getType() {
        return this.type;
    }

    @Override
    public boolean isCooperative() {
        return this.ref.isCooperative();
    }
}

