/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.datetime;

import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.datetime.ExtractField;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public final class DateTimeUtils {
    private DateTimeUtils() {
    }

    public static OffsetDateTime asTimestampWithTimezone(long millis, ZoneId zoneId) {
        return OffsetDateTime.ofInstant(Instant.ofEpochMilli(millis), zoneId);
    }

    public static OffsetDateTime asTimestampWithTimezone(Expression<?> expression, Row row, ExpressionEvalContext context) {
        Object res = expression.eval(row, context);
        if (res == null) {
            return null;
        }
        return expression.getType().getConverter().asTimestampWithTimezone(res);
    }

    public static double extractField(Object object, ExtractField field) {
        if (object instanceof OffsetDateTime) {
            return field.extract((OffsetDateTime)object);
        }
        if (object instanceof ZonedDateTime) {
            return field.extract(((ZonedDateTime)object).toOffsetDateTime());
        }
        if (object instanceof LocalDateTime) {
            return field.extract((LocalDateTime)object);
        }
        if (object instanceof LocalDate) {
            return field.extract((LocalDate)object);
        }
        if (object instanceof LocalTime) {
            return field.extract((LocalTime)object);
        }
        QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(object.getClass());
        throw new IllegalArgumentException("Cannot extract field from " + type.getTypeFamily().getPublicType());
    }
}

