/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema;

import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class Table {
    protected boolean streaming;
    private final String schemaName;
    private final String sqlName;
    private List<TableField> fields;
    private final TableStatistics statistics;
    private Set<String> conflictingSchemas;
    private final String objectType;

    protected Table(String schemaName, String sqlName, List<TableField> fields, TableStatistics statistics, String objectType, boolean isStreaming) {
        this.schemaName = schemaName;
        this.sqlName = sqlName;
        this.fields = fields;
        this.statistics = statistics;
        this.objectType = objectType;
        this.streaming = isStreaming;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public List<TableField> getFields() {
        if (this.fields == null) {
            this.fields = this.initFields();
        }
        return this.fields;
    }

    protected List<TableField> initFields() {
        throw new AssertionError((Object)"initFields() should be overridden");
    }

    public int getFieldCount() {
        return this.getFields().size();
    }

    public <T extends TableField> T getField(int index) {
        return (T)this.getFields().get(index);
    }

    public int getFieldIndex(String fieldName) {
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (!((TableField)this.getField(i)).getName().equals(fieldName)) continue;
            return i;
        }
        return -1;
    }

    public TableStatistics getStatistics() {
        return this.statistics;
    }

    public abstract PlanObjectKey getObjectKey();

    public Set<String> getConflictingSchemas() {
        return this.conflictingSchemas != null ? this.conflictingSchemas : Collections.emptySet();
    }

    public void setConflictingSchemas(Set<String> conflictingSchemas) {
        this.conflictingSchemas = conflictingSchemas;
    }

    public String getObjectType() {
        return this.objectType;
    }
}

