/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.NotConvertible;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;

public abstract class Converter
implements Serializable {
    protected static final int ID_BOOLEAN = 0;
    protected static final int ID_BYTE = 1;
    protected static final int ID_SHORT = 2;
    protected static final int ID_INTEGER = 3;
    protected static final int ID_LONG = 4;
    protected static final int ID_BIG_INTEGER = 5;
    protected static final int ID_BIG_DECIMAL = 6;
    protected static final int ID_FLOAT = 7;
    protected static final int ID_DOUBLE = 8;
    protected static final int ID_CHARACTER = 9;
    protected static final int ID_STRING = 10;
    protected static final int ID_DATE = 11;
    protected static final int ID_CALENDAR = 12;
    protected static final int ID_LOCAL_DATE = 13;
    protected static final int ID_LOCAL_TIME = 14;
    protected static final int ID_LOCAL_DATE_TIME = 15;
    protected static final int ID_INSTANT = 16;
    protected static final int ID_OFFSET_DATE_TIME = 17;
    protected static final int ID_ZONED_DATE_TIME = 18;
    protected static final int ID_OBJECT = 19;
    protected static final int ID_NULL = 20;
    protected static final int ID_INTERVAL_YEAR_MONTH = 21;
    protected static final int ID_INTERVAL_DAY_SECOND = 22;
    protected static final int ID_MAP = 23;
    protected static final int ID_JSON = 24;
    protected static final int ID_ROW = 25;
    private final int id;
    private final QueryDataTypeFamily typeFamily;
    private final boolean convertToBoolean;
    private final boolean convertToTinyint;
    private final boolean convertToSmallint;
    private final boolean convertToInt;
    private final boolean convertToBigint;
    private final boolean convertToDecimal;
    private final boolean convertToReal;
    private final boolean convertToDouble;
    private final boolean convertToVarchar;
    private final boolean convertToDate;
    private final boolean convertToTime;
    private final boolean convertToTimestamp;
    private final boolean convertToTimestampWithTimezone;
    private final boolean convertToObject;
    private final boolean convertToJson;
    private final boolean convertToRow;

    protected Converter(int id, QueryDataTypeFamily typeFamily) {
        this.id = id;
        this.typeFamily = typeFamily;
        try {
            Class<?> clazz = this.getClass();
            this.convertToBoolean = Converter.canConvert(clazz.getMethod("asBoolean", Object.class));
            this.convertToTinyint = Converter.canConvert(clazz.getMethod("asTinyint", Object.class));
            this.convertToSmallint = Converter.canConvert(clazz.getMethod("asSmallint", Object.class));
            this.convertToInt = Converter.canConvert(clazz.getMethod("asInt", Object.class));
            this.convertToBigint = Converter.canConvert(clazz.getMethod("asBigint", Object.class));
            this.convertToDecimal = Converter.canConvert(clazz.getMethod("asDecimal", Object.class));
            this.convertToReal = Converter.canConvert(clazz.getMethod("asReal", Object.class));
            this.convertToDouble = Converter.canConvert(clazz.getMethod("asDouble", Object.class));
            this.convertToVarchar = Converter.canConvert(clazz.getMethod("asVarchar", Object.class));
            this.convertToDate = Converter.canConvert(clazz.getMethod("asDate", Object.class));
            this.convertToTime = Converter.canConvert(clazz.getMethod("asTime", Object.class));
            this.convertToTimestamp = Converter.canConvert(clazz.getMethod("asTimestamp", Object.class));
            this.convertToTimestampWithTimezone = Converter.canConvert(clazz.getMethod("asTimestampWithTimezone", Object.class));
            this.convertToObject = Converter.canConvert(clazz.getMethod("asObject", Object.class));
            this.convertToJson = Converter.canConvert(clazz.getMethod("asJson", Object.class));
            this.convertToRow = Converter.canConvert(clazz.getMethod("asRow", Object.class));
        }
        catch (ReflectiveOperationException e) {
            throw new HazelcastException("Failed to initialize converter: " + this.getClass().getName(), (Throwable)e);
        }
    }

    public final int getId() {
        return this.id;
    }

    public final QueryDataTypeFamily getTypeFamily() {
        return this.typeFamily;
    }

    public abstract Class<?> getValueClass();

    public Class<?> getNormalizedValueClass() {
        return this.getValueClass();
    }

    @NotConvertible
    public boolean asBoolean(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.BOOLEAN);
    }

    @NotConvertible
    public byte asTinyint(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.TINYINT);
    }

    @NotConvertible
    public short asSmallint(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.SMALLINT);
    }

    @NotConvertible
    public int asInt(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.INTEGER);
    }

    @NotConvertible
    public long asBigint(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.BIGINT);
    }

    @NotConvertible
    public BigDecimal asDecimal(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.DECIMAL);
    }

    @NotConvertible
    public float asReal(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.REAL);
    }

    @NotConvertible
    public double asDouble(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.DOUBLE);
    }

    @NotConvertible
    public String asVarchar(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.VARCHAR);
    }

    @NotConvertible
    public LocalDate asDate(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.DATE);
    }

    @NotConvertible
    public LocalTime asTime(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.TIME);
    }

    @NotConvertible
    public LocalDateTime asTimestamp(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.TIMESTAMP);
    }

    @NotConvertible
    public OffsetDateTime asTimestampWithTimezone(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE);
    }

    @NotConvertible
    public HazelcastJsonValue asJson(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.JSON);
    }

    @NotConvertible
    public Object asRow(Object val) {
        throw this.cannotConvertError(QueryDataTypeFamily.ROW);
    }

    public Object asObject(Object val) {
        return val;
    }

    public final boolean canConvertToBoolean() {
        return this.convertToBoolean;
    }

    public final boolean canConvertToTinyint() {
        return this.convertToTinyint;
    }

    public final boolean canConvertToSmallint() {
        return this.convertToSmallint;
    }

    public final boolean canConvertToInt() {
        return this.convertToInt;
    }

    public final boolean canConvertToBigint() {
        return this.convertToBigint;
    }

    public final boolean canConvertToDecimal() {
        return this.convertToDecimal;
    }

    public final boolean canConvertToReal() {
        return this.convertToReal;
    }

    public final boolean canConvertToDouble() {
        return this.convertToDouble;
    }

    public final boolean canConvertToVarchar() {
        return this.convertToVarchar;
    }

    public final boolean canConvertToDate() {
        return this.convertToDate;
    }

    public final boolean canConvertToTime() {
        return this.convertToTime;
    }

    public final boolean canConvertToTimestamp() {
        return this.convertToTimestamp;
    }

    public final boolean canConvertToTimestampWithTimezone() {
        return this.convertToTimestampWithTimezone;
    }

    public final boolean canConvertToObject() {
        return this.convertToObject;
    }

    public final boolean canConvertToJson() {
        return this.convertToJson;
    }

    public final boolean canConvertToRow() {
        return this.convertToRow;
    }

    public final boolean canConvertTo(QueryDataTypeFamily typeFamily) {
        switch (typeFamily) {
            case BOOLEAN: {
                return this.canConvertToBoolean();
            }
            case TINYINT: {
                return this.canConvertToTinyint();
            }
            case SMALLINT: {
                return this.canConvertToSmallint();
            }
            case INTEGER: {
                return this.canConvertToInt();
            }
            case BIGINT: {
                return this.canConvertToBigint();
            }
            case DECIMAL: {
                return this.canConvertToDecimal();
            }
            case REAL: {
                return this.canConvertToReal();
            }
            case DOUBLE: {
                return this.canConvertToDouble();
            }
            case VARCHAR: {
                return this.canConvertToVarchar();
            }
            case DATE: {
                return this.canConvertToDate();
            }
            case TIME: {
                return this.canConvertToTime();
            }
            case TIMESTAMP: {
                return this.canConvertToTimestamp();
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                return this.canConvertToTimestampWithTimezone();
            }
            case OBJECT: {
                return this.canConvertToObject();
            }
            case JSON: {
                return this.canConvertToJson();
            }
            case ROW: {
                return this.canConvertToRow();
            }
        }
        return this.getTypeFamily() == typeFamily;
    }

    public abstract Object convertToSelf(Converter var1, Object var2);

    protected final QueryException cannotConvertError(QueryDataTypeFamily target) {
        String message = "Cannot convert " + (Object)((Object)this.typeFamily) + " to " + (Object)((Object)target);
        return QueryException.error((int)2000, (String)message);
    }

    protected final QueryException numericOverflowError(QueryDataTypeFamily target) {
        String message = "Numeric overflow while converting " + (Object)((Object)this.typeFamily) + " to " + (Object)((Object)target);
        return QueryException.error((int)2000, (String)message);
    }

    protected final QueryException infiniteValueError(QueryDataTypeFamily target) {
        String message = "Cannot convert infinite " + (Object)((Object)this.typeFamily) + " to " + (Object)((Object)target);
        return QueryException.error((int)2000, (String)message);
    }

    protected final QueryException nanValueError(QueryDataTypeFamily target) {
        String message = "Cannot convert NaN to " + (Object)((Object)target);
        return QueryException.error((int)2000, (String)message);
    }

    private static boolean canConvert(Method method) {
        return method.getAnnotation(NotConvertible.class) == null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

