/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Interfaces and classes used by the various implementations in the sub-packages.
 * <p>
 * Definitive implementations of commonly used encoders and decoders.
 * </p>
 * <p>
 * Codec is currently comprised of a modest set of utilities and a simple framework for String encoding and decoding in the following packages:
 * </p>
 * <ul>
 * <li><a href="binary/package-summary.html">Binary codecs.</a></li>
 * <li><a href="cli/package-summary.html">Command line utility.</a></li>
 * <li><a href="digest/package-summary.html">Digests and hashers</a></li>
 * <li><a href="language/package-summary.html">Common language and phonetic encoders.</a></li>
 * <li><a href="language/bm/package-summary.html">Beider-Morse codec.</a></li>
 * <li><a href="net/package-summary.html">Network codecs.</a></li>
 * </ul>
 */
package com.hazelcast.shaded.org.apache.commons.codec;
