/*
 * Copyright 2024 Hazelcast Inc.
 *
 * Licensed under the Hazelcast Community License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://hazelcast.com/hazelcast-community-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.hazelcast.sql.impl.type;

/**
 * Exception thrown in case of data type mismatch.
 */
public class QueryDataTypeMismatchException extends RuntimeException {

    private final Class<?> expectedClass;
    private final Class<?> actualClass;

    public QueryDataTypeMismatchException(Class<?> expectedClass, Class<?> actualClass) {
        this.expectedClass = expectedClass;
        this.actualClass = actualClass;
    }

    public Class<?> getExpectedClass() {
        return expectedClass;
    }

    public Class<?> getActualClass() {
        return actualClass;
    }
}
