/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.infoschema;

import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.json.JsonUtil;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.infoschema.InfoSchemaTable;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DataConnectionsTable
extends InfoSchemaTable {
    private static final String NAME = "dataconnections";
    private static final List<TableField> FIELDS = Arrays.asList(new TableField("catalog", QueryDataType.VARCHAR, false), new TableField("schema", QueryDataType.VARCHAR, false), new TableField("name", QueryDataType.VARCHAR, false), new TableField("type", QueryDataType.VARCHAR, false), new TableField("shared", QueryDataType.BOOLEAN, false), new TableField("options", QueryDataType.VARCHAR, false), new TableField("source", QueryDataType.VARCHAR, false));
    private final String dataConnectionSchema;
    private final Collection<DataConnectionCatalogEntry> dataConnectionCatalogEntries;
    private final SqlConnectorCache connectorCache;
    private final boolean securityEnabled;

    public DataConnectionsTable(String catalog, String schemaName, String dataConnectionSchema, Collection<DataConnectionCatalogEntry> dataConnectionCatalogEntries, SqlConnectorCache connectorCache, boolean securityEnabled) {
        super(FIELDS, catalog, schemaName, NAME, new ConstantTableStatistics(0L));
        this.dataConnectionSchema = dataConnectionSchema;
        this.dataConnectionCatalogEntries = dataConnectionCatalogEntries;
        this.connectorCache = connectorCache;
        this.securityEnabled = securityEnabled;
    }

    @Override
    protected List<Object[]> rows() {
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this.dataConnectionCatalogEntries.size());
        for (DataConnectionCatalogEntry dl : this.dataConnectionCatalogEntries) {
            Map<String, String> options;
            if (!this.securityEnabled) {
                options = dl.options();
            } else {
                options = new TreeMap<String, String>();
                Set<String> safeOptions = this.connectorCache.forType(dl.type()).nonSensitiveConnectorOptions();
                for (Map.Entry<String, String> e : dl.options().entrySet()) {
                    if (!safeOptions.contains(e.getKey())) continue;
                    options.put(e.getKey(), e.getValue());
                }
            }
            Object[] row = new Object[]{this.catalog(), this.dataConnectionSchema, dl.name(), dl.type(), dl.isShared(), Util.uncheckCall(() -> JsonUtil.toJson((Object)options)), dl.source().name()};
            rows.add(row);
        }
        return rows;
    }
}

