/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.WriteJdbcP;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractJdbcSqlConnectorProcessorSupplier;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.security.impl.function.SecuredFunction;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.sql.CommonDataSource;

public class DmlProcessorSupplier
extends AbstractJdbcSqlConnectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable,
SecuredFunction {
    private String query;
    private int[] dynamicParams;
    private int[] inputRefs;
    private int batchLimit;
    private transient ExpressionEvalContext evalContext;

    public DmlProcessorSupplier() {
    }

    public DmlProcessorSupplier(@Nonnull String dataConnectionName, @Nonnull String query, @Nonnull int[] dynamicParams, @Nonnull int[] inputRefs, int batchLimit) {
        super(dataConnectionName);
        this.query = Objects.requireNonNull(query, "query must not be null");
        this.dynamicParams = Objects.requireNonNull(dynamicParams, "dynamicParams must not be null");
        this.inputRefs = Objects.requireNonNull(inputRefs, "inputRefs must not be null");
        this.batchLimit = batchLimit;
    }

    @Override
    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        super.init(context);
        this.evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<WriteJdbcP> processors = new ArrayList<WriteJdbcP>(count);
        for (int i = 0; i < count; ++i) {
            WriteJdbcP processor = new WriteJdbcP(this.query, (CommonDataSource)this.dataSource, (BiConsumerEx & Serializable)(ps, row) -> {
                Object v;
                int j;
                List<Object> arguments = this.evalContext.getArguments();
                for (j = 0; j < this.dynamicParams.length; ++j) {
                    v = arguments.get(this.dynamicParams[j]);
                    ps.setObject(j + 1, v);
                }
                for (j = 0; j < this.inputRefs.length; ++j) {
                    v = row.get(this.inputRefs[j]);
                    ps.setObject(this.dynamicParams.length + j + 1, v);
                }
            }, false, this.batchLimit);
            processors.add(processor);
        }
        return processors;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.dataConnectionName);
        out.writeString(this.query);
        out.writeIntArray(this.dynamicParams);
        out.writeIntArray(this.inputRefs);
        out.writeInt(this.batchLimit);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.dataConnectionName = in.readString();
        this.query = in.readString();
        this.dynamicParams = in.readIntArray();
        this.inputRefs = in.readIntArray();
        this.batchLimit = in.readInt();
    }
}

