/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.Serializable;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;

final class GettersProvider {
    public static final Map<QueryDataType, BiFunctionEx<ResultSet, Integer, ?>> GETTERS = new HashMap();

    private GettersProvider() {
    }

    static {
        GETTERS.put(QueryDataType.BOOLEAN, ResultSet::getBoolean);
        GETTERS.put(QueryDataType.TINYINT, ResultSet::getByte);
        GETTERS.put(QueryDataType.SMALLINT, ResultSet::getShort);
        GETTERS.put(QueryDataType.INT, ResultSet::getInt);
        GETTERS.put(QueryDataType.BIGINT, ResultSet::getLong);
        GETTERS.put(QueryDataType.VARCHAR, ResultSet::getString);
        GETTERS.put(QueryDataType.REAL, ResultSet::getFloat);
        GETTERS.put(QueryDataType.DOUBLE, ResultSet::getDouble);
        GETTERS.put(QueryDataType.DECIMAL, ResultSet::getBigDecimal);
        GETTERS.put(QueryDataType.DATE, (BiFunctionEx & Serializable)(rs, columnIndex) -> rs.getObject((int)columnIndex, LocalDate.class));
        GETTERS.put(QueryDataType.TIME, (BiFunctionEx & Serializable)(rs, columnIndex) -> rs.getObject((int)columnIndex, LocalTime.class));
        GETTERS.put(QueryDataType.TIMESTAMP, (BiFunctionEx & Serializable)(rs, columnIndex) -> rs.getObject((int)columnIndex, LocalDateTime.class));
        GETTERS.put(QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, (BiFunctionEx & Serializable)(rs, columnIndex) -> rs.getObject((int)columnIndex, OffsetDateTime.class));
    }
}

