/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.IndexScanSelectQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcJoinFullScanProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcJoinPredicateScanProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.SelectQueryBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import java.util.List;

public final class JdbcJoiner {
    private JdbcJoiner() {
    }

    public static ProcessorSupplier createJoinProcessorSupplier(JetJoinInfo joinInfo, SqlConnector.DagBuildContext context, HazelcastRexNode predicate, List<HazelcastRexNode> projection) {
        JdbcTable jdbcTable = (JdbcTable)context.getTable();
        SqlDialect dialect = JdbcSqlConnector.resolveDialect(jdbcTable, context);
        RexNode rexNodePredicate = predicate == null ? null : predicate.unwrap(RexNode.class);
        List rexNodeProjection = Util.toList(projection, n -> n.unwrap(RexNode.class));
        if (!joinInfo.isEquiJoin()) {
            SelectQueryBuilder queryBuilder = new SelectQueryBuilder(jdbcTable, dialect, rexNodePredicate, rexNodeProjection);
            String selectQueryForRightSide = queryBuilder.query();
            return new JdbcJoinFullScanProcessorSupplier(jdbcTable.getDataConnectionName(), selectQueryForRightSide, queryBuilder.converters(), joinInfo, context.convertProjection(projection));
        }
        IndexScanSelectQueryBuilder queryBuilder = new IndexScanSelectQueryBuilder(jdbcTable, dialect, rexNodePredicate, rexNodeProjection, joinInfo);
        String selectQueryForRightSide = queryBuilder.query();
        return new JdbcJoinPredicateScanProcessorSupplier(jdbcTable.getDataConnectionName(), selectQueryForRightSide, queryBuilder.converters(), joinInfo, context.convertProjection(projection));
    }
}

