/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.dataconnection.impl.DatabaseDialect;
import com.hazelcast.dataconnection.impl.JdbcDataConnection;
import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.jdbc.DefaultTypeResolver;
import com.hazelcast.jet.sql.impl.connector.jdbc.DeleteQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.DmlProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.GettersProvider;
import com.hazelcast.jet.sql.impl.connector.jdbc.InsertProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.InsertQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcJoiner;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTableField;
import com.hazelcast.jet.sql.impl.connector.jdbc.SelectProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.SelectQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.SingleItemSourceP;
import com.hazelcast.jet.sql.impl.connector.jdbc.SupportedDatabases;
import com.hazelcast.jet.sql.impl.connector.jdbc.SupportsRexVisitor;
import com.hazelcast.jet.sql.impl.connector.jdbc.TypeResolver;
import com.hazelcast.jet.sql.impl.connector.jdbc.UpdateQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.UpsertBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.UpsertProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.jdbc.mssql.HazelcastMSSQLDialect;
import com.hazelcast.jet.sql.impl.connector.jdbc.mysql.HazelcastMySqlDialect;
import com.hazelcast.jet.sql.impl.connector.jdbc.oracle.HazelcastOracleDialect;
import com.hazelcast.jet.sql.impl.connector.jdbc.postgres.HazelcastPostgresDialect;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialectFactoryImpl;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialects;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JdbcSqlConnector
implements SqlConnector {
    public static final String TYPE_NAME = "JDBC";
    private static final JetSqlRow DUMMY_INPUT_ROW = new JetSqlRow(null, new Object[0]);

    @Override
    public String typeName() {
        return TYPE_NAME;
    }

    @Override
    @Nonnull
    public String defaultObjectType() {
        return "Table";
    }

    @Override
    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> userFields) {
        if (externalResource.dataConnection() == null) {
            throw QueryException.error((String)"You must provide data connection when using the Jdbc connector");
        }
        ExternalJdbcTableName.validateExternalName(externalResource.externalName());
        JdbcDataConnection dataConnection = (JdbcDataConnection)nodeEngine.getDataConnectionService().getAndRetainDataConnection(externalResource.dataConnection(), JdbcDataConnection.class);
        try {
            ArrayList<MappingField> arrayList;
            block19: {
                Connection connection = dataConnection.getConnection();
                try {
                    TypeResolver typeResolver = JdbcSqlConnector.typeResolver(connection);
                    Map<String, DbField> dbFields = this.readDbFields(connection, externalResource.externalName());
                    ArrayList<MappingField> resolvedFields = new ArrayList<MappingField>();
                    if (userFields.isEmpty()) {
                        for (DbField dbField : dbFields.values()) {
                            MappingField mappingField = new MappingField(dbField.columnName, typeResolver.resolveType(dbField.columnTypeName, dbField.precision, dbField.scale));
                            mappingField.setPrimaryKey(dbField.primaryKey);
                            resolvedFields.add(mappingField);
                        }
                    } else {
                        for (MappingField f : userFields) {
                            MappingField mappingField;
                            DbField dbField;
                            if (f.externalName() != null) {
                                dbField = dbFields.get(f.externalName());
                                if (dbField == null) {
                                    throw QueryException.error((String)("Could not resolve field with external name " + f.externalName()));
                                }
                                this.validateType(typeResolver, f, dbField);
                                mappingField = new MappingField(f.name(), f.type(), f.externalName(), dbField.columnTypeName);
                                mappingField.setPrimaryKey(dbField.primaryKey);
                                resolvedFields.add(mappingField);
                                continue;
                            }
                            dbField = dbFields.get(f.name());
                            if (dbField == null) {
                                throw QueryException.error((String)("Could not resolve field with name " + f.name()));
                            }
                            this.validateType(typeResolver, f, dbField);
                            mappingField = new MappingField(f.name(), f.type());
                            mappingField.setPrimaryKey(dbField.primaryKey);
                            resolvedFields.add(mappingField);
                        }
                    }
                    arrayList = resolvedFields;
                    if (connection == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new HazelcastSqlException("Could not resolve and validate fields", (Throwable)e);
                    }
                }
                connection.close();
            }
            return arrayList;
        }
        finally {
            dataConnection.release();
        }
    }

    static TypeResolver typeResolver(Connection connection) {
        try {
            SqlDialect dialect = JdbcSqlConnector.resolveDialect(connection.getMetaData());
            if (dialect instanceof TypeResolver) {
                return (TypeResolver)((Object)dialect);
            }
            return DefaultTypeResolver::resolveType;
        }
        catch (SQLException e) {
            throw new HazelcastSqlException("Could not create type resolver", (Throwable)e);
        }
    }

    private Map<String, DbField> readDbFields(Connection connection, String[] externalName) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ExternalJdbcTableName externalTableName = new ExternalJdbcTableName(externalName, databaseMetaData);
            JdbcSqlConnector.checkTableExists(externalTableName, databaseMetaData);
            Set<String> pkColumns = JdbcSqlConnector.readPrimaryKeyColumns(externalTableName, databaseMetaData);
            return JdbcSqlConnector.readColumns(externalTableName, databaseMetaData, pkColumns);
        }
        catch (Exception exception) {
            throw new HazelcastException("Could not execute readDbFields for table " + QueryUtils.quoteCompoundIdentifier(externalName), (Throwable)exception);
        }
    }

    private static void checkTableExists(ExternalJdbcTableName externalTableName, DatabaseMetaData databaseMetaData) throws SQLException {
        String table = externalTableName.table;
        if (JdbcSqlConnector.isMySQL(databaseMetaData)) {
            SqlDialect dialect = JdbcSqlConnector.resolveDialect(databaseMetaData);
            table = dialect.quoteIdentifier(table);
        }
        Connection connection = databaseMetaData.getConnection();
        String catalog = externalTableName.catalog != null ? externalTableName.catalog : connection.getCatalog();
        String schema = externalTableName.schema != null ? externalTableName.schema : connection.getSchema();
        try (ResultSet tables = databaseMetaData.getTables(catalog, schema, table, new String[]{"TABLE", "VIEW"});){
            if (!tables.next()) {
                String fullTableName = QueryUtils.quoteCompoundIdentifier(externalTableName.catalog, externalTableName.schema, externalTableName.table);
                throw new HazelcastException("Could not find table " + fullTableName);
            }
        }
    }

    private static Set<String> readPrimaryKeyColumns(ExternalJdbcTableName externalTableName, DatabaseMetaData databaseMetaData) {
        HashSet<String> pkColumns = new HashSet<String>();
        try (ResultSet resultSet = databaseMetaData.getPrimaryKeys(externalTableName.catalog, externalTableName.schema, externalTableName.table);){
            while (resultSet.next()) {
                String columnName = resultSet.getString("COLUMN_NAME");
                pkColumns.add(columnName);
            }
        }
        catch (SQLException e) {
            throw new HazelcastException("Could not read primary key columns for table " + externalTableName, (Throwable)e);
        }
        return pkColumns;
    }

    private static Map<String, DbField> readColumns(ExternalJdbcTableName externalTableName, DatabaseMetaData databaseMetaData, Set<String> pkColumns) {
        LinkedHashMap<String, DbField> fields = new LinkedHashMap<String, DbField>();
        try (ResultSet resultSet = databaseMetaData.getColumns(externalTableName.catalog, externalTableName.schema, externalTableName.table, null);){
            while (resultSet.next()) {
                String columnTypeName = resultSet.getString("TYPE_NAME");
                int precision = resultSet.getInt("COLUMN_SIZE");
                int scale = resultSet.getInt("DECIMAL_DIGITS");
                String columnName = resultSet.getString("COLUMN_NAME");
                fields.put(columnName, new DbField(columnTypeName, precision, scale, columnName, pkColumns.contains(columnName)));
            }
        }
        catch (SQLException e) {
            throw new HazelcastException("Could not read columns for table " + externalTableName, (Throwable)e);
        }
        return fields;
    }

    private void validateType(TypeResolver typeResolver, MappingField field, DbField dbField) {
        QueryDataType type = typeResolver.resolveType(dbField.columnTypeName, dbField.precision, dbField.scale);
        if (!field.type().equals(type) && !type.getConverter().canConvertTo(field.type().getTypeFamily())) {
            throw new IllegalStateException("Type " + field.type().getTypeFamily() + " of field " + field.name() + " does not match db type " + type.getTypeFamily());
        }
    }

    @Override
    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> resolvedFields) {
        String dataConnectionName = externalResource.dataConnection();
        assert (dataConnectionName != null);
        ArrayList<TableField> fields = new ArrayList<TableField>(resolvedFields.size());
        for (MappingField resolvedField : resolvedFields) {
            String fieldExternalName = resolvedField.externalName() != null ? resolvedField.externalName() : resolvedField.name();
            fields.add(new JdbcTableField(resolvedField.name(), resolvedField.type(), fieldExternalName, resolvedField.isPrimaryKey()));
        }
        return new JdbcTable(this, fields, schemaName, mappingName, externalResource, new ConstantTableStatistics(0L));
    }

    static SqlDialect resolveDialect(JdbcTable table, SqlConnector.DagBuildContext context) {
        String dataConnectionName = table.getDataConnectionName();
        JdbcDataConnection dataConnection = (JdbcDataConnection)context.getNodeEngine().getDataConnectionService().getAndRetainDataConnection(dataConnectionName, JdbcDataConnection.class);
        try {
            SqlDialect sqlDialect;
            block11: {
                Connection connection = dataConnection.getConnection();
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    SupportedDatabases.logOnceIfDatabaseNotSupported(databaseMetaData);
                    sqlDialect = JdbcSqlConnector.resolveDialect(databaseMetaData);
                    if (connection == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new HazelcastException("Could not determine dialect for data connection: " + dataConnectionName, (Throwable)e);
                    }
                }
                connection.close();
            }
            return sqlDialect;
        }
        finally {
            dataConnection.release();
        }
    }

    private static SqlDialect resolveDialect(DatabaseMetaData databaseMetaData) throws SQLException {
        switch (DatabaseDialect.resolveDialect((DatabaseMetaData)databaseMetaData)) {
            case MYSQL: {
                return new HazelcastMySqlDialect(SqlDialects.createContext(databaseMetaData));
            }
            case MICROSOFT_SQL_SERVER: {
                return new HazelcastMSSQLDialect(SqlDialects.createContext(databaseMetaData));
            }
            case POSTGRESQL: {
                return new HazelcastPostgresDialect(SqlDialects.createContext(databaseMetaData));
            }
            case ORACLE: {
                return new HazelcastOracleDialect(SqlDialects.createContext(databaseMetaData));
            }
        }
        return SqlDialectFactoryImpl.INSTANCE.create(databaseMetaData);
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig nestedLoopReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nonnull JetJoinInfo joinInfo) {
        JdbcTable jdbcTable = (JdbcTable)context.getTable();
        String namePrefix = "nestedLoopReader(" + jdbcTable.getExternalNameList() + ")";
        DAG dag = context.getDag();
        Vertex vertex = dag.newUniqueVertex(namePrefix, JdbcJoiner.createJoinProcessorSupplier(joinInfo, context, predicate, projection));
        return new SqlConnector.VertexWithInputConfig(vertex.localParallelism(1));
    }

    @Override
    @Nonnull
    public Vertex fullScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nullable List<Map<String, Expression<?>>> partitionPruningCandidates, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        if (eventTimePolicyProvider != null) {
            throw QueryException.error((String)"Ordering functions are not supported on top of JDBC mappings");
        }
        JdbcTable table = (JdbcTable)context.getTable();
        SqlDialect dialect = JdbcSqlConnector.resolveDialect(table, context);
        RexNode rexPredicate = predicate == null ? null : predicate.unwrap(RexNode.class);
        List rexProjection = Util.toList(projection, n -> n.unwrap(RexNode.class));
        SelectQueryBuilder builder = new SelectQueryBuilder((JdbcTable)context.getTable(), dialect, rexPredicate, rexProjection);
        return context.getDag().newUniqueVertex("Select(" + table.getExternalNameList() + ")", ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)new SelectProcessorSupplier(table.getDataConnectionName(), builder.query(), builder.parameterPositions(), builder.converters())));
    }

    @Override
    @Nonnull
    public SqlConnector.VertexWithInputConfig insertProcessor(@Nonnull SqlConnector.DagBuildContext context) {
        JdbcTable table = (JdbcTable)context.getTable();
        InsertQueryBuilder builder = new InsertQueryBuilder(table, JdbcSqlConnector.resolveDialect(table, context));
        return new SqlConnector.VertexWithInputConfig(context.getDag().newUniqueVertex("Insert(" + table.getExternalNameList() + ")", (ProcessorSupplier)new InsertProcessorSupplier(table.getDataConnectionName(), builder.query(), table.getBatchLimit())).localParallelism(1));
    }

    @Override
    @Nonnull
    public List<String> getPrimaryKey(Table table0) {
        JdbcTable table = (JdbcTable)table0;
        return table.getPrimaryKeyList();
    }

    @Override
    public boolean supportsExpression(@Nonnull HazelcastRexNode expression) {
        SupportsRexVisitor visitor;
        RexNode rexExpression = expression.unwrap(RexNode.class);
        Boolean supports = rexExpression.accept(visitor = new SupportsRexVisitor());
        return supports != null && supports != false;
    }

    @Override
    @Nonnull
    public Vertex updateProcessor(@Nonnull SqlConnector.DagBuildContext context, @Nonnull List<String> fieldNames, @Nonnull List<HazelcastRexNode> expressions, @Nullable HazelcastRexNode predicate, boolean hasInput) {
        assert (predicate == null || !hasInput);
        JdbcTable table = (JdbcTable)context.getTable();
        List rexExpressions = Util.toList(expressions, n -> n.unwrap(RexNode.class));
        RexNode rexPredicate = predicate == null ? null : predicate.unwrap(RexNode.class);
        UpdateQueryBuilder builder = new UpdateQueryBuilder(table, JdbcSqlConnector.resolveDialect(table, context), fieldNames, rexExpressions, rexPredicate, hasInput);
        DmlProcessorSupplier updatePS = new DmlProcessorSupplier(table.getDataConnectionName(), builder.query(), builder.dynamicParams(), builder.inputRefs(), table.getBatchLimit());
        return JdbcSqlConnector.dmlVertex(context, hasInput, table, updatePS, "Update");
    }

    @Override
    @Nonnull
    public Vertex deleteProcessor(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, boolean hasInput) {
        assert (predicate == null || !hasInput);
        JdbcTable table = (JdbcTable)context.getTable();
        RexNode rexPredicate = predicate == null ? null : predicate.unwrap(RexNode.class);
        DeleteQueryBuilder builder = new DeleteQueryBuilder(table, JdbcSqlConnector.resolveDialect(table, context), rexPredicate, hasInput);
        DmlProcessorSupplier deletePS = new DmlProcessorSupplier(table.getDataConnectionName(), builder.query(), builder.dynamicParams(), builder.inputRefs(), table.getBatchLimit());
        return JdbcSqlConnector.dmlVertex(context, hasInput, table, deletePS, "Delete");
    }

    private static Vertex dmlVertex(SqlConnector.DagBuildContext context, boolean hasInput, JdbcTable table, DmlProcessorSupplier processorSupplier, String statement) {
        if (!hasInput) {
            Address localAddress = context.getNodeEngine().getThisAddress();
            Vertex v = JdbcSqlConnector.dummySourceVertex(context, "DummySourceFor" + statement, localAddress);
            Vertex dmlVertex = context.getDag().newUniqueVertex(statement + "(" + table.getExternalNameList() + ")", ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)processorSupplier, (Address)localAddress));
            context.getDag().edge(Edge.between((Vertex)v, (Vertex)dmlVertex));
            return dmlVertex;
        }
        Vertex dmlVertex = context.getDag().newUniqueVertex(statement + "(" + table.getExternalNameList() + ")", (ProcessorSupplier)processorSupplier).localParallelism(1);
        return dmlVertex;
    }

    private static Vertex dummySourceVertex(SqlConnector.DagBuildContext context, String name, Address localAddress) {
        Vertex v = context.getDag().newUniqueVertex(name, ProcessorMetaSupplier.forceTotalParallelismOne((ProcessorSupplier)ProcessorSupplier.of((SupplierEx & Serializable)() -> new SingleItemSourceP<JetSqlRow>(DUMMY_INPUT_ROW)), (Address)localAddress));
        return v;
    }

    @Override
    @Nonnull
    public Vertex sinkProcessor(@Nonnull SqlConnector.DagBuildContext context) {
        JdbcTable jdbcTable = (JdbcTable)context.getTable();
        SqlDialect dialect = JdbcSqlConnector.resolveDialect(jdbcTable, context);
        if (SupportedDatabases.isDialectSupported(dialect)) {
            String upsertStatement = UpsertBuilder.getUpsertStatement(jdbcTable, dialect);
            return context.getDag().newUniqueVertex("sinkProcessor(" + jdbcTable.getExternalNameList() + ")", (ProcessorSupplier)new UpsertProcessorSupplier(jdbcTable.getDataConnectionName(), upsertStatement, jdbcTable.getBatchLimit())).localParallelism(1);
        }
        SqlConnector.VertexWithInputConfig vertexWithInputConfig = this.insertProcessor(context);
        return vertexWithInputConfig.vertex();
    }

    private static boolean isMySQL(DatabaseMetaData databaseMetaData) throws SQLException {
        return JdbcSqlConnector.getProductName(databaseMetaData).equals("MYSQL");
    }

    private static String getProductName(DatabaseMetaData databaseMetaData) throws SQLException {
        return databaseMetaData.getDatabaseProductName().toUpperCase(Locale.ROOT).trim();
    }

    public static BiFunctionEx<ResultSet, Integer, ?>[] prepareValueGettersFromMetadata(TypeResolver typeResolver, ResultSet rs, Function<Integer, FunctionEx<? super Object, ?>> converterFn) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        BiFunctionEx[] valueGetters = new BiFunctionEx[metaData.getColumnCount()];
        for (int j = 0; j < metaData.getColumnCount(); ++j) {
            String type = metaData.getColumnTypeName(j + 1).toUpperCase(Locale.ROOT);
            int precision = metaData.getPrecision(j + 1);
            int scale = metaData.getScale(j + 1);
            QueryDataType resolvedType = typeResolver.resolveType(type, precision, scale);
            valueGetters[j] = ((BiFunctionEx)GettersProvider.GETTERS.getOrDefault(resolvedType, (BiFunctionEx & Serializable)(resultSet, n) -> rs.getObject((int)n))).andThen(converterFn.apply(j));
        }
        return valueGetters;
    }

    private static class ExternalJdbcTableName {
        final String catalog;
        final String schema;
        final String table;

        ExternalJdbcTableName(String[] externalName, DatabaseMetaData databaseMetaData) throws SQLException {
            if (externalName.length == 1) {
                this.catalog = null;
                this.schema = null;
                this.table = externalName[0];
            } else if (externalName.length == 2) {
                if (JdbcSqlConnector.isMySQL(databaseMetaData)) {
                    this.catalog = externalName[0];
                    this.schema = null;
                } else {
                    this.catalog = null;
                    this.schema = externalName[0];
                }
                this.table = externalName[1];
            } else if (externalName.length == 3) {
                if (JdbcSqlConnector.isMySQL(databaseMetaData)) {
                    throw QueryException.error((String)("Invalid external name " + QueryUtils.quoteCompoundIdentifier(externalName) + ", external name for MySQL must have either 1 or 2 components (catalog and relation)"));
                }
                this.catalog = externalName[0];
                this.schema = externalName[1];
                this.table = externalName[2];
            } else {
                throw QueryException.error((String)"Invalid external name length");
            }
        }

        static void validateExternalName(String[] externalName) {
            if (externalName.length == 0 || externalName.length > 3) {
                throw QueryException.error((String)("Invalid external name " + QueryUtils.quoteCompoundIdentifier(externalName) + ", external name for Jdbc must have either 1, 2 or 3 components (catalog, schema and relation)"));
            }
        }
    }

    private static class DbField {
        final String columnTypeName;
        final int precision;
        final int scale;
        final String columnName;
        final boolean primaryKey;

        DbField(String columnTypeName, int precision, int scale, String columnName, boolean primaryKey) {
            this.columnTypeName = Objects.requireNonNull(columnTypeName);
            this.precision = precision;
            this.scale = scale;
            this.columnName = Objects.requireNonNull(columnName);
            this.primaryKey = primaryKey;
        }

        public String toString() {
            return "DbField{name='" + this.columnName + "', typeName='" + this.columnTypeName + "', primaryKey=" + this.primaryKey + "}";
        }
    }
}

