/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.jet.sql.impl.connector.jdbc.AbstractQueryBuilder;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.shaded.com.google.common.primitives.Ints;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlString;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SelectQueryBuilder
extends AbstractQueryBuilder {
    private final List<Integer> dynamicParams = new ArrayList<Integer>();
    private final List<FunctionEx<Object, ?>> converters = new ArrayList();

    SelectQueryBuilder(JdbcTable table, SqlDialect dialect, RexNode predicate, List<RexNode> projection) {
        super(table, dialect);
        StringBuilder sb = new StringBuilder();
        this.selectClause(sb, projection);
        this.fromClause(sb, predicate);
        this.query = sb.toString();
    }

    protected void selectClause(StringBuilder sb, List<RexNode> projection) {
        sb.append("SELECT ");
        if (!projection.isEmpty()) {
            this.appendProjection(sb, projection);
        } else {
            sb.append("*");
        }
    }

    protected void appendProjection(StringBuilder sb, List<RexNode> projection) {
        Iterator<RexNode> it = projection.iterator();
        while (it.hasNext()) {
            RexNode node = it.next();
            if (node instanceof RexInputRef) {
                RexInputRef rexInputRef = (RexInputRef)node;
                SqlIdentifier field = (SqlIdentifier)this.context.field(rexInputRef.getIndex());
                QueryDataType fieldType = this.jdbcTable.getFieldByExternalName(field.getSimple()).getType();
                this.converters.add(fieldType::convert);
            } else {
                this.converters.add(FunctionEx.identity());
            }
            SqlNode sqlNode = this.context.toSql(null, node);
            SqlString sqlString = sqlNode.toSqlString(this.dialect);
            sb.append(sqlString.toString());
            if (!it.hasNext()) continue;
            sb.append(',');
        }
    }

    protected void fromClause(StringBuilder sb, RexNode predicate) {
        sb.append(" FROM ");
        this.dialect.quoteIdentifier(sb, this.jdbcTable.getExternalNameList());
        if (predicate != null) {
            this.appendPredicate(sb, predicate, this.dynamicParams);
        }
    }

    int[] parameterPositions() {
        return Ints.toArray(this.dynamicParams);
    }

    public List<FunctionEx<Object, ?>> converters() {
        return this.converters;
    }
}

