/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.join;

import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;

public class JoinPredicatePreparedStatementSetter
implements Consumer<PreparedStatement> {
    private final JetJoinInfo joinInfo;
    private final List<JetSqlRow> leftRowsList;

    public JoinPredicatePreparedStatementSetter(JetJoinInfo joinInfo, List<JetSqlRow> leftRowsList) {
        this.joinInfo = joinInfo;
        this.leftRowsList = leftRowsList;
    }

    @Override
    public void accept(PreparedStatement preparedStatement) {
        try {
            int[] leftEquiJoinIndices = this.joinInfo.leftEquiJoinIndices();
            int parameterIndex = 1;
            for (JetSqlRow leftRow : this.leftRowsList) {
                for (int leftEquiJoinIndexValue : leftEquiJoinIndices) {
                    Object value = leftRow.get(leftEquiJoinIndexValue);
                    preparedStatement.setObject(parameterIndex++, value);
                }
            }
        }
        catch (SQLException sqlException) {
            throw ExceptionUtil.sneakyThrow((Throwable)sqlException);
        }
    }
}

