/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.mysql;

import com.hazelcast.jet.sql.impl.connector.jdbc.DefaultTypeResolver;
import com.hazelcast.jet.sql.impl.connector.jdbc.TypeResolver;
import com.hazelcast.jet.sql.impl.validate.operators.string.HazelcastConcatOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.MysqlSqlDialect;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Locale;

public class HazelcastMySqlDialect
extends MysqlSqlDialect
implements TypeResolver {
    public HazelcastMySqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case OTHER: {
                if (call.getOperator() instanceof HazelcastConcatOperator) {
                    this.unparseConcat(writer, call);
                    break;
                }
                super.unparseCall(writer, call, leftPrec, rightPrec);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }

    private void unparseConcat(SqlWriter writer, SqlCall call) {
        writer.print("CONCAT");
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.PARENTHESES, "(", ")");
        for (SqlNode operand : call.getOperandList()) {
            writer.sep(",");
            operand.unparse(writer, 0, 0);
        }
        writer.endList(frame);
    }

    @Override
    public QueryDataType resolveType(String columnTypeName, int precision, int scale) {
        return switch (columnTypeName.toUpperCase(Locale.ROOT)) {
            case "TINYTEXT", "MEDIUMTEXT", "LONGTEXT" -> QueryDataType.VARCHAR;
            case "TINYINT UNSIGNED" -> QueryDataType.SMALLINT;
            case "SMALLINT UNSIGNED", "MEDIUMINT", "MEDIUMINT UNSIGNED", "YEAR" -> QueryDataType.INT;
            case "INT UNSIGNED" -> QueryDataType.BIGINT;
            case "BIGINT UNSIGNED" -> QueryDataType.DECIMAL;
            default -> DefaultTypeResolver.resolveType(columnTypeName, precision, scale);
        };
    }
}

