/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.oracle;

import com.hazelcast.jet.sql.impl.connector.jdbc.DefaultTypeResolver;
import com.hazelcast.jet.sql.impl.connector.jdbc.TypeResolver;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlAlienSystemTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.OracleSqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Locale;

public class HazelcastOracleDialect
extends OracleSqlDialect
implements TypeResolver {
    private static final int DOUBLE_PRECISION_SCALE = 15;
    private static final int INT_PRECISION = 10;
    private static final int SMALLINT_PRECISION = 4;
    private static final int BIGINT_PRECISION = 18;
    private static final int INT_SCALE = 0;
    private static final int REAL_PRECISION_SCALE = 7;

    public HazelcastOracleDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public @Nullable SqlNode getCastSpec(RelDataType type) {
        if (type.getSqlTypeName().equals((Object)SqlTypeName.VARCHAR)) {
            return new SqlDataTypeSpec(new SqlAlienSystemTypeNameSpec("VARCHAR(128)", type.getSqlTypeName(), SqlParserPos.ZERO), SqlParserPos.ZERO);
        }
        return super.getCastSpec(type);
    }

    @Override
    public QueryDataType resolveType(String columnTypeName, int precision, int scale) {
        return switch (columnTypeName.toUpperCase(Locale.ROOT)) {
            case "NUMBER" -> HazelcastOracleDialect.resolveNumber(precision, scale);
            case "BINARY_FLOAT" -> QueryDataType.REAL;
            case "BINARY_DOUBLE" -> QueryDataType.DOUBLE;
            default -> DefaultTypeResolver.resolveType(columnTypeName, precision, scale);
        };
    }

    private static QueryDataType resolveNumber(int precision, int scale) {
        if (scale == 0) {
            if (precision <= 4) {
                return QueryDataType.SMALLINT;
            }
            if (precision < 10) {
                return QueryDataType.INT;
            }
            if (precision <= 18) {
                return QueryDataType.BIGINT;
            }
        } else {
            if (scale + precision <= 7) {
                return QueryDataType.REAL;
            }
            if (scale + precision <= 15) {
                return QueryDataType.DOUBLE;
            }
        }
        return QueryDataType.DECIMAL;
    }

    @Override
    public void setObject(PreparedStatement ps, Object obj, int j) throws SQLException {
        if (obj instanceof LocalDate) {
            LocalDate localDate = (LocalDate)obj;
            Date date = Date.valueOf(localDate);
            ps.setDate(j + 1, date);
        } else {
            TypeResolver.super.setObject(ps, obj, j);
        }
    }
}

