/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.kafka;

import com.hazelcast.dataconnection.DataConnectionService;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.kafka.impl.StreamKafkaP;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;

@SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_NO_SERIALVERSIONID"}, justification="the class is never java-serialized")
final class RowProjectorProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private Properties properties;
    private String dataConnectionName;
    private String topic;
    private FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider;
    private KvRowProjector.Supplier projectorSupplier;
    private transient ExpressionEvalContext evalContext;
    private transient EventTimePolicy<JetSqlRow> eventTimePolicy;
    private transient Extractors extractors;
    private transient DataConnectionService dataConnectionService;

    private RowProjectorProcessorSupplier() {
    }

    RowProjectorProcessorSupplier(Properties properties, String dataConnectionName, String topic, FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider, QueryPath[] paths, QueryDataType[] types, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Expression<Boolean> predicate, List<Expression<?>> projection) {
        this.properties = properties;
        this.dataConnectionName = dataConnectionName;
        this.topic = topic;
        this.eventTimePolicyProvider = eventTimePolicyProvider;
        this.projectorSupplier = KvRowProjector.supplier(paths, types, keyDescriptor, valueDescriptor, predicate, projection);
    }

    public void init(@Nonnull ProcessorSupplier.Context context) {
        this.evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)context);
        this.eventTimePolicy = this.eventTimePolicyProvider == null ? EventTimePolicy.noEventTime() : (EventTimePolicy)this.eventTimePolicyProvider.apply((Object)this.evalContext);
        this.extractors = Extractors.newBuilder((InternalSerializationService)this.evalContext.getSerializationService()).build();
        this.dataConnectionService = context.dataConnectionService();
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ArrayList<StreamKafkaP> processors = new ArrayList<StreamKafkaP>(count);
        for (int i = 0; i < count; ++i) {
            KvRowProjector projector = this.projectorSupplier.get(this.evalContext, this.extractors);
            StreamKafkaP processor = new StreamKafkaP(this.dataConnectionName == null ? StreamKafkaP.kafkaConsumerFn((Properties)this.properties) : StreamKafkaP.kafkaConsumerFn((DataConnectionRef)new DataConnectionRef(this.dataConnectionName), (Properties)this.properties), Collections.singletonList(this.topic), (FunctionEx & Serializable)record -> projector.project(record.key(), record.value()), this.eventTimePolicy);
            processors.add(processor);
        }
        return processors;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject((Object)this.properties);
        out.writeString(this.dataConnectionName);
        out.writeString(this.topic);
        out.writeObject(this.eventTimePolicyProvider);
        out.writeObject((Object)this.projectorSupplier);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.properties = (Properties)in.readObject();
        this.dataConnectionName = in.readString();
        this.topic = in.readString();
        this.eventTimePolicyProvider = (FunctionEx)in.readObject();
        this.projectorSupplier = (KvRowProjector.Supplier)in.readObject();
    }
}

