/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.file.AvroResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.extract.AvroQueryTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.AvroUpsertTarget;
import com.hazelcast.jet.sql.impl.inject.AvroUpsertTargetDescriptor;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converters;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;

public final class KvMetadataAvroResolver
implements KvMetadataResolver {
    public static final KvMetadataAvroResolver INSTANCE = new KvMetadataAvroResolver();

    private KvMetadataAvroResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.of("avro");
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(userFields, isKey);
        for (QueryPath path : fieldsByPath.keySet()) {
            if (!path.isTopLevel()) continue;
            throw QueryException.error((String)("Cannot use the '" + path + "' field with Avro serialization"));
        }
        Schema schema = KvMetadataAvroResolver.getSchema(fieldsByPath, options, isKey);
        if (schema != null && options.containsKey("schema.registry.url")) {
            throw new IllegalArgumentException("Inline schema cannot be used with schema registry");
        }
        if (userFields.isEmpty()) {
            if (schema == null) {
                throw QueryException.error((String)"Either a column list or an inline schema is required to create Avro-based mapping");
            }
            return KvMetadataAvroResolver.resolveFields(schema, (name, type) -> new MappingField((String)name, (QueryDataType)type, new QueryPath((String)name, isKey).toString()));
        }
        if (schema != null) {
            KvMetadataAvroResolver.validate(schema, KvMetadataResolver.getFields(fieldsByPath).collect(Collectors.toList()));
        }
        return fieldsByPath.values().stream();
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(resolvedFields, isKey);
        ArrayList<TableField> fields = new ArrayList<TableField>();
        for (Map.Entry<QueryPath, MappingField> entry : fieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add(new MapTableField(name, type, false, path));
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, QueryDataType.OBJECT);
        Schema schema = KvMetadataAvroResolver.getSchema(fieldsByPath, options, isKey);
        if (schema == null) {
            String recordName = options.getOrDefault(isKey ? "keyAvroRecordName" : "valueAvroRecordName", "jet.sql");
            schema = KvMetadataAvroResolver.resolveSchema(recordName, KvMetadataResolver.getFields(fieldsByPath));
        }
        return new KvMetadata(fields, AvroQueryTargetDescriptor.INSTANCE, new AvroUpsertTargetDescriptor(schema));
    }

    private static Schema resolveSchema(String recordName, Stream<KvMetadataResolver.Field> fields) {
        return (Schema)((SchemaBuilder.FieldAssembler)Util.reduce((Object)SchemaBuilder.record((String)recordName).fields(), fields, (schema, field) -> {
            switch (field.type().getTypeFamily()) {
                case BOOLEAN: {
                    return schema.optionalBoolean(field.name());
                }
                case TINYINT: 
                case SMALLINT: 
                case INTEGER: {
                    return schema.optionalInt(field.name());
                }
                case BIGINT: {
                    return schema.optionalLong(field.name());
                }
                case REAL: {
                    return schema.optionalFloat(field.name());
                }
                case DOUBLE: {
                    return schema.optionalDouble(field.name());
                }
                case DECIMAL: 
                case TIME: 
                case DATE: 
                case TIMESTAMP: 
                case TIMESTAMP_WITH_TIME_ZONE: 
                case VARCHAR: {
                    return schema.optionalString(field.name());
                }
                case OBJECT: {
                    Schema fieldSchema = field.type().isCustomType() ? KvMetadataAvroResolver.resolveSchema(field.type().getObjectTypeName(), field.type().getObjectFields().stream().map(KvMetadataResolver.Field::new)) : Schemas.OBJECT_SCHEMA;
                    return schema.name(field.name()).type(KvMetadataAvroResolver.optional(fieldSchema)).withDefault(null);
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + field.type());
        })).endRecord();
    }

    public static <T> Stream<T> resolveFields(Schema schema, BiFunction<String, QueryDataType, T> constructor) {
        return schema.getFields().stream().map(field -> {
            Schema fieldSchema = AvroResolver.unwrapNullableType(field.schema());
            if (fieldSchema.getType() == Schema.Type.RECORD) {
                throw QueryException.error((String)"Column list is required to create nested fields");
            }
            QueryDataType type = Schemas.AVRO_TO_SQL.get(fieldSchema.getType());
            if (type == null) {
                throw new IllegalArgumentException("Unsupported schema type: " + fieldSchema.getType());
            }
            return constructor.apply(field.name(), type);
        });
    }

    private static void validate(Schema schema, List<KvMetadataResolver.Field> fields) {
        if (schema.getType() != Schema.Type.RECORD) {
            throw new IllegalArgumentException("Schema must be an Avro record");
        }
        Set mappingFields = fields.stream().map(KvMetadataResolver.Field::name).collect(Collectors.toSet());
        for (Schema.Field schemaField : schema.getFields()) {
            if (schemaField.hasDefaultValue() || mappingFields.contains(schemaField.name())) continue;
            throw new IllegalArgumentException("Mandatory field '" + schemaField.name() + "' is not mapped to any column");
        }
        for (KvMetadataResolver.Field field : fields) {
            List<Schema.Type> conversions;
            String path = field.name();
            QueryDataType mappingFieldType = field.type();
            QueryDataTypeFamily mappingFieldTypeFamily = mappingFieldType.getTypeFamily();
            List<Schema.Type> list = mappingFieldTypeFamily == QueryDataTypeFamily.OBJECT ? (mappingFieldType.isCustomType() ? List.of(Schema.Type.RECORD) : List.of(Schema.Type.UNION, Schema.Type.NULL)) : (conversions = Schemas.CONVERSIONS.get((Object)mappingFieldTypeFamily));
            if (conversions == null) {
                throw new IllegalArgumentException("Unsupported type: " + mappingFieldType);
            }
            Schema.Field schemaField = schema.getField(path);
            if (schemaField == null) {
                throw new IllegalArgumentException("Field '" + path + "' does not exist in schema");
            }
            Schema fieldSchema = AvroResolver.unwrapNullableType(schemaField.schema());
            Schema.Type schemaFieldType = fieldSchema.getType();
            if (!conversions.contains(schemaFieldType)) {
                throw new IllegalArgumentException(schemaFieldType + " schema type is incompatible with " + mappingFieldType + " mapping type");
            }
            if (!mappingFieldType.isCustomType()) continue;
            KvMetadataAvroResolver.validate(fieldSchema, mappingFieldType.getObjectFields().stream().map(KvMetadataResolver.Field::new).collect(Collectors.toList()));
        }
    }

    private static Schema getSchema(Map<QueryPath, MappingField> fields, Map<String, String> options, boolean isKey) {
        return KvMetadataResolver.getMetadata(fields).map(json -> new Schema.Parser().parse(json)).orElseGet(() -> KvMetadataAvroResolver.inlineSchema(options, isKey));
    }

    public static Schema optional(Schema schema) {
        if (schema.getType() == Schema.Type.UNION) {
            return ((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL ? schema : (Schema)((SchemaBuilder.UnionAccumulator)Util.reduce((Object)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().nullType()), schema.getTypes().stream().filter(type -> type.getType() != Schema.Type.NULL), (union, type) -> (SchemaBuilder.UnionAccumulator)union.and().type(type))).endUnion();
        }
        return schema.getType() == Schema.Type.NULL ? schema : (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().nullType()).and().type(schema)).endUnion();
    }

    public static Schema inlineSchema(Map<String, String> options, boolean isKey) {
        String json = options.get(isKey ? "keyAvroSchema" : "valueAvroSchema");
        return json != null ? new Schema.Parser().parse(json) : null;
    }

    public static class Schemas {
        public static final Schema OBJECT_SCHEMA = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().nullType()).and().booleanType()).and().intType()).and().longType()).and().floatType()).and().doubleType()).and().stringType()).endUnion();
        public static final Map<Schema.Type, QueryDataType> AVRO_TO_SQL = new EnumMap<Schema.Type, QueryDataType>(Map.of(Schema.Type.BOOLEAN, QueryDataType.BOOLEAN, Schema.Type.INT, QueryDataType.INT, Schema.Type.LONG, QueryDataType.BIGINT, Schema.Type.FLOAT, QueryDataType.REAL, Schema.Type.DOUBLE, QueryDataType.DOUBLE, Schema.Type.STRING, QueryDataType.VARCHAR, Schema.Type.UNION, QueryDataType.OBJECT, Schema.Type.NULL, QueryDataType.OBJECT));
        private static final Map<QueryDataTypeFamily, List<Schema.Type>> CONVERSIONS = AvroUpsertTarget.CONVERSION_PREFS.entrySet().stream().collect(Collectors.toMap(e -> Converters.getConverter((Class)e.getKey()).getTypeFamily(), Map.Entry::getValue));
    }
}

