/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.impl.util.ReflectionUtils;
import com.hazelcast.jet.sql.impl.connector.keyvalue.JavaClassNameResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.inject.HazelcastObjectUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.PojoUpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.PrimitiveUpsertTargetDescriptor;
import com.hazelcast.sql.impl.FieldUtils;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.stream.Stream;

public final class KvMetadataJavaResolver
implements KvMetadataResolver {
    public static final KvMetadataJavaResolver INSTANCE = new KvMetadataJavaResolver();

    private KvMetadataJavaResolver() {
    }

    @Override
    public Stream<String> supportedFormats() {
        return Stream.concat(Stream.of("java"), JavaClassNameResolver.formats());
    }

    @Override
    public Stream<MappingField> resolveAndValidateFields(boolean isKey, List<MappingField> userFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(userFields, isKey);
        Class typeClass = KvMetadataResolver.getMetadata(fieldsByPath).map(KvMetadataJavaResolver::loadClass).orElseGet(() -> KvMetadataJavaResolver.loadClass(options, isKey));
        QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(typeClass);
        if (type.getTypeFamily() != QueryDataTypeFamily.OBJECT || type.isCustomType()) {
            return userFields.isEmpty() ? this.resolvePrimitiveField(isKey, type) : this.resolveAndValidatePrimitiveField(isKey, fieldsByPath, type);
        }
        return userFields.isEmpty() ? this.resolveObjectFields(isKey, typeClass) : this.resolveAndValidateObjectFields(isKey, fieldsByPath, typeClass);
    }

    private Stream<MappingField> resolvePrimitiveField(boolean isKey, QueryDataType type) {
        QueryPath path = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        String name = isKey ? QueryPath.KEY : QueryPath.VALUE;
        String externalName = path.toString();
        return Stream.of(new MappingField(name, type, externalName));
    }

    private Stream<MappingField> resolveAndValidatePrimitiveField(boolean isKey, Map<QueryPath, MappingField> fieldsByPath, QueryDataType type) {
        QueryPath path = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        String name = isKey ? QueryPath.KEY : QueryPath.VALUE;
        String externalName = path.toString();
        MappingField userField = fieldsByPath.get(path);
        if (userField != null && !userField.name().equals(name)) {
            throw QueryException.error((String)("Cannot rename field: '" + name + "'"));
        }
        if (userField != null && type.getTypeFamily() != userField.type().getTypeFamily()) {
            throw QueryException.error((String)("Mismatch between declared and resolved type for field '" + userField.name() + "'"));
        }
        for (MappingField field : fieldsByPath.values()) {
            if (externalName.equals(field.externalName())) continue;
            throw QueryException.error((String)("The field '" + externalName + "' is of type " + type.getTypeFamily() + ", you can't map '" + field.externalName() + "' too"));
        }
        return fieldsByPath.values().stream();
    }

    private Stream<MappingField> resolveObjectFields(boolean isKey, Class<?> typeClass) {
        SortedMap<String, Class<?>> classFields = FieldUtils.resolveClass(typeClass);
        if (classFields.isEmpty()) {
            String name = isKey ? QueryPath.KEY : QueryPath.VALUE;
            return Stream.of(new MappingField(name, QueryDataType.OBJECT, name));
        }
        return classFields.entrySet().stream().map(classField -> {
            QueryPath path = new QueryPath((String)classField.getKey(), isKey);
            QueryDataType type = QueryDataTypeUtils.resolveTypeForClass((Class)classField.getValue());
            String name = (String)classField.getKey();
            return new MappingField(name, type, path.toString());
        });
    }

    private Stream<MappingField> resolveAndValidateObjectFields(boolean isKey, Map<QueryPath, MappingField> fieldsByPath, Class<?> typeClass) {
        for (Map.Entry<String, Class<?>> classField : FieldUtils.resolveClass(typeClass).entrySet()) {
            QueryPath path = new QueryPath(classField.getKey(), isKey);
            QueryDataType type = QueryDataTypeUtils.resolveTypeForClass(classField.getValue());
            MappingField userField = fieldsByPath.get(path);
            if (userField == null || type.getTypeFamily() == userField.type().getTypeFamily()) continue;
            throw QueryException.error((String)("Mismatch between declared and resolved type for field '" + userField.name() + "'. Declared: " + userField.type().getTypeFamily() + ", resolved: " + type.getTypeFamily()));
        }
        return fieldsByPath.values().stream();
    }

    @Override
    public KvMetadata resolveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<String, String> options, InternalSerializationService serializationService) {
        Map<QueryPath, MappingField> fieldsByPath = KvMetadataResolver.extractFields(resolvedFields, isKey);
        Map.Entry entry = KvMetadataResolver.getTopLevelType(fieldsByPath).map(type -> Map.entry(type, KvMetadataJavaResolver.loadClass(type.getObjectTypeMetadata()))).orElseGet(() -> {
            Class<?> typeClass = KvMetadataJavaResolver.loadClass(options, isKey);
            return Map.entry(QueryDataTypeUtils.resolveTypeForClass(typeClass), typeClass);
        });
        QueryDataType type2 = (QueryDataType)entry.getKey();
        Class typeClass = (Class)entry.getValue();
        if (type2.getTypeFamily() != QueryDataTypeFamily.OBJECT || type2.isCustomType()) {
            return this.resolvePrimitiveMetadata(isKey, resolvedFields, fieldsByPath, type2);
        }
        return this.resolveObjectMetadata(isKey, resolvedFields, fieldsByPath, typeClass);
    }

    private KvMetadata resolvePrimitiveMetadata(boolean isKey, List<MappingField> resolvedFields, Map<QueryPath, MappingField> fieldsByPath, QueryDataType type) {
        ArrayList<TableField> fields = new ArrayList<TableField>();
        QueryPath path = isKey ? QueryPath.KEY_PATH : QueryPath.VALUE_PATH;
        MappingField field = fieldsByPath.get(path);
        if (field != null) {
            fields.add(new MapTableField(field.name(), field.type(), false, path));
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, type);
        return new KvMetadata(fields, GenericQueryTargetDescriptor.DEFAULT, type.isCustomType() ? HazelcastObjectUpsertTargetDescriptor.INSTANCE : PrimitiveUpsertTargetDescriptor.INSTANCE);
    }

    private KvMetadata resolveObjectMetadata(boolean isKey, List<MappingField> resolvedFields, Map<QueryPath, MappingField> fieldsByPath, Class<?> typeClass) {
        SortedMap<String, Class<?>> classFields = FieldUtils.resolveClass(typeClass);
        ArrayList<TableField> fields = new ArrayList<TableField>();
        HashMap<String, String> typeNamesByPaths = new HashMap<String, String>();
        for (Map.Entry<QueryPath, MappingField> entry : fieldsByPath.entrySet()) {
            QueryPath path = entry.getKey();
            QueryDataType type = entry.getValue().type();
            String name = entry.getValue().name();
            fields.add(new MapTableField(name, type, false, path));
            if (path.getPath() == null || classFields.get(path.getPath()) == null) continue;
            typeNamesByPaths.put(path.getPath(), ((Class)classFields.get(path.getPath())).getName());
        }
        KvMetadataResolver.maybeAddDefaultField(isKey, resolvedFields, fields, QueryDataType.OBJECT);
        return new KvMetadata(fields, GenericQueryTargetDescriptor.DEFAULT, new PojoUpsertTargetDescriptor(typeClass.getName(), typeNamesByPaths));
    }

    public static Class<?> loadClass(Map<String, String> options, boolean isKey) {
        String className;
        String formatProperty = options.get(isKey ? "keyFormat" : "valueFormat");
        String classNameProperty = isKey ? "keyJavaClass" : "valueJavaClass";
        String string = className = "java".equals(formatProperty) ? options.get(classNameProperty) : JavaClassNameResolver.resolveClassName(formatProperty);
        if (className == null) {
            throw QueryException.error((String)(classNameProperty + " is required to create Java-based mapping"));
        }
        return KvMetadataJavaResolver.loadClass(className);
    }

    public static Class<?> loadClass(String className) {
        try {
            return ReflectionUtils.loadClass((String)className);
        }
        catch (Exception e) {
            throw QueryException.error((String)("Unable to load class '" + className + "'"), (Throwable)e);
        }
    }
}

