/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.jet.sql.impl.inject.UpsertTargetDescriptor;
import com.hazelcast.jet.sql.impl.type.converter.ToConverters;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.List;

class Projector {
    private final QueryDataType[] types;
    private final UpsertTarget target;
    private final List<Expression<?>> projection;
    private final ExpressionEvalContext evalContext;
    private final UpsertInjector[] injectors;

    Projector(QueryPath[] paths, QueryDataType[] types, UpsertTarget target, List<Expression<?>> projection, ExpressionEvalContext evalContext) {
        Preconditions.checkTrue((types.length == projection.size() ? 1 : 0) != 0, (String)"paths.length != projection.length");
        this.types = types;
        this.target = target;
        this.projection = projection;
        this.evalContext = evalContext;
        this.injectors = Projector.createInjectors(paths, types, target);
    }

    private static UpsertInjector[] createInjectors(QueryPath[] paths, QueryDataType[] types, UpsertTarget target) {
        UpsertInjector[] injectors = new UpsertInjector[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            injectors[i] = target.createInjector(paths[i].getPath(), types[i]);
        }
        return injectors;
    }

    Object project(JetSqlRow values) {
        Row row = values.getRow();
        this.target.init();
        for (int i = 0; i < this.injectors.length; ++i) {
            Object projected = ExpressionUtil.evaluate(this.projection.get(i), row, this.evalContext);
            Object value = ToConverters.getToConverter(this.types[i]).convert(projected);
            this.injectors[i].set(value);
        }
        return this.target.conclude();
    }

    static Supplier supplier(QueryPath[] paths, QueryDataType[] types, UpsertTargetDescriptor descriptor, List<Expression<?>> projection) {
        return new Supplier(paths, types, descriptor, projection);
    }

    static final class Supplier
    implements DataSerializable {
        private QueryPath[] paths;
        private QueryDataType[] types;
        private UpsertTargetDescriptor descriptor;
        private List<Expression<?>> projection;

        private Supplier() {
        }

        private Supplier(QueryPath[] paths, QueryDataType[] types, UpsertTargetDescriptor descriptor, List<Expression<?>> projection) {
            this.paths = paths;
            this.types = types;
            this.descriptor = descriptor;
            this.projection = projection;
        }

        Projector get(ExpressionEvalContext evalContext) {
            return new Projector(this.paths, this.types, this.descriptor.create(evalContext), this.projection, evalContext);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.paths.length);
            for (QueryPath path : this.paths) {
                out.writeObject((Object)path);
            }
            out.writeInt(this.types.length);
            for (QueryDataType type : this.types) {
                out.writeObject((Object)type);
            }
            out.writeObject((Object)this.descriptor);
            out.writeObject(this.projection);
        }

        public void readData(ObjectDataInput in) throws IOException {
            int i;
            this.paths = new QueryPath[in.readInt()];
            for (i = 0; i < this.paths.length; ++i) {
                this.paths[i] = (QueryPath)in.readObject();
            }
            this.types = new QueryDataType[in.readInt()];
            for (i = 0; i < this.types.length; ++i) {
                this.types[i] = (QueryDataType)in.readObject();
            }
            this.descriptor = (UpsertTargetDescriptor)in.readObject();
            this.projection = (List)in.readObject();
        }
    }
}

