/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.extract;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.type.QueryDataType;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;

@NotThreadSafe
public class AvroQueryTarget
implements QueryTarget {
    private GenericRecord record;

    @Override
    public void setTarget(Object target, Data targetData) {
        assert (targetData == null);
        this.record = (GenericRecord)target;
    }

    @Override
    public QueryExtractor createExtractor(String path, QueryDataType type) {
        return path == null ? this.createExtractor() : this.createFieldExtractor(path, type);
    }

    private QueryExtractor createExtractor() {
        return () -> this.record;
    }

    private QueryExtractor createFieldExtractor(String path, QueryDataType type) {
        return () -> type.convert(AvroQueryTarget.extractValue(this.record, path));
    }

    public static Object extractValue(GenericRecord record, String path) {
        if (!record.hasField(path)) {
            return null;
        }
        Object value = record.get(path);
        if (value instanceof Utf8) {
            return ((Utf8)value).toString();
        }
        return value;
    }
}

