/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.inject;

import com.hazelcast.internal.util.collection.DefaultedMap;
import com.hazelcast.jet.sql.impl.connector.file.AvroResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataAvroResolver;
import com.hazelcast.jet.sql.impl.inject.UpsertInjector;
import com.hazelcast.jet.sql.impl.inject.UpsertTarget;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.shaded.com.google.common.collect.Sets;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.RowValue;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;

@NotThreadSafe
public class AvroUpsertTarget
implements UpsertTarget {
    public static final DefaultedMap<Class<?>, List<Schema.Type>> CONVERSION_PREFS = new DefaultedMap(ImmutableMap.builder().put(Boolean.class, List.of(Schema.Type.BOOLEAN, Schema.Type.STRING)).put(Byte.class, List.of(Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.STRING)).put(Short.class, List.of(Schema.Type.INT, Schema.Type.LONG, Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.STRING)).put(Integer.class, List.of(Schema.Type.INT, Schema.Type.LONG, Schema.Type.DOUBLE, Schema.Type.STRING, Schema.Type.FLOAT)).put(Long.class, List.of(Schema.Type.LONG, Schema.Type.INT, Schema.Type.STRING, Schema.Type.DOUBLE, Schema.Type.FLOAT)).put(Float.class, List.of(Schema.Type.FLOAT, Schema.Type.DOUBLE, Schema.Type.STRING, Schema.Type.INT, Schema.Type.LONG)).put(Double.class, List.of(Schema.Type.DOUBLE, Schema.Type.FLOAT, Schema.Type.STRING, Schema.Type.LONG, Schema.Type.INT)).put(BigDecimal.class, List.of(Schema.Type.STRING, Schema.Type.LONG, Schema.Type.DOUBLE, Schema.Type.INT, Schema.Type.FLOAT)).put(String.class, List.of(Schema.Type.STRING, Schema.Type.LONG, Schema.Type.DOUBLE, Schema.Type.INT, Schema.Type.FLOAT, Schema.Type.BOOLEAN)).put(LocalTime.class, List.of(Schema.Type.STRING)).put(LocalDate.class, List.of(Schema.Type.STRING)).put(LocalDateTime.class, List.of(Schema.Type.STRING)).put(OffsetDateTime.class, List.of(Schema.Type.STRING)).build(), List.of(Schema.Type.STRING));
    private final Schema schema;
    private GenericRecordBuilder record;

    AvroUpsertTarget(Schema schema) {
        this.schema = schema;
    }

    @Override
    public UpsertInjector createInjector(@Nullable String path, QueryDataType type) {
        if (path == null) {
            return UpsertInjector.FAILING_TOP_LEVEL_INJECTOR;
        }
        Injector injector = this.createInjector(this.schema, path, type);
        return value -> injector.set(this.record, value);
    }

    private Injector createInjector(Schema schema, String path, QueryDataType type) {
        Schema fieldSchema = AvroResolver.unwrapNullableType(schema.getField(path).schema());
        Schema.Type fieldSchemaType = fieldSchema.getType();
        switch (fieldSchemaType) {
            case BOOLEAN: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: {
                QueryDataType targetType = KvMetadataAvroResolver.Schemas.AVRO_TO_SQL.get(fieldSchemaType);
                return (record, value) -> {
                    try {
                        record.set(path, targetType.convert(value));
                    }
                    catch (QueryException e) {
                        throw QueryException.error((String)("Cannot convert " + value + " to " + fieldSchemaType + " (field=" + path + ")"));
                    }
                };
            }
            case RECORD: {
                List injectors = type.getObjectFields().stream().map(field -> this.createInjector(fieldSchema, field.getName(), field.getType())).collect(Collectors.toList());
                return (record, value) -> {
                    if (value == null) {
                        record.set(path, null);
                        return;
                    }
                    GenericRecordBuilder nestedRecord = new GenericRecordBuilder(fieldSchema);
                    for (int i = 0; i < injectors.size(); ++i) {
                        ((Injector)injectors.get(i)).set(nestedRecord, ((RowValue)value).getValues().get(i));
                    }
                    record.set(path, (Object)nestedRecord.build());
                };
            }
            case UNION: {
                Predicate<Schema.Type> hasType = fieldSchema.getTypes().stream().map(Schema::getType).collect(Sets.toImmutableEnumSet())::contains;
                DefaultedMap availableTargets = CONVERSION_PREFS.mapKeysAndValues(Function.identity(), targets -> targets.stream().filter(hasType).map(KvMetadataAvroResolver.Schemas.AVRO_TO_SQL::get).collect(Collectors.toList()));
                return (record, value) -> {
                    if (value == null) {
                        record.set(path, null);
                        return;
                    }
                    for (QueryDataType target : (List)availableTargets.getOrDefault(value.getClass())) {
                        try {
                            record.set(path, target.convert(value));
                            return;
                        }
                        catch (QueryException queryException) {
                        }
                    }
                    throw QueryException.error((String)("Not in union " + fieldSchema + ": " + value + " (" + value.getClass().getSimpleName() + ") (field=" + path + ")"));
                };
            }
            case NULL: {
                return (record, value) -> {
                    if (value != null) {
                        throw QueryException.error((String)("Cannot convert " + value + " to NULL (field=" + path + ")"));
                    }
                    record.set(path, null);
                };
            }
        }
        throw QueryException.error((String)("Schema type " + fieldSchemaType + " is unsupported (field=" + path + ")"));
    }

    @Override
    public void init() {
        this.record = new GenericRecordBuilder(this.schema);
    }

    @Override
    public Object conclude() {
        GenericData.Record record = this.record.build();
        this.record = null;
        return record;
    }

    @FunctionalInterface
    private static interface Injector {
        public void set(GenericRecordBuilder var1, Object var2);
    }
}

