/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.common;

import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.opt.Conventions;
import com.hazelcast.jet.sql.impl.opt.FullScan;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.common.ImmutableCalcIntoScanRule;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastRelOptTable;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPredicateList;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Calc;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Project;
import com.hazelcast.shaded.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgram;
import com.hazelcast.shaded.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexSimplify;
import com.hazelcast.shaded.org.apache.calcite.rex.RexUtil;
import com.hazelcast.shaded.org.apache.calcite.util.Pair;
import com.hazelcast.shaded.org.apache.calcite.util.Permutation;
import com.hazelcast.sql.impl.schema.Table;
import java.util.ArrayList;
import java.util.List;
import org.immutables.value.Value;

@Value.Enclosing
public final class CalcIntoScanRule
extends RelRule<RelRule.Config>
implements TransformationRule {
    public static final CalcIntoScanRule INSTANCE = new CalcIntoScanRule(Config.DEFAULT);

    private CalcIntoScanRule(Config config) {
        super(config);
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        FullScan scan = (FullScan)call.rel(1);
        HazelcastTable table = OptUtils.extractHazelcastTable(scan);
        Permutation permutation = Project.getPermutation(((Table)table.getTarget()).getFieldCount(), table.getProjects());
        return permutation != null && permutation.isIdentity();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Calc calc = (Calc)call.rel(0);
        FullScan scan = (FullScan)call.rel(1);
        HazelcastTable table = OptUtils.extractHazelcastTable(scan);
        Object sqlConnector = SqlConnectorUtil.getJetSqlConnector(table.getTarget());
        RexProgram calcProgram = calc.getProgram();
        assert (scan.getConvention() == Conventions.LOGICAL);
        HazelcastTable newTable = table;
        RexNode remainingFilter = null;
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        RexSimplify rexSimplify = new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, RexUtil.EXECUTOR);
        if (calcProgram.getCondition() != null) {
            RexNode calcFilter = calcProgram.expandLocalRef(calcProgram.getCondition());
            RexNode scanFilter = table.getFilter();
            ArrayList<RexNode> supportedParts = new ArrayList<RexNode>();
            ArrayList unsupportedParts = new ArrayList();
            for (RexNode rexNode : RelOptUtil.conjunctions(calcFilter)) {
                (sqlConnector.supportsExpression(HazelcastRexNode.wrap(rexNode)) ? supportedParts : unsupportedParts).add(rexNode);
            }
            supportedParts.add(scanFilter);
            RexNode simplifiedCondition = rexSimplify.simplifyFilterPredicates(supportedParts);
            if (simplifiedCondition == null) {
                simplifiedCondition = rexBuilder.makeLiteral(false);
            }
            newTable = newTable.withFilter(simplifiedCondition);
            remainingFilter = RexUtil.composeConjunction(rexBuilder, unsupportedParts, true);
        }
        List<RexNode> newProjects = calcProgram.expandList(calcProgram.getProjectList());
        boolean projectsSupported = newProjects.stream().map(HazelcastRexNode::wrap).allMatch(arg_0 -> sqlConnector.supportsExpression(arg_0));
        if (projectsSupported && remainingFilter == null) {
            newTable = newTable.withProject(newProjects, calcProgram.getOutputRowType());
            newProjects = null;
        }
        HazelcastRelOptTable convertedTable = OptUtils.createRelTable((HazelcastRelOptTable)scan.getTable(), newTable, scan.getCluster().getTypeFactory());
        FullScanLogicalRel newScan = new FullScanLogicalRel(scan.getCluster(), OptUtils.toLogicalConvention(scan.getTraitSet()), convertedTable, scan.lagExpression(), OptUtils.getTargetField(calcProgram, scan.watermarkedColumnIndex()));
        if (newProjects != null) {
            RexProgramBuilder progBuilder = new RexProgramBuilder(convertedTable.getRowType(), rexBuilder);
            for (Pair<RexNode, String> pair : Pair.zip(newProjects, calc.getRowType().getFieldNames())) {
                progBuilder.addProject((RexNode)pair.left, (String)pair.right);
            }
            if (remainingFilter != null) {
                progBuilder.addCondition(remainingFilter);
            }
            Calc calc2 = calc.copy(calc.getTraitSet(), newScan, progBuilder.getProgram());
            call.transformTo(calc2);
        } else {
            assert (remainingFilter == null);
            call.transformTo(newScan);
        }
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableCalcIntoScanRule.Config.builder().description(CalcIntoScanRule.class.getSimpleName()).operandSupplier(b0 -> b0.operand(Calc.class).trait(Conventions.LOGICAL).inputs(b1 -> b1.operand(FullScan.class).noInputs())).build();

        @Override
        default public RelOptRule toRule() {
            return new CalcIntoScanRule(this);
        }
    }
}

