/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Ord;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptPlanner;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.AbstractRelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.metadata.RelMetadataQuery;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.List;
import java.util.stream.Collectors;

public class SelectByKeyMapLogicalRel
extends AbstractRelNode
implements LogicalRel {
    private final RelOptTable table;
    private final RexNode keyCondition;
    private final List<? extends RexNode> projections;

    SelectByKeyMapLogicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelDataType rowType, RelOptTable table, RexNode keyCondition, List<? extends RexNode> projections) {
        super(cluster, traitSet);
        this.rowType = rowType;
        assert (table.unwrap(HazelcastTable.class).getTarget() instanceof PartitionedMapTable);
        this.table = table;
        this.keyCondition = keyCondition;
        this.projections = projections;
    }

    public RelOptTable table() {
        return this.table;
    }

    public RexNode keyCondition() {
        return this.keyCondition;
    }

    public List<? extends RexNode> projections() {
        return this.projections;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeZeroCost();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.item("table", this.table.getQualifiedName()).item("keyCondition", this.keyCondition).item("projections", Ord.zip(this.rowType.getFieldList()).stream().map(field -> {
            Object fieldName = ((RelDataTypeField)field.e).getName() == null ? "field#" + field.i : ((RelDataTypeField)field.e).getName();
            return (String)fieldName + "=[" + this.projections.get(field.i) + "]";
        }).collect(Collectors.joining(", ")));
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new SelectByKeyMapLogicalRel(this.getCluster(), traitSet, this.rowType, this.table, this.keyCondition, this.projections);
    }
}

