/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.jet.sql.impl.aggregate.AvgSqlAggregations;
import com.hazelcast.jet.sql.impl.aggregate.CountSqlAggregations;
import com.hazelcast.jet.sql.impl.aggregate.JsonObjectAggAggregation;
import com.hazelcast.jet.sql.impl.aggregate.MaxSqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.MinSqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.OrderedJsonArrayAggAggregation;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.SumSqlAggregations;
import com.hazelcast.jet.sql.impl.aggregate.UnorderedJsonArrayAggAggregation;
import com.hazelcast.jet.sql.impl.aggregate.ValueSqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.function.HazelcastJsonArrayAggFunction;
import com.hazelcast.jet.sql.impl.aggregate.function.HazelcastJsonObjectAggFunction;
import com.hazelcast.jet.sql.impl.opt.FieldCollation;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.shaded.org.apache.calcite.plan.RelRule;
import com.hazelcast.shaded.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.shaded.org.apache.calcite.rel.core.AggregateCall;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class AggregateAbstractPhysicalRule
extends RelRule<RelRule.Config> {
    protected AggregateAbstractPhysicalRule(RelRule.Config config) {
        super(config);
    }

    protected static AggregateOperation<?, JetSqlRow> aggregateOperation(RelDataType inputType, ImmutableBitSet groupSet, List<AggregateCall> aggregateCalls) {
        List<QueryDataType> operandTypes = OptUtils.schema(inputType).getTypes();
        ArrayList<SupplierEx<SqlAggregation>> aggregationProviders = new ArrayList<SupplierEx<SqlAggregation>>();
        ArrayList<FunctionEx<JetSqlRow, Object>> valueProviders = new ArrayList<FunctionEx<JetSqlRow, Object>>();
        for (Integer groupIndex : groupSet.toList()) {
            aggregationProviders.add(ValueSqlAggregation::new);
            valueProviders.add(new RowGetMaybeSerializedFn(groupIndex));
        }
        block10: for (AggregateCall aggregateCall : aggregateCalls) {
            boolean distinct = aggregateCall.isDistinct();
            List<Integer> aggregateCallArguments = aggregateCall.getArgList();
            SqlKind kind = aggregateCall.getAggregation().getKind();
            switch (kind) {
                case COUNT: {
                    int countIndex;
                    if (distinct) {
                        countIndex = aggregateCallArguments.get(0);
                        aggregationProviders.add(new AggregateCountSupplier(true, true));
                        valueProviders.add(new RowGetFn(countIndex));
                        continue block10;
                    }
                    if (aggregateCallArguments.size() == 1) {
                        countIndex = aggregateCallArguments.get(0);
                        aggregationProviders.add(new AggregateCountSupplier(true, false));
                        valueProviders.add(new RowGetMaybeSerializedFn(countIndex));
                        continue block10;
                    }
                    aggregationProviders.add(new AggregateCountSupplier(false, false));
                    valueProviders.add(NullFunction.INSTANCE);
                    continue block10;
                }
                case MIN: {
                    int minIndex = aggregateCallArguments.get(0);
                    aggregationProviders.add((SupplierEx<SqlAggregation>)((SupplierEx & Serializable)MinSqlAggregation::new));
                    valueProviders.add(new RowGetFn(minIndex));
                    continue block10;
                }
                case MAX: {
                    int maxIndex = aggregateCallArguments.get(0);
                    aggregationProviders.add((SupplierEx<SqlAggregation>)((SupplierEx & Serializable)MaxSqlAggregation::new));
                    valueProviders.add(new RowGetFn(maxIndex));
                    continue block10;
                }
                case SUM: {
                    int sumIndex = aggregateCallArguments.get(0);
                    QueryDataType sumOperandType = operandTypes.get(sumIndex);
                    aggregationProviders.add(new AggregateSumSupplier(distinct, sumOperandType));
                    valueProviders.add(new RowGetFn(sumIndex));
                    continue block10;
                }
                case AVG: {
                    int avgIndex = aggregateCallArguments.get(0);
                    QueryDataType avgOperandType = operandTypes.get(avgIndex);
                    aggregationProviders.add(new AggregateAvgSupplier(distinct, avgOperandType));
                    valueProviders.add(new RowGetFn(avgIndex));
                    continue block10;
                }
                case JSON_ARRAYAGG: {
                    int arrayAggIndex = aggregateCallArguments.get(0);
                    List<RelFieldCollation> colls = aggregateCall.getCollation().getFieldCollations();
                    if (colls.size() > 0) {
                        ExpressionUtil.SqlRowComparator comparator = new ExpressionUtil.SqlRowComparator(FieldCollation.convertCollation(colls));
                        HazelcastJsonArrayAggFunction agg = (HazelcastJsonArrayAggFunction)aggregateCall.getAggregation();
                        aggregationProviders.add(new AggregateArrayAggSupplier(comparator, agg.isAbsentOnNull(), arrayAggIndex));
                        valueProviders.add(new RowIdentityFn());
                        continue block10;
                    }
                    HazelcastJsonArrayAggFunction agg = (HazelcastJsonArrayAggFunction)aggregateCall.getAggregation();
                    aggregationProviders.add(new AggregateArrayAggSupplier(agg.isAbsentOnNull()));
                    valueProviders.add(new RowGetFn(arrayAggIndex));
                    continue block10;
                }
                case JSON_OBJECTAGG: {
                    int keyIndex = aggregateCallArguments.get(0);
                    int valueIndex = aggregateCallArguments.get(1);
                    HazelcastJsonObjectAggFunction objAgg = (HazelcastJsonObjectAggFunction)aggregateCall.getAggregation();
                    aggregationProviders.add(new AggregateObjectAggSupplier(keyIndex, valueIndex, objAgg.isAbsentOnNull()));
                    valueProviders.add(new RowIdentityFn());
                    continue block10;
                }
            }
            throw QueryException.error((String)("Unsupported aggregation function: " + kind));
        }
        return AggregateOperation.withCreate((SupplierEx)new AggregateCreateSupplier(aggregationProviders)).andAccumulate((BiConsumerEx)new AggregateAccumulateFunction(valueProviders)).andCombine((BiConsumerEx)AggregateCombineFunction.INSTANCE).andExport((FunctionEx)AggregateExportFunction.INSTANCE).andFinish((FunctionEx)AggregateFinishFunction.INSTANCE);
    }

    public static class RowGetMaybeSerializedFn
    implements IdentifiedDataSerializable,
    FunctionEx<JetSqlRow, Object> {
        private static final long serialVersionUID = 1L;
        private Integer groupIndex;

        public RowGetMaybeSerializedFn() {
        }

        public RowGetMaybeSerializedFn(Integer groupIndex) {
            this.groupIndex = groupIndex;
        }

        public Object applyEx(JetSqlRow row) {
            return row.getMaybeSerialized(this.groupIndex.intValue());
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.groupIndex);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.groupIndex = (Integer)in.readObject();
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 11;
        }
    }

    public static final class AggregateCountSupplier
    implements IdentifiedDataSerializable,
    SupplierEx<SqlAggregation> {
        private boolean ignoreNulls;
        private boolean distinct;

        public AggregateCountSupplier() {
        }

        public AggregateCountSupplier(boolean ignoreNulls, boolean distinct) {
            this.ignoreNulls = ignoreNulls;
            this.distinct = distinct;
        }

        public SqlAggregation getEx() {
            return CountSqlAggregations.from(this.ignoreNulls, this.distinct);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeBoolean(this.ignoreNulls);
            out.writeBoolean(this.distinct);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.ignoreNulls = in.readBoolean();
            this.distinct = in.readBoolean();
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 20;
        }
    }

    public static class RowGetFn
    implements IdentifiedDataSerializable,
    FunctionEx<JetSqlRow, Object> {
        private static final long serialVersionUID = 1L;
        private int index;

        public RowGetFn() {
        }

        public RowGetFn(Integer index) {
            this.index = index;
        }

        public Object applyEx(JetSqlRow row) {
            return row.get(this.index);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.index);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.index = in.readInt();
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 13;
        }
    }

    public static final class NullFunction
    implements IdentifiedDataSerializable,
    FunctionEx<JetSqlRow, Object> {
        public static final NullFunction INSTANCE = new NullFunction();
        private static final long serialVersionUID = 1L;

        private NullFunction() {
        }

        public Object applyEx(JetSqlRow row) {
            return null;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
        }

        public void readData(ObjectDataInput in) throws IOException {
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 12;
        }
    }

    public static class AggregateSumSupplier
    implements IdentifiedDataSerializable,
    SupplierEx<SqlAggregation> {
        private boolean distinct;
        private QueryDataType sumOperandType;

        public AggregateSumSupplier() {
        }

        public AggregateSumSupplier(boolean distinct, QueryDataType sumOperandType) {
            this.distinct = distinct;
            this.sumOperandType = sumOperandType;
        }

        public SqlAggregation getEx() {
            return SumSqlAggregations.from(this.sumOperandType, this.distinct);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeBoolean(this.distinct);
            out.writeObject((Object)this.sumOperandType);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.distinct = in.readBoolean();
            this.sumOperandType = (QueryDataType)in.readObject();
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 18;
        }
    }

    public static class AggregateAvgSupplier
    implements IdentifiedDataSerializable,
    SupplierEx<SqlAggregation> {
        private boolean distinct;
        private QueryDataType avgOperandType;

        public AggregateAvgSupplier() {
        }

        public AggregateAvgSupplier(boolean distinct, QueryDataType avgOperandType) {
            this.distinct = distinct;
            this.avgOperandType = avgOperandType;
        }

        public SqlAggregation getEx() {
            return AvgSqlAggregations.from(this.avgOperandType, this.distinct);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeBoolean(this.distinct);
            out.writeObject((Object)this.avgOperandType);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.distinct = in.readBoolean();
            this.avgOperandType = (QueryDataType)in.readObject();
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 19;
        }
    }

    public static class AggregateArrayAggSupplier
    implements IdentifiedDataSerializable,
    SupplierEx<SqlAggregation> {
        private boolean ordered;
        private ExpressionUtil.SqlRowComparator comparator;
        private boolean isAbsentOnNull;
        private int aggIndex;

        public AggregateArrayAggSupplier() {
        }

        public AggregateArrayAggSupplier(boolean isAbsentOnNull) {
            this.ordered = false;
            this.isAbsentOnNull = isAbsentOnNull;
        }

        public AggregateArrayAggSupplier(ExpressionUtil.SqlRowComparator comparator, boolean isAbsentOnNull, int aggIndex) {
            this.ordered = true;
            this.comparator = comparator;
            this.isAbsentOnNull = isAbsentOnNull;
            this.aggIndex = aggIndex;
        }

        public SqlAggregation getEx() {
            if (this.comparator == null) {
                return UnorderedJsonArrayAggAggregation.create(this.isAbsentOnNull);
            }
            return OrderedJsonArrayAggAggregation.create(this.comparator, this.isAbsentOnNull, this.aggIndex);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeBoolean(this.ordered);
            if (this.ordered) {
                out.writeObject((Object)this.comparator);
                out.writeBoolean(this.isAbsentOnNull);
                out.writeInt(this.aggIndex);
            } else {
                out.writeBoolean(this.isAbsentOnNull);
            }
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.ordered = in.readBoolean();
            if (this.ordered) {
                this.comparator = (ExpressionUtil.SqlRowComparator)in.readObject(ExpressionUtil.SqlRowComparator.class);
                this.isAbsentOnNull = in.readBoolean();
                this.aggIndex = in.readInt();
            } else {
                this.isAbsentOnNull = in.readBoolean();
            }
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 21;
        }
    }

    public static class RowIdentityFn
    implements IdentifiedDataSerializable,
    FunctionEx<JetSqlRow, Object> {
        private static final long serialVersionUID = 1L;

        public Object applyEx(JetSqlRow row) {
            return row;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
        }

        public void readData(ObjectDataInput in) throws IOException {
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 22;
        }
    }

    public static final class AggregateObjectAggSupplier
    implements IdentifiedDataSerializable,
    SupplierEx<SqlAggregation> {
        private int keyIndex;
        private int valueIndex;
        private boolean isAbsentOnNull;

        public AggregateObjectAggSupplier() {
        }

        public AggregateObjectAggSupplier(int keyIndex, int valueIndex, boolean isAbsentOnNull) {
            this.keyIndex = keyIndex;
            this.valueIndex = valueIndex;
            this.isAbsentOnNull = isAbsentOnNull;
        }

        public SqlAggregation getEx() {
            return new JsonObjectAggAggregation(this.keyIndex, this.valueIndex, this.isAbsentOnNull);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.keyIndex);
            out.writeInt(this.valueIndex);
            out.writeBoolean(this.isAbsentOnNull);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.keyIndex = in.readInt();
            this.valueIndex = in.readInt();
            this.isAbsentOnNull = in.readBoolean();
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 24;
        }
    }

    public static class AggregateCreateSupplier
    implements IdentifiedDataSerializable,
    SupplierEx<List<SqlAggregation>> {
        private List<SupplierEx<SqlAggregation>> aggregationProviders;

        public AggregateCreateSupplier() {
        }

        public AggregateCreateSupplier(List<SupplierEx<SqlAggregation>> aggregationProviders) {
            this.aggregationProviders = aggregationProviders;
        }

        public List<SqlAggregation> getEx() {
            ArrayList<SqlAggregation> aggregations = new ArrayList<SqlAggregation>(this.aggregationProviders.size());
            for (SupplierEx<SqlAggregation> aggregationProvider : this.aggregationProviders) {
                aggregations.add((SqlAggregation)aggregationProvider.get());
            }
            return aggregations;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.aggregationProviders.size());
            for (SupplierEx<SqlAggregation> aggregationProvider : this.aggregationProviders) {
                out.writeObject(aggregationProvider);
            }
        }

        public void readData(ObjectDataInput in) throws IOException {
            int aggregationProvidersSize = in.readInt();
            this.aggregationProviders = new ArrayList<SupplierEx<SqlAggregation>>(aggregationProvidersSize);
            for (int i = 0; i < aggregationProvidersSize; ++i) {
                this.aggregationProviders.add((SupplierEx<SqlAggregation>)((SupplierEx)in.readObject()));
            }
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 14;
        }
    }

    public static class AggregateAccumulateFunction
    implements IdentifiedDataSerializable,
    BiConsumerEx<List<SqlAggregation>, JetSqlRow> {
        private List<FunctionEx<JetSqlRow, Object>> valueProviders;

        public AggregateAccumulateFunction() {
        }

        public AggregateAccumulateFunction(List<FunctionEx<JetSqlRow, Object>> valueProviders) {
            this.valueProviders = valueProviders;
        }

        public void acceptEx(List<SqlAggregation> aggregations, JetSqlRow row) {
            for (int i = 0; i < aggregations.size(); ++i) {
                aggregations.get(i).accumulate(this.valueProviders.get(i).apply((Object)row));
            }
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.valueProviders.size());
            for (FunctionEx<JetSqlRow, Object> aggregationProvider : this.valueProviders) {
                out.writeObject(aggregationProvider);
            }
        }

        public void readData(ObjectDataInput in) throws IOException {
            int aggregationProvidersSize = in.readInt();
            this.valueProviders = new ArrayList<FunctionEx<JetSqlRow, Object>>(aggregationProvidersSize);
            for (int i = 0; i < aggregationProvidersSize; ++i) {
                this.valueProviders.add((FunctionEx<JetSqlRow, Object>)((FunctionEx)in.readObject()));
            }
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 15;
        }
    }

    public static final class AggregateCombineFunction
    implements IdentifiedDataSerializable,
    BiConsumerEx<List<SqlAggregation>, List<SqlAggregation>> {
        public static final AggregateCombineFunction INSTANCE = new AggregateCombineFunction();

        private AggregateCombineFunction() {
        }

        public void acceptEx(List<SqlAggregation> lefts, List<SqlAggregation> rights) {
            assert (lefts.size() == rights.size());
            for (int i = 0; i < lefts.size(); ++i) {
                lefts.get(i).combine(rights.get(i));
            }
        }

        public void writeData(ObjectDataOutput out) throws IOException {
        }

        public void readData(ObjectDataInput in) throws IOException {
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 16;
        }
    }

    public static final class AggregateExportFunction
    implements IdentifiedDataSerializable,
    FunctionEx<List<SqlAggregation>, JetSqlRow> {
        public static final AggregateExportFunction INSTANCE = new AggregateExportFunction();
        private static final long serialVersionUID = 1L;

        private AggregateExportFunction() {
        }

        public JetSqlRow applyEx(List<SqlAggregation> aggregations) {
            throw new UnsupportedOperationException("Export function should not be called");
        }

        public void writeData(ObjectDataOutput out) throws IOException {
        }

        public void readData(ObjectDataInput in) throws IOException {
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 23;
        }
    }

    public static final class AggregateFinishFunction
    implements IdentifiedDataSerializable,
    FunctionEx<List<SqlAggregation>, JetSqlRow> {
        public static final AggregateFinishFunction INSTANCE = new AggregateFinishFunction();
        private static final long serialVersionUID = 1L;

        private AggregateFinishFunction() {
        }

        public JetSqlRow applyEx(List<SqlAggregation> aggregations) {
            Object[] row = new Object[aggregations.size()];
            for (int i = 0; i < aggregations.size(); ++i) {
                row[i] = aggregations.get(i).collect();
            }
            return new JetSqlRow((SerializationService)Contexts.getCastedThreadContext().serializationService(), row);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
        }

        public void readData(ObjectDataInput in) throws IOException {
        }

        public int getFactoryId() {
            return JetSqlSerializerHook.F_ID;
        }

        public int getClassId() {
            return 17;
        }
    }
}

