/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.opt.OptUtils;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexVisitor;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeFieldTypeProvider;
import com.hazelcast.sql.impl.schema.Table;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DagBuildContextImpl
implements SqlConnector.DagBuildContext {
    private final NodeEngine nodeEngine;
    private final DAG dag;
    private final QueryParameterMetadata parameterMetadata;
    private Table table;
    private PhysicalRel rel;

    public DagBuildContextImpl(NodeEngine nodeEngine, DAG dag, QueryParameterMetadata parameterMetadata) {
        this.nodeEngine = Objects.requireNonNull(nodeEngine);
        this.dag = Objects.requireNonNull(dag);
        this.parameterMetadata = parameterMetadata;
    }

    @Override
    @Nonnull
    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    @Override
    @Nonnull
    public DAG getDag() {
        return this.dag;
    }

    @Nonnull
    public Table getTable() {
        if (this.table == null) {
            throw new IllegalStateException("table not available");
        }
        return this.table;
    }

    public PhysicalRel getRel() {
        return this.rel;
    }

    public void setRel(@Nullable PhysicalRel rel) {
        this.rel = rel;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    @Nullable
    public Expression<Boolean> convertFilter(@Nullable HazelcastRexNode node) {
        if (node == null) {
            return null;
        }
        return node.unwrap(RexNode.class).accept(this.createVisitor());
    }

    @Override
    @Nonnull
    public List<Expression<?>> convertProjection(@Nonnull List<HazelcastRexNode> nodes) {
        RexVisitor<Expression<?>> visitor = this.createVisitor();
        return Util.toList(nodes, node -> (Expression)node.unwrap(RexNode.class).accept(visitor));
    }

    @Nonnull
    private RexVisitor<Expression<?>> createVisitor() {
        PlanNodeFieldTypeProvider schema = this.table != null ? OptUtils.schema(this.table) : (this.rel.getInputs().size() != 1 ? PlanNodeFieldTypeProvider.FAILING_FIELD_TYPE_PROVIDER : ((PhysicalRel)this.rel.getInput(0)).schema(this.parameterMetadata));
        return OptUtils.createRexToExpressionVisitor(schema, this.parameterMetadata);
    }

    public QueryParameterMetadata getParameterMetadata() {
        return this.parameterMetadata;
    }
}

