/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.MutableInteger;
import com.hazelcast.internal.util.collection.Object2LongHashMap;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.Traversers;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.BroadcastKey;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.Watermark;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.impl.JetServiceBackend;
import com.hazelcast.jet.impl.memory.AccumulationLimitExceededException;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.ObjectArrayKey;
import com.hazelcast.jet.sql.impl.processors.StreamToStreamJoinBuffer;
import com.hazelcast.jet.sql.impl.processors.StreamToStreamJoinHeapBuffer;
import com.hazelcast.jet.sql.impl.processors.StreamToStreamJoinListBuffer;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.shaded.com.google.common.collect.Streams;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class StreamToStreamJoinP
extends AbstractProcessor {
    private static final long OBJECT_2_LONG_MAP_MIN_VALUE = -9223372036854775807L;
    final Object2LongHashMap<Byte> wmState = new Object2LongHashMap(Long.MIN_VALUE);
    final Object2LongHashMap<Byte> lastReceivedWm = new Object2LongHashMap(Long.MIN_VALUE);
    final Object2LongHashMap<Byte> lastEmittedWm = new Object2LongHashMap(Long.MIN_VALUE);
    final StreamToStreamJoinBuffer[] buffer;
    private int[] processorPartitionKeys;
    private final JetJoinInfo joinInfo;
    private final int outerJoinSide;
    private final List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> leftTimeExtractors;
    private final List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> rightTimeExtractors;
    private final Map<Byte, Map<Byte, Long>> postponeTimeMap;
    private final Tuple2<Integer, Integer> columnCounts;
    private long maxProcessorAccumulatedRecords;
    private ExpressionEvalContext evalContext;
    private ProcessingGuarantee processingGuarantee;
    private int processorIndex;
    private Iterator<JetSqlRow> iterator;
    private JetSqlRow currItem;
    private final Set<JetSqlRow> unusedEventsTracker = Collections.newSetFromMap(new IdentityHashMap());
    private final Queue<Object> pendingOutput = new ArrayDeque<Object>();
    private JetSqlRow emptyLeftRow;
    private JetSqlRow emptyRightRow;
    private Traverser<Map.Entry<?, ?>> snapshotTraverser;

    public StreamToStreamJoinP(JetJoinInfo joinInfo, Map<Byte, ToLongFunctionEx<JetSqlRow>> leftTimeExtractors, Map<Byte, ToLongFunctionEx<JetSqlRow>> rightTimeExtractors, Map<Byte, Map<Byte, Long>> postponeTimeMap, Tuple2<Integer, Integer> columnCounts) {
        this.joinInfo = joinInfo;
        this.leftTimeExtractors = new ArrayList<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>>(leftTimeExtractors.entrySet());
        this.rightTimeExtractors = new ArrayList<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>>(rightTimeExtractors.entrySet());
        this.postponeTimeMap = postponeTimeMap;
        this.columnCounts = columnCounts;
        switch (joinInfo.getJoinType()) {
            case INNER: {
                this.outerJoinSide = -1;
                break;
            }
            case LEFT: {
                this.outerJoinSide = 0;
                break;
            }
            case RIGHT: {
                this.outerJoinSide = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported join type: " + joinInfo.getJoinType());
            }
        }
        for (Byte wmKey : postponeTimeMap.keySet()) {
            this.wmState.put((Object)wmKey, -9223372036854775807L);
            this.lastEmittedWm.put((Object)wmKey, -9223372036854775807L);
            this.lastReceivedWm.put((Object)wmKey, -9223372036854775807L);
        }
        if (!Collections.disjoint(leftTimeExtractors.keySet(), rightTimeExtractors.keySet())) {
            throw new IllegalArgumentException("Some watermark key is found on both inputs. Left=" + leftTimeExtractors.keySet() + ", right=" + rightTimeExtractors.keySet());
        }
        boolean[] found = new boolean[2];
        for (Map.Entry<Byte, Map<Byte, Long>> outerEntry : postponeTimeMap.entrySet()) {
            for (Byte innerKey : outerEntry.getValue().keySet()) {
                boolean outerOrdinal;
                int innerOrdinal = leftTimeExtractors.containsKey(innerKey) ? 0 : 1;
                if (innerOrdinal == (outerOrdinal = !leftTimeExtractors.containsKey(outerEntry.getKey()))) continue;
                found[innerOrdinal] = true;
            }
        }
        if (!found[0] || !found[1]) {
            throw new IllegalArgumentException("Not enough time bounds in postponeTimeMap");
        }
        this.buffer = this.createBuffers();
    }

    protected void init(@Nonnull Processor.Context context) throws Exception {
        this.evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)context);
        InternalSerializationService ss = this.evalContext.getSerializationService();
        this.emptyLeftRow = new JetSqlRow((SerializationService)ss, new Object[((Integer)this.columnCounts.f0()).intValue()]);
        this.emptyRightRow = new JetSqlRow((SerializationService)ss, new Object[((Integer)this.columnCounts.f1()).intValue()]);
        this.maxProcessorAccumulatedRecords = context.maxProcessorAccumulatedRecords();
        this.processingGuarantee = context.processingGuarantee();
        this.processorIndex = context.globalProcessorIndex();
        if (!this.joinInfo.isEquiJoin()) {
            JetServiceBackend jsb = (JetServiceBackend)com.hazelcast.jet.impl.util.Util.getNodeEngine((HazelcastInstance)context.hazelcastInstance()).getService("hz:impl:jetService");
            int[] processorPartitionIds = context.processorPartitions();
            int[] partitionKeys = jsb.getSharedPartitionKeys();
            this.processorPartitionKeys = new int[processorPartitionIds.length];
            for (int i = 0; i < this.processorPartitionKeys.length; ++i) {
                this.processorPartitionKeys[i] = partitionKeys[processorPartitionIds[i]];
            }
        }
    }

    public boolean tryProcess(int ordinal, @Nonnull Object item) {
        JetSqlRow joinedRow;
        assert (ordinal == 0 || ordinal == 1);
        if (!this.processPendingOutput()) {
            return false;
        }
        if ((long)(this.buffer[0].size() + this.buffer[1].size()) >= this.maxProcessorAccumulatedRecords) {
            throw new AccumulationLimitExceededException();
        }
        boolean avoidBuffer = false;
        if (this.currItem == null) {
            int i;
            List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> extractors = this.timeExtractors(ordinal);
            long[] times = new long[extractors.size()];
            for (i = 0; i < extractors.size(); ++i) {
                long wmValue = this.lastReceivedWm.getValue((Object)extractors.get(i).getKey());
                times[i] = extractors.get(i).getValue().applyAsLong((Object)((JetSqlRow)item));
                if (times[i] >= wmValue) continue;
                com.hazelcast.jet.impl.util.Util.logLateEvent((ILogger)this.getLogger(), (byte)extractors.get(i).getKey(), (long)wmValue, (Object)item);
                return true;
            }
            for (i = 0; i < extractors.size(); ++i) {
                long time = times[i];
                long joinTimeLimit = this.wmState.get((Object)extractors.get(i).getKey());
                avoidBuffer |= time < joinTimeLimit;
            }
            this.currItem = (JetSqlRow)item;
            if (!avoidBuffer) {
                this.buffer[ordinal].add(this.currItem);
            }
            this.iterator = this.buffer[1 - ordinal].iterator();
            if (ordinal == this.outerJoinSide) {
                this.unusedEventsTracker.add(this.currItem);
            }
        }
        while (this.iterator.hasNext()) {
            JetSqlRow oppositeBufferItem = this.iterator.next();
            JetSqlRow preparedOutput = ExpressionUtil.join(ordinal == 0 ? this.currItem : oppositeBufferItem, ordinal == 0 ? oppositeBufferItem : this.currItem, this.joinInfo.condition(), this.evalContext);
            if (preparedOutput == null) continue;
            if (ordinal == this.outerJoinSide) {
                this.unusedEventsTracker.remove(this.currItem);
            } else if (ordinal == 1 - this.outerJoinSide) {
                this.unusedEventsTracker.remove(oppositeBufferItem);
            }
            if (this.tryEmit(preparedOutput)) continue;
            this.pendingOutput.add(preparedOutput);
            return false;
        }
        if (avoidBuffer && !this.joinInfo.isInner() && this.unusedEventsTracker.remove(this.currItem) && (joinedRow = this.composeRowWithNulls(this.currItem, ordinal)) != null && !this.tryEmit(joinedRow)) {
            this.pendingOutput.add(joinedRow);
            return false;
        }
        this.iterator = null;
        this.currItem = null;
        return true;
    }

    public boolean tryProcessWatermark(int ordinal, @Nonnull Watermark watermark) {
        if (!this.pendingOutput.isEmpty()) {
            return this.processPendingOutput();
        }
        Byte receivedWmKey = watermark.key();
        assert (this.wmState.containsKey((Object)receivedWmKey)) : "unexpected watermark key: " + receivedWmKey;
        assert (this.processingGuarantee != ProcessingGuarantee.EXACTLY_ONCE || this.lastReceivedWm.get((Object)receivedWmKey) < watermark.timestamp()) : "non-monotonic watermark: " + watermark.timestamp() + " when state is " + this.lastReceivedWm.get((Object)receivedWmKey);
        this.lastReceivedWm.put((Object)receivedWmKey, watermark.timestamp());
        boolean modified = this.applyToWmState(watermark);
        if (modified) {
            this.clearExpiredItemsInBuffer(0);
            this.clearExpiredItemsInBuffer(1);
        }
        for (Byte wmKey : this.wmState.keySet()) {
            long lastReceivedWatermark = this.lastReceivedWm.getValue((Object)wmKey);
            long newWm = Math.min(this.wmState.get((Object)wmKey), lastReceivedWatermark);
            if (newWm <= this.lastEmittedWm.getValue((Object)wmKey)) continue;
            this.pendingOutput.add(new Watermark(newWm, wmKey.byteValue()));
            this.lastEmittedWm.put((Object)wmKey, newWm);
        }
        return this.processPendingOutput();
    }

    public boolean tryProcessWatermark(@Nonnull Watermark watermark) {
        return true;
    }

    public boolean saveToSnapshot() {
        if (this.snapshotTraverser == null) {
            Stream<Object> rightBufferStream;
            Stream leftBufferStream;
            Long timestamp;
            ArrayList<Map.Entry> snapshotList = new ArrayList<Map.Entry>();
            for (Map.Entry e : this.wmState.entrySet()) {
                timestamp = (Long)e.getValue();
                if (timestamp == -9223372036854775807L) continue;
                snapshotList.add(Util.entry((Object)BroadcastKey.broadcastKey((Object)((Object)StreamToStreamJoinBroadcastKeys.WM_STATE_KEY)), (Object)new WatermarkStateValue((Byte)e.getKey(), timestamp)));
            }
            for (Map.Entry e : this.lastReceivedWm.entrySet()) {
                timestamp = (Long)e.getValue();
                if (timestamp == -9223372036854775807L) continue;
                snapshotList.add(Util.entry((Object)BroadcastKey.broadcastKey((Object)((Object)StreamToStreamJoinBroadcastKeys.LAST_RECEIVED_WM_KEY)), (Object)new WatermarkStateValue((Byte)e.getKey(), timestamp)));
            }
            if (this.joinInfo.isEquiJoin()) {
                leftBufferStream = this.buffer[0].content().stream().map(row -> Util.entry((Object)ObjectArrayKey.project(row, this.joinInfo.leftEquiJoinIndices()), (Object)new BufferSnapshotValue((JetSqlRow)row, this.unusedEventsTracker.contains(row), 0)));
                rightBufferStream = this.buffer[1].content().stream().map(row -> Util.entry((Object)ObjectArrayKey.project(row, this.joinInfo.rightEquiJoinIndices()), (Object)new BufferSnapshotValue((JetSqlRow)row, this.unusedEventsTracker.contains(row), 1)));
            } else {
                MutableInteger keyIndex = new MutableInteger();
                if (this.joinInfo.isRightOuter()) {
                    leftBufferStream = this.processorIndex == 0 ? Streams.mapWithIndex(this.buffer[0].content().stream(), (row, index) -> Util.entry((Object)BroadcastKey.broadcastKey((Object)index), (Object)new BufferSnapshotValue((JetSqlRow)row, this.unusedEventsTracker.contains(row), 0))) : Stream.empty();
                    rightBufferStream = this.buffer[1].content().stream().map(row -> Util.entry((Object)this.processorPartitionKeys[StreamToStreamJoinP.cycle(keyIndex, this.processorPartitionKeys.length)], (Object)new BufferSnapshotValue((JetSqlRow)row, this.unusedEventsTracker.contains(row), 1)));
                } else {
                    rightBufferStream = this.processorIndex == 0 ? Streams.mapWithIndex(this.buffer[1].content().stream(), (row, index) -> Util.entry((Object)BroadcastKey.broadcastKey((Object)index), (Object)new BufferSnapshotValue((JetSqlRow)row, this.unusedEventsTracker.contains(row), 1))) : Stream.empty();
                    leftBufferStream = this.buffer[0].content().stream().map(row -> Util.entry((Object)this.processorPartitionKeys[StreamToStreamJoinP.cycle(keyIndex, this.processorPartitionKeys.length)], (Object)new BufferSnapshotValue((JetSqlRow)row, this.unusedEventsTracker.contains(row), 0)));
                }
            }
            this.snapshotTraverser = Traversers.traverseStream(Stream.of(snapshotList.stream(), leftBufferStream, rightBufferStream).flatMap(Function.identity())).onFirstNull(() -> {
                this.snapshotTraverser = null;
            });
        }
        return this.emitFromTraverserToSnapshot(this.snapshotTraverser);
    }

    public boolean isCooperative() {
        return this.joinInfo.isCooperative();
    }

    private static int cycle(MutableInteger val, int max) {
        ++val.value;
        if (val.value == max) {
            val.value = 0;
        }
        return val.value;
    }

    protected void restoreFromSnapshot(@Nonnull Object key, @Nonnull Object value) {
        if (value instanceof BufferSnapshotValue) {
            BufferSnapshotValue bsv = (BufferSnapshotValue)value;
            this.buffer[bsv.bufferOrdinal()].add(bsv.row());
            if (bsv.unused()) {
                this.unusedEventsTracker.add(bsv.row());
            }
            return;
        }
        if (key instanceof BroadcastKey) {
            BroadcastKey broadcastKey = (BroadcastKey)key;
            WatermarkStateValue wmValue = (WatermarkStateValue)value;
            if (StreamToStreamJoinBroadcastKeys.WM_STATE_KEY.equals(broadcastKey.key())) {
                boolean shouldUpdateReceived;
                Long stateWm = this.wmState.get((Object)wmValue.key());
                boolean bl = shouldUpdateReceived = stateWm <= -9223372036854775807L || stateWm > wmValue.timestamp();
                if (shouldUpdateReceived) {
                    this.wmState.put((Object)wmValue.key(), wmValue.timestamp());
                }
            } else if (StreamToStreamJoinBroadcastKeys.LAST_RECEIVED_WM_KEY.equals(broadcastKey.key())) {
                boolean shouldUpdateReceived;
                Long stateWm = this.lastReceivedWm.get((Object)wmValue.key());
                boolean bl = shouldUpdateReceived = stateWm <= -9223372036854775807L || stateWm > wmValue.timestamp();
                if (shouldUpdateReceived) {
                    this.lastReceivedWm.put((Object)wmValue.key(), wmValue.timestamp());
                }
            } else {
                throw new JetException("Unexpected broadcast key: " + broadcastKey.key());
            }
        }
    }

    public boolean closeIsCooperative() {
        return true;
    }

    private boolean processPendingOutput() {
        while (!this.pendingOutput.isEmpty()) {
            if (!this.tryEmit(this.pendingOutput.peek())) {
                return false;
            }
            this.pendingOutput.remove();
        }
        return true;
    }

    private boolean applyToWmState(Watermark watermark) {
        boolean modified = false;
        Byte inputWmKey = watermark.key();
        Map<Byte, Long> wmKeyMapping = this.postponeTimeMap.get(inputWmKey);
        for (Map.Entry<Byte, Long> entry : wmKeyMapping.entrySet()) {
            Long newLimit = watermark.timestamp() - entry.getValue();
            Long oldLimit = this.wmState.get((Object)entry.getKey());
            if (newLimit <= oldLimit) continue;
            this.wmState.put((Object)entry.getKey(), newLimit);
            modified = true;
        }
        return modified;
    }

    private void clearExpiredItemsInBuffer(int ordinal) {
        List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> extractors = this.timeExtractors(ordinal);
        long[] limits = new long[extractors.size()];
        for (int i = 0; i < extractors.size(); ++i) {
            limits[i] = (Long)this.wmState.getOrDefault((Object)extractors.get(i).getKey(), (Object)Long.MIN_VALUE);
        }
        this.buffer[ordinal].clearExpiredItems(limits, row -> {
            JetSqlRow joinedRow;
            if (this.outerJoinSide == ordinal && this.unusedEventsTracker.remove(row) && (joinedRow = this.composeRowWithNulls((JetSqlRow)row, ordinal)) != null) {
                this.pendingOutput.add(joinedRow);
            }
        });
    }

    private List<Map.Entry<Byte, ToLongFunctionEx<JetSqlRow>>> timeExtractors(int ordinal) {
        return ordinal == 0 ? this.leftTimeExtractors : this.rightTimeExtractors;
    }

    private JetSqlRow composeRowWithNulls(JetSqlRow row, int ordinal) {
        JetSqlRow joinedRow = null;
        if (ordinal == 1 && this.joinInfo.isRightOuter()) {
            joinedRow = ExpressionUtil.join(this.emptyLeftRow, row, ConstantExpression.TRUE, this.evalContext);
        } else if (ordinal == 0 && this.joinInfo.isLeftOuter()) {
            joinedRow = ExpressionUtil.join(row, this.emptyRightRow, ConstantExpression.TRUE, this.evalContext);
        }
        return joinedRow;
    }

    private StreamToStreamJoinBuffer[] createBuffers() {
        return new StreamToStreamJoinBuffer[]{this.leftTimeExtractors.size() == 1 ? new StreamToStreamJoinHeapBuffer(this.leftTimeExtractors) : new StreamToStreamJoinListBuffer(this.leftTimeExtractors), this.rightTimeExtractors.size() == 1 ? new StreamToStreamJoinHeapBuffer(this.rightTimeExtractors) : new StreamToStreamJoinListBuffer(this.rightTimeExtractors)};
    }

    static enum StreamToStreamJoinBroadcastKeys {
        WM_STATE_KEY,
        LAST_RECEIVED_WM_KEY;

    }

    private static final class WatermarkStateValue
    implements DataSerializable {
        private Byte key;
        private Long timestamp;

        WatermarkStateValue() {
        }

        private WatermarkStateValue(Byte key, Long timestamp) {
            this.key = key;
            this.timestamp = timestamp;
        }

        public Byte key() {
            return this.key;
        }

        public Long timestamp() {
            return this.timestamp;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeByte((int)this.key.byteValue());
            out.writeLong(this.timestamp.longValue());
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.key = in.readByte();
            this.timestamp = in.readLong();
        }

        public String toString() {
            return "WatermarkValue{key=" + this.key + ", timestamp=" + this.timestamp + "}";
        }
    }

    private static final class BufferSnapshotValue
    implements DataSerializable {
        private JetSqlRow row;
        private boolean unused;
        private int bufferOrdinal;

        BufferSnapshotValue() {
        }

        private BufferSnapshotValue(JetSqlRow row, boolean unused, int bufferOrdinal) {
            this.row = row;
            this.unused = unused;
            this.bufferOrdinal = bufferOrdinal;
        }

        public JetSqlRow row() {
            return this.row;
        }

        public int bufferOrdinal() {
            return this.bufferOrdinal;
        }

        public boolean unused() {
            return this.unused;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.bufferOrdinal);
            out.writeBoolean(this.unused);
            out.writeObject((Object)this.row);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.bufferOrdinal = in.readInt();
            this.unused = in.readBoolean();
            this.row = (JetSqlRow)in.readObject(JetSqlRow.class);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BufferSnapshotValue that = (BufferSnapshotValue)o;
            return this.unused == that.unused && this.bufferOrdinal == that.bufferOrdinal && this.row.equals((Object)that.row);
        }

        public int hashCode() {
            return Objects.hash(this.row, this.unused, this.bufferOrdinal);
        }

        public String toString() {
            return "BufferSnapshotValue{row=" + this.row.get(0) + ", unused=" + this.unused + ", isLeftBuffer=" + this.bufferOrdinal + "}";
        }
    }

    public static final class StreamToStreamJoinProcessorSupplier
    implements ProcessorSupplier,
    DataSerializable {
        private JetJoinInfo joinInfo;
        private Map<Byte, ToLongFunctionEx<JetSqlRow>> leftTimeExtractors;
        private Map<Byte, ToLongFunctionEx<JetSqlRow>> rightTimeExtractors;
        private Map<Byte, Map<Byte, Long>> postponeTimeMap;
        private int leftInputColumnCount;
        private int rightInputColumnCount;

        private StreamToStreamJoinProcessorSupplier() {
        }

        public StreamToStreamJoinProcessorSupplier(JetJoinInfo joinInfo, Map<Byte, ToLongFunctionEx<JetSqlRow>> leftTimeExtractors, Map<Byte, ToLongFunctionEx<JetSqlRow>> rightTimeExtractors, Map<Byte, Map<Byte, Long>> postponeTimeMap, int leftInputColumnCount, int rightInputColumnCount) {
            this.joinInfo = joinInfo;
            this.leftTimeExtractors = leftTimeExtractors;
            this.rightTimeExtractors = rightTimeExtractors;
            this.postponeTimeMap = postponeTimeMap;
            this.leftInputColumnCount = leftInputColumnCount;
            this.rightInputColumnCount = rightInputColumnCount;
        }

        @Nonnull
        public Collection<? extends Processor> get(int count) {
            ArrayList<StreamToStreamJoinP> processors = new ArrayList<StreamToStreamJoinP>(count);
            for (int i = 0; i < count; ++i) {
                processors.add(new StreamToStreamJoinP(this.joinInfo, this.leftTimeExtractors, this.rightTimeExtractors, this.postponeTimeMap, (Tuple2<Integer, Integer>)Tuple2.tuple2((Object)this.leftInputColumnCount, (Object)this.rightInputColumnCount)));
            }
            return processors;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.joinInfo);
            SerializationUtil.writeMap(this.leftTimeExtractors, (ObjectDataOutput)out);
            SerializationUtil.writeMap(this.rightTimeExtractors, (ObjectDataOutput)out);
            SerializationUtil.writeMap(this.postponeTimeMap, (ObjectDataOutput)out);
            out.writeInt(this.leftInputColumnCount);
            out.writeInt(this.rightInputColumnCount);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.joinInfo = (JetJoinInfo)in.readObject();
            this.leftTimeExtractors = SerializationUtil.readMap((ObjectDataInput)in);
            this.rightTimeExtractors = SerializationUtil.readMap((ObjectDataInput)in);
            this.postponeTimeMap = SerializationUtil.readMap((ObjectDataInput)in);
            this.leftInputColumnCount = in.readInt();
            this.rightInputColumnCount = in.readInt();
        }
    }
}

