/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type.converter;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;

public abstract class ToConverter {
    private final Class<?> normalizedValueClass;

    protected ToConverter(QueryDataType type) {
        this.normalizedValueClass = type.getConverter().getNormalizedValueClass();
    }

    public Object convert(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (!this.normalizedValueClass.isAssignableFrom(valueClass)) {
            throw QueryException.dataException((String)("Type mismatch [expectedClass=" + this.normalizedValueClass.getName() + ", actualClass=" + valueClass.getName() + "]"));
        }
        return this.from(value);
    }

    protected abstract Object from(Object var1);
}

