/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.jet.sql.impl.connector.SqlConnectorUtil;
import com.hazelcast.jet.sql.impl.connector.virtual.ViewTable;
import com.hazelcast.jet.sql.impl.parse.SqlAnalyzeStatement;
import com.hazelcast.jet.sql.impl.parse.SqlCreateMapping;
import com.hazelcast.jet.sql.impl.parse.SqlExplainStatement;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.HazelcastDynamicTableFunction;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlConformance;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.ValidatorResource;
import com.hazelcast.jet.sql.impl.validate.literal.LiteralUtils;
import com.hazelcast.jet.sql.impl.validate.operators.misc.HazelcastCastFunction;
import com.hazelcast.jet.sql.impl.validate.param.AbstractParameterConverter;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastObjectType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeCoercion;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.shaded.org.apache.calcite.runtime.CalciteContextException;
import com.hazelcast.shaded.org.apache.calcite.runtime.ResourceUtil;
import com.hazelcast.shaded.org.apache.calcite.runtime.Resources;
import com.hazelcast.shaded.org.apache.calcite.sql.JoinType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlBasicCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDelete;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDynamicParam;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlInsert;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJoin;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUpdate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlShuttle;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SelectScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlQualified;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorException;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorImplBridge;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorTable;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorUtil;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.sql.impl.ParameterConverter;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.schema.IMapResolver;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.security.Permission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class HazelcastSqlValidator
extends SqlValidatorImplBridge {
    private static final String OBJECT_NOT_FOUND = ResourceUtil.key(Static.RESOURCE.objectNotFound(""));
    private static final String OBJECT_NOT_FOUND_WITHIN = ResourceUtil.key(Static.RESOURCE.objectNotFoundWithin("", ""));
    private static final SqlValidator.Config CONFIG = SqlValidator.Config.DEFAULT.withIdentifierExpansion(true).withSqlConformance(HazelcastSqlConformance.INSTANCE).withTypeCoercionFactory(HazelcastTypeCoercion::new);
    private final HazelcastSqlOperatorTable.RewriteVisitor rewriteVisitor;
    private final TableOperatorWrapper tableOperatorWrapper;
    private final Map<Integer, ParameterConverter> parameterConverterMap = new HashMap<Integer, ParameterConverter>();
    private final Map<Integer, SqlParserPos> parameterPositionMap = new HashMap<Integer, SqlParserPos>();
    private final List<Object> arguments;
    private final IMapResolver iMapResolver;
    private final SqlSecurityContext ssc;

    public HazelcastSqlValidator(SqlValidatorCatalogReader catalogReader, List<Object> arguments, IMapResolver iMapResolver, SqlSecurityContext ssc) {
        super(HazelcastSqlOperatorTable.instance(), catalogReader, HazelcastTypeFactory.INSTANCE, CONFIG);
        this.rewriteVisitor = new HazelcastSqlOperatorTable.RewriteVisitor(this);
        this.tableOperatorWrapper = new TableOperatorWrapper();
        this.arguments = arguments;
        this.iMapResolver = iMapResolver;
        this.ssc = ssc;
    }

    @Override
    public SqlNode validate(SqlNode topNode) {
        if (topNode.getKind().belongsTo(SqlKind.DDL)) {
            topNode.validate(this, this.getEmptyScope());
            return topNode;
        }
        if (topNode instanceof SqlShowStatement) {
            return topNode;
        }
        if (topNode instanceof SqlExplainStatement) {
            SqlExplainStatement explainStatement = (SqlExplainStatement)topNode;
            SqlNode explicandum = explainStatement.getExplicandum();
            explicandum = super.validate(explicandum);
            explainStatement.setExplicandum(explicandum);
            return explainStatement;
        }
        if (topNode instanceof SqlAnalyzeStatement) {
            SqlAnalyzeStatement analyzeStatement = (SqlAnalyzeStatement)topNode;
            analyzeStatement.validate(this);
            SqlNode query = analyzeStatement.getQuery();
            query = super.validate(query);
            analyzeStatement.setQuery(query);
            return analyzeStatement;
        }
        return super.validate(topNode);
    }

    @Override
    public void validateQuery(SqlNode node, SqlValidatorScope scope, RelDataType targetRowType) {
        super.validateQuery(node, scope, targetRowType);
        if (node instanceof SqlSelect) {
            this.validateSelect((SqlSelect)node, scope);
        }
    }

    @Override
    public void validateInsert(SqlInsert insert) {
        super.validateInsert(insert);
        this.validateUpsertRowType((SqlIdentifier)insert.getTargetTable());
    }

    @Override
    public void validateColumnListParams(SqlFunction function, List<RelDataType> argTypes, List<SqlNode> operands) {
        if (!(function instanceof HazelcastCastFunction)) {
            super.validateColumnListParams(function, argTypes, operands);
        }
        if (!argTypes.get(0).getSqlTypeName().equals((Object)SqlTypeName.COLUMN_LIST)) {
            throw QueryException.error((String)("Cannot convert " + argTypes.get(0).getSqlTypeName() + " to " + argTypes.get(1).getSqlTypeName()));
        }
        SqlCall call = (SqlCall)operands.get(0);
        assert (call.getOperator().getKind().equals((Object)SqlKind.ROW)) : "CAST column list argument is not a RowExpression call";
        throw QueryException.error((String)"Cannot convert ROW to JSON");
    }

    private void validateSelect(SqlSelect select, SqlValidatorScope scope) {
        SqlNode offset;
        SqlNode fetch = select.getFetch();
        if (fetch != null) {
            this.deriveType(scope, fetch);
            fetch.validate(this, this.getEmptyScope());
        }
        if ((offset = select.getOffset()) != null) {
            this.deriveType(scope, offset);
            offset.validate(this, this.getEmptyScope());
        }
    }

    @Override
    protected void addToSelectList(List<SqlNode> list, Set<String> aliases, List<Map.Entry<String, RelDataType>> fieldList, SqlNode exp, SelectScope scope, boolean includeSystemVars) {
        if (this.isHiddenColumn(exp, scope)) {
            return;
        }
        super.addToSelectList(list, aliases, fieldList, exp, scope, includeSystemVars);
    }

    @Override
    protected void validateJoin(SqlJoin join, SqlValidatorScope scope) {
        super.validateJoin(join, scope);
        if (join.getJoinType() == JoinType.FULL) {
            throw QueryException.error((int)1008, (String)"FULL join not supported");
        }
    }

    @Override
    protected SqlSelect createSourceSelectForUpdate(SqlUpdate update) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        Table table = this.extractTable((SqlIdentifier)update.getTargetTable());
        if (table != null) {
            if (table instanceof ViewTable) {
                throw QueryException.error((String)"DML operations not supported for views");
            }
            Object connector = SqlConnectorUtil.getJetSqlConnector(table);
            if (connector.getPrimaryKey(table).isEmpty()) {
                throw QueryException.error((String)("Cannot UPDATE " + update.getTargetTable() + ": it doesn't have a primary key"));
            }
            table.getFields().forEach(field -> selectList.add(new SqlIdentifier(field.getName(), SqlParserPos.ZERO)));
        }
        int ordinal = 0;
        for (SqlNode exp : update.getSourceExpressionList()) {
            String alias = SqlUtil.deriveAliasFromOrdinal(ordinal);
            selectList.add(SqlValidatorUtil.addAlias(exp, alias));
            ++ordinal;
        }
        SqlNode sourceTable = update.getTargetTable();
        if (update.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, update.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, update.getCondition(), null, null, null, null, null, null, null);
    }

    @Override
    public void validateUpdate(final SqlUpdate update) {
        super.validateUpdate(update);
        SqlNodeList selectList = update.getSourceSelect().getSelectList();
        SqlNodeList sourceExpressionList = update.getSourceExpressionList();
        for (int i = 0; i < sourceExpressionList.size(); ++i) {
            update.getSourceExpressionList().set(i, selectList.get(selectList.size() - sourceExpressionList.size() + i));
        }
        update.getSourceSelect().getSelectList().accept(new SqlBasicVisitor<Void>(){

            @Override
            public Void visit(SqlCall call) {
                if (call.getKind() == SqlKind.SELECT) {
                    throw HazelcastSqlValidator.this.newValidationError(update, ValidatorResource.RESOURCE.updateFromSelectNotSupported());
                }
                return call.getOperator().acceptCall(this, call);
            }
        });
        this.validateUpsertRowType((SqlIdentifier)update.getTargetTable());
    }

    private void validateUpsertRowType(SqlIdentifier table) {
        RelDataType rowType = Objects.requireNonNull(this.getCatalogReader().getTable(table.names)).getRowType();
        for (RelDataTypeField field : rowType.getFieldList()) {
            RelDataType fieldType = field.getType();
            if (!(fieldType instanceof HazelcastObjectType) || !QueryUtils.containsCycles((HazelcastObjectType)fieldType, new HashSet<String>())) continue;
            throw QueryException.error((String)"Upserts are not supported for cyclic data type columns");
        }
    }

    @Override
    protected SqlSelect createSourceSelectForDelete(SqlDelete delete) {
        SqlNodeList selectList = new SqlNodeList(SqlParserPos.ZERO);
        Table table = this.extractTable((SqlIdentifier)delete.getTargetTable());
        if (table != null) {
            if (table instanceof ViewTable) {
                throw QueryException.error((String)"DML operations not supported for views");
            }
            Object connector = SqlConnectorUtil.getJetSqlConnector(table);
            connector.getPrimaryKey(table).forEach(name -> selectList.add(new SqlIdentifier((String)name, SqlParserPos.ZERO)));
            if (selectList.isEmpty()) {
                throw QueryException.error((String)("Cannot DELETE from " + delete.getTargetTable() + ": it doesn't have a primary key"));
            }
        }
        SqlNode sourceTable = delete.getTargetTable();
        if (delete.getAlias() != null) {
            sourceTable = SqlValidatorUtil.addAlias(sourceTable, delete.getAlias().getSimple());
        }
        return new SqlSelect(SqlParserPos.ZERO, null, selectList, sourceTable, delete.getCondition(), null, null, null, null, null, null, null);
    }

    private Table extractTable(SqlIdentifier identifier) {
        SqlValidatorTable validatorTable = this.getCatalogReader().getTable(identifier.names);
        return validatorTable == null ? null : (Table)validatorTable.unwrap(HazelcastTable.class).getTarget();
    }

    @Override
    public RelDataType deriveTypeImpl(SqlValidatorScope scope, SqlNode operand) {
        RelDataType literalType;
        if (operand.getKind() == SqlKind.LITERAL && (literalType = LiteralUtils.literalType(operand, (HazelcastTypeFactory)this.typeFactory)) != null) {
            return literalType;
        }
        return super.deriveTypeImpl(scope, operand);
    }

    @Override
    public void validateLiteral(SqlLiteral literal) {
        if (literal instanceof SqlIntervalLiteral) {
            super.validateLiteral(literal);
        }
    }

    @Override
    public void validateDynamicParam(SqlDynamicParam dynamicParam) {
        this.parameterPositionMap.put(dynamicParam.getIndex(), dynamicParam.getParserPosition());
    }

    @Override
    public void validateCall(SqlCall call, SqlValidatorScope scope) {
        this.deriveType(scope, call);
        super.validateCall(call, scope);
    }

    @Override
    protected void validateTableFunction(SqlCall node, SqlValidatorScope scope, RelDataType targetRowType) {
        SqlBasicCall call;
        SqlOperator operator;
        SqlNode sqlNode;
        if (this.ssc.isSecurityEnabled() && node instanceof SqlBasicCall && !node.getOperandList().isEmpty() && (sqlNode = node.getOperandList().get(0)) instanceof SqlBasicCall && (operator = (call = (SqlBasicCall)sqlNode).getOperator()) instanceof HazelcastDynamicTableFunction) {
            HazelcastDynamicTableFunction f = (HazelcastDynamicTableFunction)operator;
            for (Permission permission : f.permissions(call, this)) {
                this.ssc.checkPermission(permission);
            }
        }
        super.validateTableFunction(node, scope, targetRowType);
    }

    @Override
    protected SqlNode performUnconditionalRewrites(SqlNode node, boolean underFrom) {
        SqlNode rewritten = super.performUnconditionalRewrites(node, underFrom);
        if (rewritten != null && rewritten.isA(SqlKind.TOP_LEVEL)) {
            rewritten.accept(this.rewriteVisitor);
            rewritten.accept(this.tableOperatorWrapper);
        }
        return rewritten;
    }

    @Override
    public HazelcastTypeCoercion getTypeCoercion() {
        return (HazelcastTypeCoercion)super.getTypeCoercion();
    }

    public void setParameterConverter(int ordinal, ParameterConverter parameterConverter) {
        this.parameterConverterMap.put(ordinal, parameterConverter);
    }

    public Object getArgumentAt(int index) {
        ParameterConverter parameterConverter = this.parameterConverterMap.get(index);
        Object argument = this.arguments.get(index);
        return parameterConverter.convert(argument);
    }

    public Object getRawArgumentAt(int index) {
        return this.arguments.get(index);
    }

    public ParameterConverter[] getParameterConverters(SqlNode node) {
        RelDataType rowType = this.getParameterRowType(node);
        ParameterConverter[] res = new ParameterConverter[rowType.getFieldCount()];
        for (int i = 0; i < res.length; ++i) {
            ParameterConverter converter = this.parameterConverterMap.get(i);
            if (converter == null) {
                QueryDataType targetType = HazelcastTypeUtils.toHazelcastType(rowType.getFieldList().get(i).getType());
                converter = AbstractParameterConverter.from(targetType, i, this.parameterPositionMap.get(i));
            }
            res[i] = converter;
        }
        return res;
    }

    private boolean isHiddenColumn(SqlNode node, SelectScope scope) {
        if (!(node instanceof SqlIdentifier)) {
            return false;
        }
        SqlIdentifier identifier = (SqlIdentifier)node;
        String fieldName = this.extractFieldName(identifier, scope);
        if (fieldName == null) {
            return false;
        }
        SqlValidatorTable table = scope.fullyQualify((SqlIdentifier)identifier).namespace.getTable();
        if (table == null) {
            return false;
        }
        HazelcastTable unwrappedTable = table.unwrap(HazelcastTable.class);
        if (unwrappedTable == null) {
            return false;
        }
        return unwrappedTable.isHidden(fieldName);
    }

    private String extractFieldName(SqlIdentifier identifier, SelectScope scope) {
        SqlCall call = this.makeNullaryCall(identifier);
        if (call != null) {
            return null;
        }
        SqlQualified qualified = scope.fullyQualify(identifier);
        ImmutableList<String> names = qualified.identifier.names;
        if (names.size() < 2) {
            return null;
        }
        return Util.last(names);
    }

    @Override
    public CalciteContextException newValidationError(SqlNode node, Resources.ExInst<SqlValidatorException> e) {
        assert (node != null);
        CalciteContextException exception = SqlUtil.newContextException(node.getParserPosition(), e);
        if (OBJECT_NOT_FOUND.equals(ResourceUtil.key(e)) || OBJECT_NOT_FOUND_WITHIN.equals(ResourceUtil.key(e))) {
            Object[] arguments = ResourceUtil.args(e);
            String identifier = arguments != null && arguments.length > 0 ? String.valueOf(arguments[0]) : null;
            Mapping mapping = identifier != null && this.hasMapAccess(identifier) ? this.iMapResolver.resolve(identifier) : null;
            String sql = mapping != null ? SqlCreateMapping.unparse(mapping) : null;
            String message = sql != null ? ValidatorResource.imapNotMapped(e.str(), identifier, sql) : e.str();
            throw QueryException.error((int)1010, (String)message, (Throwable)exception, (String)sql);
        }
        return exception;
    }

    private boolean hasMapAccess(String map) {
        if (!this.ssc.isSecurityEnabled()) {
            return true;
        }
        MapPermission permission = new MapPermission(map, new String[]{"read"});
        try {
            this.ssc.checkPermission((Permission)permission);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static final class TableOperatorWrapper
    extends SqlShuttle {
        private TableOperatorWrapper() {
        }

        @Override
        public SqlNode visit(@Nonnull SqlCall call) {
            if (call instanceof SqlJoin) {
                SqlJoin join = (SqlJoin)call;
                join.setLeft(this.wrapTableOperator(join.getLeft()));
                join.setRight(this.wrapTableOperator(join.getRight()));
                return join;
            }
            return super.visit(call);
        }

        private SqlNode wrapTableOperator(SqlNode node) {
            if (node instanceof SqlCall) {
                SqlCall call = (SqlCall)node;
                if (call.getOperator().getKind() == SqlKind.AS) {
                    call.setOperand(0, this.wrapTableOperator(call.getOperandList().get(0)));
                    return call;
                }
                if (call.getOperator().getKind() == SqlKind.COLLECTION_TABLE) {
                    return new SqlSelect(call.getParserPosition(), null, SqlNodeList.SINGLETON_STAR, super.visit(call), null, null, null, null, null, null, null, null);
                }
            }
            return node.accept(this);
        }
    }
}

