/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.jet.sql.impl.parse.SqlAlterJob;
import com.hazelcast.jet.sql.impl.parse.SqlAnalyzeStatement;
import com.hazelcast.jet.sql.impl.parse.SqlCreateDataConnection;
import com.hazelcast.jet.sql.impl.parse.SqlCreateJob;
import com.hazelcast.jet.sql.impl.parse.SqlCreateSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlDropDataConnection;
import com.hazelcast.jet.sql.impl.parse.SqlDropJob;
import com.hazelcast.jet.sql.impl.parse.SqlDropSnapshot;
import com.hazelcast.jet.sql.impl.parse.SqlOption;
import com.hazelcast.jet.sql.impl.parse.SqlShowStatement;
import com.hazelcast.jet.sql.impl.schema.HazelcastDynamicTableFunction;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.ValidatorResource;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.runtime.CalciteContextException;
import com.hazelcast.shaded.org.apache.calcite.runtime.Resources;
import com.hazelcast.shaded.org.apache.calcite.sql.JoinConditionType;
import com.hazelcast.shaded.org.apache.calcite.sql.JoinType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlBasicTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDataTypeSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJoin;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonConstructorNullClause;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonEmptyOrError;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonValueEmptyOrErrorBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonValueReturning;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlSelectKeyword;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUserDefinedTypeNameSpec;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.shaded.org.apache.calcite.sql.fun.SqlTrimFunction;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.shaded.org.apache.calcite.sql.util.SqlBasicVisitor;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorException;
import java.util.HashSet;
import java.util.Set;

public final class UnsupportedOperationVisitor
extends SqlBasicVisitor<Void> {
    private static final Set<SqlKind> SUPPORTED_KINDS = new HashSet<SqlKind>();
    private static final Set<SqlOperator> SUPPORTED_OPERATORS;
    private static final Set<Enum<?>> SUPPORTED_SYMBOLS;
    private final boolean isValidated;
    private SqlSelect topLevelSelect;

    public UnsupportedOperationVisitor(boolean isValidated) {
        this.isValidated = isValidated;
    }

    @Override
    public Void visit(SqlCall call) {
        if (!(call.getOperator() instanceof HazelcastDynamicTableFunction)) {
            this.processCall(call);
            call.getOperator().acceptCall(this, call);
        }
        return null;
    }

    @Override
    public Void visit(SqlDataTypeSpec type) {
        Object typeName;
        if (type.getTypeNameSpec() instanceof SqlUserDefinedTypeNameSpec && HazelcastTypeUtils.isObjectIdentifier((SqlIdentifier)(typeName = type.getTypeName()))) {
            return null;
        }
        if (HazelcastTypeUtils.isJsonIdentifier(type.getTypeName())) {
            return null;
        }
        if (!(type.getTypeNameSpec() instanceof SqlBasicTypeNameSpec)) {
            throw UnsupportedOperationVisitor.error((SqlNode)type, ValidatorResource.RESOURCE.error("Complex type specifications are not supported"));
        }
        typeName = SqlTypeName.get(type.getTypeName().getSimple());
        switch (1.$SwitchMap$org$apache$calcite$sql$type$SqlTypeName[((Enum)typeName).ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return null;
            }
        }
        throw UnsupportedOperationVisitor.error((SqlNode)type, ValidatorResource.RESOURCE.notSupported(((SqlTypeName)((Object)typeName)).getName()));
    }

    @Override
    public Void visit(SqlLiteral literal) {
        SqlTypeName typeName = literal.getTypeName();
        if (HazelcastTypeUtils.isIntervalType(typeName)) {
            return null;
        }
        switch (typeName) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case REAL: 
            case DOUBLE: 
            case VARCHAR: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case NULL: 
            case CHAR: 
            case ANY: 
            case UNKNOWN: {
                return null;
            }
            case SYMBOL: {
                Enum symbolValue = (Enum)literal.getValue();
                if (SUPPORTED_SYMBOLS.contains(symbolValue)) {
                    return null;
                }
                throw UnsupportedOperationVisitor.error((SqlNode)literal, ValidatorResource.RESOURCE.error(symbolValue + " is not supported"));
            }
        }
        throw UnsupportedOperationVisitor.error((SqlNode)literal, ValidatorResource.RESOURCE.error(typeName + " literals are not supported"));
    }

    private void processCall(SqlCall call) {
        SqlKind kind = call.getKind();
        if (SUPPORTED_KINDS.contains((Object)kind)) {
            return;
        }
        switch (kind) {
            case SELECT: {
                this.processSelect((SqlSelect)call);
                break;
            }
            case UPDATE: 
            case DELETE: {
                break;
            }
            case JOIN: {
                this.processJoin((SqlJoin)call);
                break;
            }
            case OTHER: 
            case OTHER_FUNCTION: 
            case EXTRACT: 
            case POSITION: 
            case EXISTS: {
                this.processOther(call);
                break;
            }
            case OTHER_DDL: {
                this.processOtherDdl(call);
                break;
            }
            case ORDER_BY: 
            case EXPLICIT_TABLE: 
            case MAP_VALUE_CONSTRUCTOR: {
                if (!this.isValidated) break;
                throw this.unsupported((SqlNode)call, kind);
            }
            default: {
                throw this.unsupported((SqlNode)call, kind);
            }
        }
    }

    private void processSelect(SqlSelect select) {
        if (this.topLevelSelect == null) {
            this.topLevelSelect = select;
        } else if (select.getFetch() != null || select.getOffset() != null) {
            throw UnsupportedOperationVisitor.error((SqlNode)select, "FETCH/OFFSET is only supported for the top-level SELECT");
        }
    }

    private void processJoin(SqlJoin join) {
        JoinType joinType = join.getJoinType();
        if (joinType != JoinType.INNER && joinType != JoinType.COMMA && joinType != JoinType.CROSS && joinType != JoinType.LEFT && joinType != JoinType.RIGHT) {
            throw this.unsupported((SqlNode)join, joinType.name() + " join");
        }
    }

    private void processOther(SqlCall call) {
        if (!this.isValidated) {
            return;
        }
        SqlOperator operator = call.getOperator();
        if (SUPPORTED_OPERATORS.contains(operator)) {
            return;
        }
        throw this.unsupported((SqlNode)call, operator.getName());
    }

    private void processOtherDdl(SqlCall call) {
        if (!(call instanceof SqlCreateJob || call instanceof SqlDropJob || call instanceof SqlAlterJob || call instanceof SqlCreateSnapshot || call instanceof SqlDropSnapshot || call instanceof SqlCreateDataConnection || call instanceof SqlDropDataConnection)) {
            throw this.unsupported((SqlNode)call, "OTHER DDL class (" + call.getClass().getSimpleName() + ")");
        }
    }

    private CalciteContextException unsupported(SqlNode node, SqlKind kind) {
        return this.unsupported(node, kind.sql.replace('_', ' '));
    }

    private CalciteContextException unsupported(SqlNode node, String name) {
        return UnsupportedOperationVisitor.error(node, ValidatorResource.RESOURCE.notSupported(name));
    }

    private static CalciteContextException error(SqlNode node, Resources.ExInst<SqlValidatorException> error) {
        return SqlUtil.newContextException(node.getParserPosition(), error);
    }

    public static CalciteContextException error(SqlNode node, String name) {
        return UnsupportedOperationVisitor.error(node, ValidatorResource.RESOURCE.error(name));
    }

    static {
        SUPPORTED_KINDS.add(SqlKind.AND);
        SUPPORTED_KINDS.add(SqlKind.OR);
        SUPPORTED_KINDS.add(SqlKind.NOT);
        SUPPORTED_KINDS.add(SqlKind.IN);
        SUPPORTED_KINDS.add(SqlKind.NOT_IN);
        SUPPORTED_KINDS.add(SqlKind.BETWEEN);
        SUPPORTED_KINDS.add(SqlKind.EXISTS);
        SUPPORTED_KINDS.add(SqlKind.PLUS);
        SUPPORTED_KINDS.add(SqlKind.MINUS);
        SUPPORTED_KINDS.add(SqlKind.TIMES);
        SUPPORTED_KINDS.add(SqlKind.DIVIDE);
        SUPPORTED_KINDS.add(SqlKind.MOD);
        SUPPORTED_KINDS.add(SqlKind.MINUS_PREFIX);
        SUPPORTED_KINDS.add(SqlKind.PLUS_PREFIX);
        SUPPORTED_KINDS.add(SqlKind.IS_TRUE);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_TRUE);
        SUPPORTED_KINDS.add(SqlKind.IS_FALSE);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_FALSE);
        SUPPORTED_KINDS.add(SqlKind.IS_NULL);
        SUPPORTED_KINDS.add(SqlKind.IS_NOT_NULL);
        SUPPORTED_KINDS.add(SqlKind.EQUALS);
        SUPPORTED_KINDS.add(SqlKind.NOT_EQUALS);
        SUPPORTED_KINDS.add(SqlKind.LESS_THAN);
        SUPPORTED_KINDS.add(SqlKind.GREATER_THAN);
        SUPPORTED_KINDS.add(SqlKind.GREATER_THAN_OR_EQUAL);
        SUPPORTED_KINDS.add(SqlKind.LESS_THAN_OR_EQUAL);
        SUPPORTED_KINDS.add(SqlKind.AS);
        SUPPORTED_KINDS.add(SqlKind.CAST);
        SUPPORTED_KINDS.add(SqlKind.CEIL);
        SUPPORTED_KINDS.add(SqlKind.FLOOR);
        SUPPORTED_KINDS.add(SqlKind.LIKE);
        SUPPORTED_KINDS.add(SqlKind.TRIM);
        SUPPORTED_KINDS.add(SqlKind.CASE);
        SUPPORTED_KINDS.add(SqlKind.NULLIF);
        SUPPORTED_KINDS.add(SqlKind.COALESCE);
        SUPPORTED_KINDS.add(SqlKind.UNION);
        SUPPORTED_KINDS.add(SqlKind.EXPLAIN);
        SUPPORTED_KINDS.add(SqlKind.COUNT);
        SUPPORTED_KINDS.add(SqlKind.MIN);
        SUPPORTED_KINDS.add(SqlKind.MAX);
        SUPPORTED_KINDS.add(SqlKind.SUM);
        SUPPORTED_KINDS.add(SqlKind.AVG);
        SUPPORTED_KINDS.add(SqlKind.CREATE_TABLE);
        SUPPORTED_KINDS.add(SqlKind.CREATE_VIEW);
        SUPPORTED_KINDS.add(SqlKind.DROP_TABLE);
        SUPPORTED_KINDS.add(SqlKind.CREATE_INDEX);
        SUPPORTED_KINDS.add(SqlKind.DROP_VIEW);
        SUPPORTED_KINDS.add(SqlKind.COLUMN_DECL);
        SUPPORTED_KINDS.add(SqlKind.CREATE_TYPE);
        SUPPORTED_KINDS.add(SqlKind.DROP_TYPE);
        SUPPORTED_KINDS.add(SqlKind.ROW);
        SUPPORTED_KINDS.add(SqlKind.VALUES);
        SUPPORTED_KINDS.add(SqlKind.INSERT);
        SUPPORTED_KINDS.add(SqlKind.COLLECTION_TABLE);
        SUPPORTED_KINDS.add(SqlKind.ARGUMENT_ASSIGNMENT);
        SUPPORTED_KINDS.add(SqlKind.DESCRIPTOR);
        SUPPORTED_KINDS.add(SqlKind.DESCENDING);
        SUPPORTED_KINDS.add(SqlKind.JSON_ARRAYAGG);
        SUPPORTED_KINDS.add(SqlKind.JSON_OBJECTAGG);
        SUPPORTED_KINDS.add(SqlKind.WITHIN_GROUP);
        SUPPORTED_KINDS.add(SqlKind.DOT);
        SUPPORTED_OPERATORS = new HashSet<SqlOperator>();
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.POWER);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.SQUARE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.SQRT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.CBRT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.COS);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.SIN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.TAN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.COT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ACOS);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ASIN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ATAN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ATAN2);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.EXP);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.LN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.LOG10);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.RAND);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ABS);
        SUPPORTED_OPERATORS.add(SqlStdOperatorTable.PI);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.SIGN);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.DEGREES);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.RADIANS);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ROUND);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.TRUNCATE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.ASCII);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.INITCAP);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.CHAR_LENGTH);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.CHARACTER_LENGTH);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.LENGTH);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.LOWER);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.UPPER);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.CONCAT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.CONCAT_WS);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.SUBSTRING);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.LTRIM);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.RTRIM);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.BTRIM);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.REPLACE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.POSITION);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.NOT_LIKE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.EXTRACT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.TO_TIMESTAMP_TZ);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.TO_EPOCH_MILLIS);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.TO_CHAR);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.IMPOSE_ORDER);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.TUMBLE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.HOP);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.JSON_QUERY);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.JSON_VALUE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.JSON_OBJECT);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.JSON_ARRAY);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.JSON_ARRAYAGG_ABSENT_ON_NULL);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.JSON_ARRAYAGG_NULL_ON_NULL);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.JSON_OBJECTAGG_ABSENT_ON_NULL);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.JSON_OBJECTAGG_NULL_ON_NULL);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.WITHIN_GROUP);
        SUPPORTED_OPERATORS.add(SqlOption.OPERATOR);
        SUPPORTED_OPERATORS.add(SqlCreateDataConnection.CREATE_DATA_CONNECTION);
        SUPPORTED_OPERATORS.add(SqlDropDataConnection.DROP_DATA_CONNECTION);
        SUPPORTED_OPERATORS.add(SqlShowStatement.SHOW_MAPPINGS);
        SUPPORTED_OPERATORS.add(SqlShowStatement.SHOW_VIEWS);
        SUPPORTED_OPERATORS.add(SqlShowStatement.SHOW_JOBS);
        SUPPORTED_OPERATORS.add(SqlShowStatement.SHOW_TYPES);
        SUPPORTED_OPERATORS.add(SqlShowStatement.SHOW_DATA_CONNECTIONS);
        SUPPORTED_OPERATORS.add(SqlShowStatement.SHOW_RESOURCES);
        SUPPORTED_OPERATORS.add(SqlAnalyzeStatement.OPERATOR);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.GENERATE_SERIES);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.GENERATE_STREAM);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.GET_DDL);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.CSV_FILE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.JSON_FLAT_FILE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.AVRO_FILE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.PARQUET_FILE);
        SUPPORTED_OPERATORS.add(HazelcastSqlOperatorTable.DOT);
        SUPPORTED_SYMBOLS = new HashSet();
        SUPPORTED_SYMBOLS.add(SqlTrimFunction.Flag.LEADING);
        SUPPORTED_SYMBOLS.add(SqlTrimFunction.Flag.TRAILING);
        SUPPORTED_SYMBOLS.add(SqlTrimFunction.Flag.BOTH);
        SUPPORTED_SYMBOLS.add(SqlSelectKeyword.DISTINCT);
        SUPPORTED_SYMBOLS.add(SqlSelectKeyword.ALL);
        SUPPORTED_SYMBOLS.add(JoinType.INNER);
        SUPPORTED_SYMBOLS.add(JoinType.COMMA);
        SUPPORTED_SYMBOLS.add(JoinType.CROSS);
        SUPPORTED_SYMBOLS.add(JoinType.LEFT);
        SUPPORTED_SYMBOLS.add(JoinType.RIGHT);
        SUPPORTED_SYMBOLS.add(JoinConditionType.ON);
        SUPPORTED_SYMBOLS.add(JoinConditionType.NONE);
        SUPPORTED_SYMBOLS.add(JoinConditionType.USING);
        SUPPORTED_SYMBOLS.add(SqlJsonQueryWrapperBehavior.WITHOUT_ARRAY);
        SUPPORTED_SYMBOLS.add(SqlJsonQueryWrapperBehavior.WITH_CONDITIONAL_ARRAY);
        SUPPORTED_SYMBOLS.add(SqlJsonQueryWrapperBehavior.WITH_UNCONDITIONAL_ARRAY);
        SUPPORTED_SYMBOLS.add(SqlJsonQueryEmptyOrErrorBehavior.ERROR);
        SUPPORTED_SYMBOLS.add(SqlJsonQueryEmptyOrErrorBehavior.NULL);
        SUPPORTED_SYMBOLS.add(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_ARRAY);
        SUPPORTED_SYMBOLS.add(SqlJsonQueryEmptyOrErrorBehavior.EMPTY_OBJECT);
        SUPPORTED_SYMBOLS.add(SqlJsonValueReturning.RETURNING);
        SUPPORTED_SYMBOLS.add(SqlJsonValueEmptyOrErrorBehavior.ERROR);
        SUPPORTED_SYMBOLS.add(SqlJsonValueEmptyOrErrorBehavior.NULL);
        SUPPORTED_SYMBOLS.add(SqlJsonValueEmptyOrErrorBehavior.DEFAULT);
        SUPPORTED_SYMBOLS.add(SqlJsonEmptyOrError.EMPTY);
        SUPPORTED_SYMBOLS.add(SqlJsonEmptyOrError.ERROR);
        SUPPORTED_SYMBOLS.add(SqlJsonConstructorNullClause.NULL_ON_NULL);
        SUPPORTED_SYMBOLS.add(SqlJsonConstructorNullClause.ABSENT_ON_NULL);
    }
}

