/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.operators.json;

import com.hazelcast.jet.sql.impl.validate.HazelcastCallBinding;
import com.hazelcast.jet.sql.impl.validate.operand.MultiTypeOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operand.OperandCheckerProgram;
import com.hazelcast.jet.sql.impl.validate.operand.TypedOperandChecker;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.JsonFunctionOperandTypeInference;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastJsonType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCall;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlKind;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.sql.impl.QueryException;

public class HazelcastJsonQueryFunction
extends HazelcastFunction {
    public static final HazelcastJsonQueryFunction INSTANCE = new HazelcastJsonQueryFunction();

    public HazelcastJsonQueryFunction() {
        super("JSON_QUERY", SqlKind.OTHER_FUNCTION, opBinding -> HazelcastJsonType.create(true), new JsonFunctionOperandTypeInference(), SqlFunctionCategory.SYSTEM);
    }

    @Override
    protected boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        return new OperandCheckerProgram(MultiTypeOperandChecker.JSON_OR_VARCHAR, TypedOperandChecker.VARCHAR, TypedOperandChecker.SYMBOL, TypedOperandChecker.SYMBOL, TypedOperandChecker.SYMBOL).check(callBinding, throwOnFailure);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(5);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        ((SqlNode)call.operand(0)).unparse(writer, leftPrec, rightPrec);
        writer.sep(",", true);
        ((SqlNode)call.operand(1)).unparse(writer, leftPrec, rightPrec);
        SqlJsonQueryWrapperBehavior wrapperBehavior = (SqlJsonQueryWrapperBehavior)((Object)((SqlLiteral)call.operand(2)).getValue());
        SqlJsonQueryEmptyOrErrorBehavior onEmpty = (SqlJsonQueryEmptyOrErrorBehavior)((Object)((SqlLiteral)call.operand(3)).getValue());
        SqlJsonQueryEmptyOrErrorBehavior onError = (SqlJsonQueryEmptyOrErrorBehavior)((Object)((SqlLiteral)call.operand(4)).getValue());
        this.unparseWrapperBehavior(wrapperBehavior, writer);
        this.unparseEmptyOrErrorBehavior(onEmpty, writer);
        writer.keyword("ON EMPTY");
        this.unparseEmptyOrErrorBehavior(onError, writer);
        writer.keyword("ON ERROR");
        writer.endFunCall(frame);
    }

    private void unparseWrapperBehavior(SqlJsonQueryWrapperBehavior behavior, SqlWriter writer) {
        switch (behavior) {
            case WITHOUT_ARRAY: {
                writer.keyword("WITHOUT ARRAY WRAPPER");
                break;
            }
            case WITH_UNCONDITIONAL_ARRAY: {
                writer.keyword("WITH UNCONDITIONAL ARRAY WRAPPER");
                break;
            }
            case WITH_CONDITIONAL_ARRAY: {
                writer.keyword("WITH CONDITIONAL ARRAY WRAPPER");
                break;
            }
            default: {
                throw QueryException.error((String)("Unknown WrapperBehavior constant: " + behavior));
            }
        }
    }

    private void unparseEmptyOrErrorBehavior(SqlJsonQueryEmptyOrErrorBehavior behavior, SqlWriter writer) {
        switch (behavior) {
            case ERROR: {
                writer.keyword("ERROR");
                break;
            }
            case NULL: {
                writer.keyword("NULL");
                break;
            }
            case EMPTY_ARRAY: {
                writer.keyword("EMPTY ARRAY");
                break;
            }
            case EMPTY_OBJECT: {
                writer.keyword("EMPTY OBJECT");
                break;
            }
            default: {
                throw QueryException.error((String)("Unknown EmptyOrErrorBehavior constant: " + behavior));
            }
        }
    }
}

