/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.antlr.v4.runtime.tree;

import com.hazelcast.shaded.org.antlr.v4.runtime.CommonToken;
import com.hazelcast.shaded.org.antlr.v4.runtime.Parser;
import com.hazelcast.shaded.org.antlr.v4.runtime.ParserRuleContext;
import com.hazelcast.shaded.org.antlr.v4.runtime.RuleContext;
import com.hazelcast.shaded.org.antlr.v4.runtime.Token;
import com.hazelcast.shaded.org.antlr.v4.runtime.misc.Interval;
import com.hazelcast.shaded.org.antlr.v4.runtime.misc.Predicate;
import com.hazelcast.shaded.org.antlr.v4.runtime.misc.Utils;
import com.hazelcast.shaded.org.antlr.v4.runtime.tree.ErrorNode;
import com.hazelcast.shaded.org.antlr.v4.runtime.tree.ParseTree;
import com.hazelcast.shaded.org.antlr.v4.runtime.tree.TerminalNode;
import com.hazelcast.shaded.org.antlr.v4.runtime.tree.TerminalNodeImpl;
import com.hazelcast.shaded.org.antlr.v4.runtime.tree.Tree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Trees {
    public static String toStringTree(Tree t2) {
        return Trees.toStringTree(t2, (List<String>)null);
    }

    public static String toStringTree(Tree t2, Parser recog) {
        String[] ruleNames = recog != null ? recog.getRuleNames() : null;
        List<String> ruleNamesList = ruleNames != null ? Arrays.asList(ruleNames) : null;
        return Trees.toStringTree(t2, ruleNamesList);
    }

    public static String toStringTree(Tree t2, List<String> ruleNames) {
        String s2 = Utils.escapeWhitespace(Trees.getNodeText(t2, ruleNames), false);
        if (t2.getChildCount() == 0) {
            return s2;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        s2 = Utils.escapeWhitespace(Trees.getNodeText(t2, ruleNames), false);
        buf.append(s2);
        buf.append(' ');
        for (int i = 0; i < t2.getChildCount(); ++i) {
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(Trees.toStringTree(t2.getChild(i), ruleNames));
        }
        buf.append(")");
        return buf.toString();
    }

    public static String getNodeText(Tree t2, Parser recog) {
        String[] ruleNames = recog != null ? recog.getRuleNames() : null;
        List<String> ruleNamesList = ruleNames != null ? Arrays.asList(ruleNames) : null;
        return Trees.getNodeText(t2, ruleNamesList);
    }

    public static String getNodeText(Tree t2, List<String> ruleNames) {
        Object payload;
        if (ruleNames != null) {
            Token symbol;
            if (t2 instanceof RuleContext) {
                int ruleIndex = ((RuleContext)t2).getRuleContext().getRuleIndex();
                String ruleName = ruleNames.get(ruleIndex);
                int altNumber = ((RuleContext)t2).getAltNumber();
                if (altNumber != 0) {
                    return ruleName + ":" + altNumber;
                }
                return ruleName;
            }
            if (t2 instanceof ErrorNode) {
                return t2.toString();
            }
            if (t2 instanceof TerminalNode && (symbol = ((TerminalNode)t2).getSymbol()) != null) {
                String s2 = symbol.getText();
                return s2;
            }
        }
        if ((payload = t2.getPayload()) instanceof Token) {
            return ((Token)payload).getText();
        }
        return t2.getPayload().toString();
    }

    public static List<Tree> getChildren(Tree t2) {
        ArrayList<Tree> kids = new ArrayList<Tree>();
        for (int i = 0; i < t2.getChildCount(); ++i) {
            kids.add(t2.getChild(i));
        }
        return kids;
    }

    public static List<? extends Tree> getAncestors(Tree t2) {
        if (t2.getParent() == null) {
            return Collections.emptyList();
        }
        ArrayList<Tree> ancestors = new ArrayList<Tree>();
        for (t2 = t2.getParent(); t2 != null; t2 = t2.getParent()) {
            ancestors.add(0, t2);
        }
        return ancestors;
    }

    public static boolean isAncestorOf(Tree t2, Tree u) {
        if (t2 == null || u == null || t2.getParent() == null) {
            return false;
        }
        for (Tree p = u.getParent(); p != null; p = p.getParent()) {
            if (t2 != p) continue;
            return true;
        }
        return false;
    }

    public static Collection<ParseTree> findAllTokenNodes(ParseTree t2, int ttype) {
        return Trees.findAllNodes(t2, ttype, true);
    }

    public static Collection<ParseTree> findAllRuleNodes(ParseTree t2, int ruleIndex) {
        return Trees.findAllNodes(t2, ruleIndex, false);
    }

    public static List<ParseTree> findAllNodes(ParseTree t2, int index, boolean findTokens) {
        ArrayList<ParseTree> nodes = new ArrayList<ParseTree>();
        Trees._findAllNodes(t2, index, findTokens, nodes);
        return nodes;
    }

    public static void _findAllNodes(ParseTree t2, int index, boolean findTokens, List<? super ParseTree> nodes) {
        ParserRuleContext ctx;
        if (findTokens && t2 instanceof TerminalNode) {
            TerminalNode tnode = (TerminalNode)t2;
            if (tnode.getSymbol().getType() == index) {
                nodes.add(t2);
            }
        } else if (!findTokens && t2 instanceof ParserRuleContext && (ctx = (ParserRuleContext)t2).getRuleIndex() == index) {
            nodes.add(t2);
        }
        for (int i = 0; i < t2.getChildCount(); ++i) {
            Trees._findAllNodes(t2.getChild(i), index, findTokens, nodes);
        }
    }

    public static List<ParseTree> getDescendants(ParseTree t2) {
        ArrayList<ParseTree> nodes = new ArrayList<ParseTree>();
        nodes.add(t2);
        int n = t2.getChildCount();
        for (int i = 0; i < n; ++i) {
            nodes.addAll(Trees.getDescendants(t2.getChild(i)));
        }
        return nodes;
    }

    public static List<ParseTree> descendants(ParseTree t2) {
        return Trees.getDescendants(t2);
    }

    public static ParserRuleContext getRootOfSubtreeEnclosingRegion(ParseTree t2, int startTokenIndex, int stopTokenIndex) {
        ParserRuleContext r;
        int n = t2.getChildCount();
        for (int i = 0; i < n; ++i) {
            ParseTree child = t2.getChild(i);
            ParserRuleContext r2 = Trees.getRootOfSubtreeEnclosingRegion(child, startTokenIndex, stopTokenIndex);
            if (r2 == null) continue;
            return r2;
        }
        if (t2 instanceof ParserRuleContext && startTokenIndex >= (r = (ParserRuleContext)t2).getStart().getTokenIndex() && (r.getStop() == null || stopTokenIndex <= r.getStop().getTokenIndex())) {
            return r;
        }
        return null;
    }

    public static void stripChildrenOutOfRange(ParserRuleContext t2, ParserRuleContext root, int startIndex, int stopIndex) {
        if (t2 == null) {
            return;
        }
        for (int i = 0; i < t2.getChildCount(); ++i) {
            ParseTree child = t2.getChild(i);
            Interval range = child.getSourceInterval();
            if (!(child instanceof ParserRuleContext) || range.b >= startIndex && range.a <= stopIndex || !Trees.isAncestorOf(child, root)) continue;
            CommonToken abbrev = new CommonToken(0, "...");
            t2.children.set(i, new TerminalNodeImpl(abbrev));
        }
    }

    public static Tree findNodeSuchThat(Tree t2, Predicate<Tree> pred) {
        if (pred.test(t2)) {
            return t2;
        }
        if (t2 == null) {
            return null;
        }
        int n = t2.getChildCount();
        for (int i = 0; i < n; ++i) {
            Tree u = Trees.findNodeSuchThat(t2.getChild(i), pred);
            if (u == null) continue;
            return u;
        }
        return null;
    }

    private Trees() {
    }
}

