/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.adapter.enumerable;

import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.LazyAggregateLambdaFactory;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Linq4j;
import com.hazelcast.shaded.org.apache.calcite.linq4j.function.Function1;
import com.hazelcast.shaded.org.apache.calcite.linq4j.function.Function2;
import java.util.Comparator;
import java.util.List;

public class SourceSorter<TAccumulate, TSource, TSortKey>
implements LazyAggregateLambdaFactory.LazyAccumulator<TAccumulate, TSource> {
    private final Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder;
    private final Function1<TSource, TSortKey> keySelector;
    private final Comparator<TSortKey> comparator;

    public SourceSorter(Function2<TAccumulate, TSource, TAccumulate> accumulatorAdder, Function1<TSource, TSortKey> keySelector, Comparator<TSortKey> comparator) {
        this.accumulatorAdder = accumulatorAdder;
        this.keySelector = keySelector;
        this.comparator = comparator;
    }

    @Override
    public void accumulate(Iterable<TSource> sourceIterable, TAccumulate accumulator) {
        this.sortAndAccumulate(sourceIterable, accumulator);
    }

    private void sortAndAccumulate(Iterable<TSource> sourceIterable, TAccumulate accumulator) {
        List sorted = Linq4j.asEnumerable(sourceIterable).orderBy(this.keySelector, this.comparator).toList();
        TAccumulate accumulator1 = accumulator;
        for (Object source : sorted) {
            accumulator1 = this.accumulatorAdder.apply(accumulator1, source);
        }
    }
}

